/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class MonitoredFileOutputStream
extends FileOutputStream {
    private int bytesWritten = 0;

    public MonitoredFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        super(file, bl);
    }

    public MonitoredFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public MonitoredFileOutputStream(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public MonitoredFileOutputStream(String string, boolean bl) throws FileNotFoundException {
        super(string, bl);
    }

    public MonitoredFileOutputStream(String string) throws FileNotFoundException {
        super(string);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.bytesWritten += n2;
        super.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.bytesWritten += byArray.length;
        super.write(byArray);
    }

    @Override
    public void write(int n) throws IOException {
        ++this.bytesWritten;
        super.write(n);
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public byte[] getBytesWrittenAsArray() {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            int n = (3 - i) * 8;
            byArray[i] = (byte)((this.bytesWritten & 255 << n) >> n);
        }
        return byArray;
    }
}

