/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.gc.MMObjectAccessBarrier;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.InvocationTargetException;

class MMObjectAccessBarrier_V1
extends MMObjectAccessBarrier {
    private int shift = 0;

    protected MMObjectAccessBarrier_V1() throws CorruptDataException {
        if (J9ObjectHelper.compressObjectReferences) {
            try {
                J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
                UDATA uDATA = (UDATA)J9JavaVMPointer.class.getMethod("compressedPointersShift", new Class[0]).invoke((Object)j9JavaVMPointer, new Object[0]);
                this.shift = uDATA.intValue();
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error initializing the object access barrier", corruptDataException, true);
            }
            catch (IllegalAccessException illegalAccessException) {
                CorruptDataException corruptDataException = new CorruptDataException(illegalAccessException.toString(), illegalAccessException);
                EventManager.raiseCorruptDataEvent("Error retrieving compressedPointersShift", corruptDataException, true);
            }
            catch (InvocationTargetException invocationTargetException) {
                CorruptDataException corruptDataException = new CorruptDataException(invocationTargetException.toString(), invocationTargetException);
                EventManager.raiseCorruptDataEvent("Error retrieving compressedPointersShift", corruptDataException, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                CorruptDataException corruptDataException = new CorruptDataException(noSuchMethodException.toString(), noSuchMethodException);
                EventManager.raiseCorruptDataEvent("Error retrieving compressedPointersShift", corruptDataException, true);
            }
            catch (SecurityException securityException) {
                CorruptDataException corruptDataException = new CorruptDataException(securityException.toString(), securityException);
                EventManager.raiseCorruptDataEvent("Error retrieving compressedPointersShift", corruptDataException, true);
            }
        }
    }

    @Override
    public J9ObjectPointer getFinalizeLink(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = J9ObjectHelper.clazz(j9ObjectPointer).finalizeLinkOffset();
        if (uDATA.eq(0L)) {
            return J9ObjectPointer.NULL;
        }
        return ObjectReferencePointer.cast(j9ObjectPointer.addOffset(uDATA)).at(0L);
    }

    @Override
    public J9ObjectPointer getOwnableSynchronizerLink(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = MMObjectAccessBarrier_V1.getExtensions().accessBarrier()._ownableSynchronizerLinkOffset();
        J9ObjectPointer j9ObjectPointer2 = ObjectReferencePointer.cast(j9ObjectPointer.addOffset(uDATA)).at(0L);
        if (j9ObjectPointer.equals(j9ObjectPointer2)) {
            return J9ObjectPointer.NULL;
        }
        return j9ObjectPointer2;
    }

    @Override
    public J9ObjectPointer isObjectInOwnableSynchronizerList(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = MMObjectAccessBarrier_V1.getExtensions().accessBarrier()._ownableSynchronizerLinkOffset();
        return ObjectReferencePointer.cast(j9ObjectPointer.addOffset(uDATA)).at(0L);
    }

    @Override
    public J9ObjectPointer getReferenceLink(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = MMObjectAccessBarrier_V1.getExtensions().accessBarrier()._referenceLinkOffset();
        return ObjectReferencePointer.cast(j9ObjectPointer.addOffset(uDATA)).at(0L);
    }

    @Override
    public I32 getObjectHashCode(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return ObjectModel.getObjectHashCode(j9ObjectPointer);
    }

    @Override
    public J9ObjectMonitorPointer getLockword(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return this.getMonitor(j9ObjectPointer).getLockword();
    }

    @Override
    public ObjectMonitor getMonitor(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return ObjectMonitor.fromJ9Object(j9ObjectPointer);
    }

    @Override
    public J9ObjectPointer convertPointerFromToken(long l) {
        if (l == 0L) {
            return J9ObjectPointer.NULL;
        }
        if (J9ObjectHelper.compressObjectReferences) {
            UDATA uDATA = new UDATA(l & 0xFFFFFFFFL);
            uDATA = uDATA.leftShift(this.shift);
            return J9ObjectPointer.cast(uDATA);
        }
        return J9ObjectPointer.cast(l);
    }

    @Override
    public long convertTokenFromPointer(J9ObjectPointer j9ObjectPointer) {
        if (j9ObjectPointer.isNull()) {
            return 0L;
        }
        UDATA uDATA = UDATA.cast(j9ObjectPointer);
        if (J9ObjectHelper.compressObjectReferences) {
            uDATA = uDATA.rightShift(this.shift);
        }
        return uDATA.longValue();
    }
}

