/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.walkers.HeapWalkerEvents;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

public class HeapWalker
implements IEventListener {
    private static final int STATE_INIT = 0;
    private static final int STATE_OBJECT_LIVE = 1;
    private static final int STATE_OBJECT_DEAD = 2;
    private static final int STATE_SCANNING_LIVE = 3;
    private static final int STATE_SCANNING_DEAD = 4;
    private static final int STATE_FINISHED = 5;
    private int state = 0;
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private final GCHeapRegionDescriptor region;
    private final GCObjectHeapIterator heapIterator;
    private int segmentIndex = -1;
    private long objectCount = 0L;
    private long totalObjectCount = 0L;
    private boolean lastObjectCorrupt = false;
    private final HeapWalkerEvents events;
    private Set<ObjectMonitor> localFlatLockedMonitors;
    private static Map<GCHeapRegionDescriptor, Set<ObjectMonitor>> flatLockedMonitorsByRegion = new HashMap<GCHeapRegionDescriptor, Set<ObjectMonitor>>();
    private static SortedSet<ObjectMonitor> flatLockedMonitors;

    public HeapWalker(J9JavaVMPointer j9JavaVMPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor, HeapWalkerEvents heapWalkerEvents) throws CorruptDataException {
        this.events = heapWalkerEvents;
        this.region = gCHeapRegionDescriptor;
        this.heapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(this.region, true, true);
        if (!flatLockedMonitorsByRegion.containsKey(this.region)) {
            this.localFlatLockedMonitors = new HashSet<ObjectMonitor>(256);
        }
    }

    public boolean hasNext() {
        EventManager.register(this);
        try {
            boolean bl = this.hasNextNoHandler();
            return bl;
        }
        finally {
            EventManager.unregister(this);
        }
    }

    private boolean hasNextNoHandler() {
        boolean bl = this.heapIterator.hasNext();
        if (!bl && this.localFlatLockedMonitors != null && !flatLockedMonitorsByRegion.containsKey(this.region)) {
            flatLockedMonitorsByRegion.put(this.region, this.localFlatLockedMonitors);
            this.localFlatLockedMonitors = null;
        }
        return bl;
    }

    public void walk() {
        block7: {
            EventManager.register(this);
            try {
                if (this.hasNextNoHandler()) {
                    try {
                        J9ObjectPointer j9ObjectPointer = this.heapIterator.next();
                        this.doState(j9ObjectPointer);
                        if (!this.hasNextNoHandler()) {
                            this.state = 5;
                            this.doState(j9ObjectPointer);
                        }
                        break block7;
                    }
                    catch (CorruptDataException corruptDataException) {}
                    break block7;
                }
                throw new NoSuchElementException("The heap walk is complete");
            }
            finally {
                EventManager.unregister(this);
            }
        }
    }

    private static boolean isDeadObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return ObjectModel.isHoleObject(j9ObjectPointer) || ObjectModel.isDarkMatterObject(j9ObjectPointer);
    }

    private void doState(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        switch (this.state) {
            case 0: {
                this.log.fine("Scanning Region @ 0x" + Long.toHexString(this.region.getHeapRegionDescriptorPointer().getAddress()));
                if (!HeapWalker.isDeadObject(j9ObjectPointer)) {
                    this.state = 1;
                    this.doState(j9ObjectPointer);
                    break;
                }
                this.events.doDeadObject(j9ObjectPointer);
                break;
            }
            case 1: {
                ++this.segmentIndex;
                this.log.fine(String.format("\tStarting scan of heap segment %d start=0x%08x", this.segmentIndex, j9ObjectPointer.getAddress()));
                ++this.objectCount;
                this.state = 3;
                this.events.doSectionStart(j9ObjectPointer.getAddress());
                this.events.doLiveObject(j9ObjectPointer);
                if (this.localFlatLockedMonitors == null) break;
                this.processFlatMonitor(j9ObjectPointer);
                break;
            }
            case 2: {
                this.log.fine(String.format(" end=0x%08x object count = %d\n", j9ObjectPointer.getAddress(), this.objectCount));
                this.totalObjectCount += this.objectCount;
                this.objectCount = 0L;
                this.state = 4;
                this.events.doSectionEnd(j9ObjectPointer.getAddress());
                this.events.doDeadObject(j9ObjectPointer);
                break;
            }
            case 3: {
                if (HeapWalker.isDeadObject(j9ObjectPointer)) {
                    this.state = 2;
                    this.doState(j9ObjectPointer);
                    break;
                }
                ++this.objectCount;
                this.events.doLiveObject(j9ObjectPointer);
                if (this.localFlatLockedMonitors == null) break;
                this.processFlatMonitor(j9ObjectPointer);
                break;
            }
            case 4: {
                if (!HeapWalker.isDeadObject(j9ObjectPointer)) {
                    this.state = 1;
                    this.doState(j9ObjectPointer);
                    break;
                }
                this.events.doDeadObject(j9ObjectPointer);
                break;
            }
            case 5: {
                long l = j9ObjectPointer.getAddress();
                l = ObjectModel.isHoleObject(j9ObjectPointer) ? (l += ObjectModel.getSizeInBytesHoleObject(j9ObjectPointer).longValue()) : (l += ObjectModel.getSizeInBytesWithHeader(j9ObjectPointer).longValue());
                this.log.fine(String.format(" end=0x%08x object count = %d\n", l, this.objectCount));
                this.totalObjectCount += this.objectCount;
                this.log.fine("Total object count = " + this.totalObjectCount);
                this.events.doSectionEnd(l);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state of " + this.state + " was detected");
            }
        }
    }

    private void processFlatMonitor(J9ObjectPointer j9ObjectPointer) {
        try {
            ObjectMonitor objectMonitor = ObjectAccessBarrier.getMonitor(j9ObjectPointer);
            if (null != objectMonitor && !objectMonitor.isInflated()) {
                this.localFlatLockedMonitors.add(objectMonitor);
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Could not process flat monitor", corruptDataException, false);
        }
    }

    public static SortedSet<ObjectMonitor> getFlatLockedMonitors() throws CorruptDataException {
        if (flatLockedMonitors == null) {
            HeapWalker.initializeFlatLockedMonitors();
        }
        return Collections.unmodifiableSortedSet(flatLockedMonitors);
    }

    private static void initializeFlatLockedMonitors() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = mM_GCExtensionsPointer.heapRegionManager();
        flatLockedMonitors = new TreeSet<ObjectMonitor>();
        GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.fromMMHeapRegionManager(mM_HeapRegionManagerPointer, true, true);
        while (gCHeapRegionIterator.hasNext()) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
            if (!flatLockedMonitorsByRegion.containsKey(gCHeapRegionDescriptor)) {
                HeapWalker.runFlatLockMonitorRegionWalk(j9JavaVMPointer, gCHeapRegionDescriptor);
            }
            assert (flatLockedMonitorsByRegion.containsKey(gCHeapRegionDescriptor));
            flatLockedMonitors.addAll((Collection<ObjectMonitor>)flatLockedMonitorsByRegion.get(gCHeapRegionDescriptor));
        }
    }

    private static void runFlatLockMonitorRegionWalk(J9JavaVMPointer j9JavaVMPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor) throws CorruptDataException {
        HeapWalker heapWalker = new HeapWalker(j9JavaVMPointer, gCHeapRegionDescriptor, new DummyHeapWalkerEvents());
        while (heapWalker.hasNext()) {
            heapWalker.walk();
        }
    }

    @Override
    public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
        if (!this.lastObjectCorrupt) {
            this.lastObjectCorrupt = true;
            this.events.doCorruptData(corruptDataException);
        }
    }

    private static final class DummyHeapWalkerEvents
    implements HeapWalkerEvents {
        private DummyHeapWalkerEvents() {
        }

        @Override
        public void doSectionStart(long l) {
        }

        @Override
        public void doSectionEnd(long l) {
        }

        @Override
        public void doLiveObject(J9ObjectPointer j9ObjectPointer) {
        }

        @Override
        public void doDeadObject(J9ObjectPointer j9ObjectPointer) {
        }

        @Override
        public void doCorruptData(CorruptDataException corruptDataException) {
        }
    }
}

