/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMGCSegregatedAllocationCacheEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMGCSizeClassesPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorSegregatedPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_LockingFreeHeapRegionListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_LockingHeapRegionQueuePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolAggregatedCellListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_RealtimeGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_RegionPoolSegregatedPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.MM_RegionPoolSegregated;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class DumpSegregatedStatsCommand
extends Command {
    public DumpSegregatedStatsCommand() {
        this.addCommand("dumpsegregatedstats", "", "Print segregated heap statistics, similiar to -XXgc:gcbugheap");
    }

    public long getTotalRegions(MM_HeapRegionListPointer mM_HeapRegionListPointer) throws CorruptDataException {
        long l = 0L;
        StructurePointer structurePointer = mM_HeapRegionListPointer.getAsRuntimeType();
        if (structurePointer instanceof MM_LockingHeapRegionQueuePointer) {
            MM_LockingHeapRegionQueuePointer mM_LockingHeapRegionQueuePointer = (MM_LockingHeapRegionQueuePointer)structurePointer;
            if (mM_LockingHeapRegionQueuePointer._singleRegionsOnly()) {
                l = mM_LockingHeapRegionQueuePointer._length().longValue();
            } else {
                MM_HeapRegionDescriptorSegregatedPointer mM_HeapRegionDescriptorSegregatedPointer = mM_LockingHeapRegionQueuePointer._head();
                while (mM_HeapRegionDescriptorSegregatedPointer.notNull()) {
                    l += mM_HeapRegionDescriptorSegregatedPointer._regionsInSpan().longValue();
                    mM_HeapRegionDescriptorSegregatedPointer = mM_HeapRegionDescriptorSegregatedPointer._next();
                }
            }
        } else if (structurePointer instanceof MM_LockingFreeHeapRegionListPointer) {
            MM_LockingFreeHeapRegionListPointer mM_LockingFreeHeapRegionListPointer = (MM_LockingFreeHeapRegionListPointer)structurePointer;
            MM_HeapRegionDescriptorSegregatedPointer mM_HeapRegionDescriptorSegregatedPointer = mM_LockingFreeHeapRegionListPointer._head();
            while (mM_HeapRegionDescriptorSegregatedPointer.notNull()) {
                l += mM_HeapRegionDescriptorSegregatedPointer._regionsInSpan().longValue();
                mM_HeapRegionDescriptorSegregatedPointer = mM_HeapRegionDescriptorSegregatedPointer._next();
            }
        } else {
            throw new CorruptDataException("Bad HeapRegionList type");
        }
        return l;
    }

    public long getFreeCellCount(MM_HeapRegionListPointer mM_HeapRegionListPointer) throws CorruptDataException {
        StructurePointer structurePointer = mM_HeapRegionListPointer.getAsRuntimeType();
        long l = 0L;
        if (structurePointer instanceof MM_LockingHeapRegionQueuePointer) {
            MM_LockingHeapRegionQueuePointer mM_LockingHeapRegionQueuePointer = (MM_LockingHeapRegionQueuePointer)structurePointer;
            MM_HeapRegionDescriptorSegregatedPointer mM_HeapRegionDescriptorSegregatedPointer = mM_LockingHeapRegionQueuePointer._head();
            while (mM_HeapRegionDescriptorSegregatedPointer.notNull()) {
                l += this.getFreeCellCount(mM_HeapRegionDescriptorSegregatedPointer);
                mM_HeapRegionDescriptorSegregatedPointer = mM_HeapRegionDescriptorSegregatedPointer._next();
            }
        } else if (structurePointer instanceof MM_LockingFreeHeapRegionListPointer) {
            MM_LockingFreeHeapRegionListPointer mM_LockingFreeHeapRegionListPointer = (MM_LockingFreeHeapRegionListPointer)structurePointer;
            MM_HeapRegionDescriptorSegregatedPointer mM_HeapRegionDescriptorSegregatedPointer = mM_LockingFreeHeapRegionListPointer._head();
            while (mM_HeapRegionDescriptorSegregatedPointer.notNull()) {
                l += this.getFreeCellCount(mM_HeapRegionDescriptorSegregatedPointer);
                mM_HeapRegionDescriptorSegregatedPointer = mM_HeapRegionDescriptorSegregatedPointer._next();
            }
        } else {
            throw new CorruptDataException("Bad HeapRegionList type");
        }
        return l;
    }

    public long getFreeCellCount(MM_HeapRegionDescriptorSegregatedPointer mM_HeapRegionDescriptorSegregatedPointer) throws CorruptDataException {
        MM_MemoryPoolAggregatedCellListPointer mM_MemoryPoolAggregatedCellListPointer = mM_HeapRegionDescriptorSegregatedPointer._memoryPoolACL();
        GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(mM_MemoryPoolAggregatedCellListPointer._freeListHead());
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9VMGCSizeClassesPointer j9VMGCSizeClassesPointer = j9JavaVMPointer.realtimeSizeClasses();
        UDATA uDATA = mM_HeapRegionDescriptorSegregatedPointer._sizeClass();
        long l = j9VMGCSizeClassesPointer.smallCellSizesEA().at(uDATA).longValue();
        long l2 = 0L;
        while (gCHeapLinkedFreeHeader.getHeader().notNull()) {
            l2 += gCHeapLinkedFreeHeader.getSize().longValue() / l;
            gCHeapLinkedFreeHeader = gCHeapLinkedFreeHeader.getNext();
        }
        return l2;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (!GCExtensions.isSegregatedHeap()) {
            printStream.append("Only valid for a segregated heap\n");
            return;
        }
        try {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
            MM_RealtimeGCPointer mM_RealtimeGCPointer = MM_RealtimeGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
            MM_RegionPoolSegregatedPointer mM_RegionPoolSegregatedPointer = mM_RealtimeGCPointer._memoryPool()._regionPool();
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMGCSizeClassesPointer j9VMGCSizeClassesPointer = j9JavaVMPointer.realtimeSizeClasses();
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            long l9 = 0L;
            long l10 = 0L;
            long l11 = J9Consts.J9VMGC_SIZECLASSES_MIN_SMALL * MM_RegionPoolSegregated.NUM_DEFRAG_BUCKETS;
            printStream.append("sizeClass | full | available           | total | free cell count | dark | cache\n");
            printStream.append("===============================================================================\n");
            for (l5 = J9Consts.J9VMGC_SIZECLASSES_MIN_SMALL; l5 <= J9Consts.J9VMGC_SIZECLASSES_MAX_SMALL; ++l5) {
                StructurePointer structurePointer;
                UDATA uDATA = j9VMGCSizeClassesPointer.smallCellSizesEA().at(l5);
                printStream.format("%2d: %5d | ", l5, uDATA.longValue());
                MM_HeapRegionListPointer mM_HeapRegionListPointer = MM_HeapRegionListPointer.cast(mM_RegionPoolSegregatedPointer._smallFullRegionsEA().at(l5));
                l4 = this.getTotalRegions(mM_HeapRegionListPointer);
                l8 += l4;
                printStream.format("%4d | ", l4);
                l3 = 0L;
                for (l2 = 0L; l2 < MM_RegionPoolSegregated.NUM_DEFRAG_BUCKETS; ++l2) {
                    l = 0L;
                    structurePointer = MM_LockingHeapRegionQueuePointer.cast(mM_RegionPoolSegregatedPointer._smallAvailableRegionsEA().add(l11).at(0L));
                    for (long i = 0L; i < mM_RegionPoolSegregatedPointer._splitAvailableListSplitCount().longValue(); ++i) {
                        l += this.getTotalRegions((MM_HeapRegionListPointer)structurePointer);
                        l3 += this.getFreeCellCount((MM_HeapRegionListPointer)structurePointer);
                        structurePointer = ((MM_LockingHeapRegionQueuePointer)structurePointer).add(1L);
                    }
                    ++l11;
                    l4 += l;
                    l7 += l;
                    printStream.format("%4d ", l);
                }
                l6 += l4;
                printStream.format("| %5d | %15d |", l4, l3);
                l2 = mM_RegionPoolSegregatedPointer._darkMatterCellCountEA().at(l5).longValue();
                l9 += l2 * uDATA.longValue();
                printStream.format("%%%3d | ", l4 == 0L ? 0L : l2 / (l4 * uDATA.longValue()));
                l = 0L;
                structurePointer = j9JavaVMPointer.mainThread();
                if (structurePointer.notNull()) {
                    J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
                    do {
                        J9VMGCSegregatedAllocationCacheEntryPointer j9VMGCSegregatedAllocationCacheEntryPointer = j9VMThreadPointer.segregatedAllocationCache();
                        j9VMGCSegregatedAllocationCacheEntryPointer = j9VMGCSegregatedAllocationCacheEntryPointer.add(l5);
                        l += j9VMGCSegregatedAllocationCacheEntryPointer.top().longValue() - j9VMGCSegregatedAllocationCacheEntryPointer.current().longValue();
                    } while (!(j9VMThreadPointer = j9VMThreadPointer.linkNext()).eq(structurePointer));
                }
                printStream.format("%5d\n", l);
                l10 += l;
            }
            l5 = mM_GCExtensionsPointer.heap()._heapRegionManager()._regionSize().longValue();
            printStream.format("region size %d\n", l5);
            long l12 = mM_GCExtensionsPointer._omrVM()._arrayletLeafSize().longValue();
            printStream.format("arraylet leaf size %d\n", l12);
            printStream.format("small total (full, available) region count %d (%d, %d)\n", l6, l8, l7);
            l4 = this.getTotalRegions(mM_RegionPoolSegregatedPointer._arrayletFullRegions());
            l3 = this.getTotalRegions(mM_RegionPoolSegregatedPointer._arrayletAvailableRegions());
            l2 = l4 + l3;
            l6 += l2;
            printStream.format("arraylet total (full, available) region count %d (%d %d)\n", l2, l4, l3);
            l = this.getTotalRegions(mM_RegionPoolSegregatedPointer._largeFullRegions());
            l6 += l;
            printStream.format("large full region count %d\n", l);
            long l13 = this.getTotalRegions(mM_RegionPoolSegregatedPointer._singleFreeList());
            l6 += l13;
            printStream.format("free region count %d\n", l13);
            long l14 = this.getTotalRegions(mM_RegionPoolSegregatedPointer._multiFreeList());
            l6 += l14;
            printStream.format("multiFree region count %d\n", l14);
            long l15 = this.getTotalRegions(mM_RegionPoolSegregatedPointer._coalesceFreeList());
            printStream.format("coalesce region count %d\n", l15);
            long l16 = (l6 += l15) * l5;
            printStream.format("total region count %d, total heap size %d \n", l6, l16);
            printStream.format("dark matter total bytes %d (%2.2f%% of heap)\n", l9, 100.0 * (double)l9 / (double)l16);
            printStream.format("allocation cache total bytes %d (%2.2f%% of heap)\n", l10, 100.0 * (double)l10 / (double)l16);
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }
}

