/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.math.BigInteger;

public class FindPatternCommand
extends Command {
    private static final int PATTERN_LENGHT = 1024;

    public FindPatternCommand() {
        this.addCommand("findpattern", "<pattern>", "search memory for a specific pattern");
    }

    private void printUsage(PrintStream printStream) {
        CommandUtils.dbgPrint(printStream, "Usage: \n");
        CommandUtils.dbgPrint(printStream, "  !findpattern hexstring,alignment\n");
        CommandUtils.dbgPrint(printStream, "  !findpattern hexstring,alignment,startPtr\n");
        CommandUtils.dbgPrint(printStream, "  !findpattern hexstring,alignment,startPtr,bytesToSearch\n");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            byte[] byArray = null;
            BigInteger bigInteger = CommandUtils.longToBigInteger(UDATA.MAX.longValue());
            int n = 0;
            if (stringArray.length != 1) {
                this.printUsage(printStream);
                return;
            }
            String[] stringArray2 = stringArray[0].split(",");
            if (stringArray2.length == 1) {
                CommandUtils.dbgError(printStream, "Error: must specify alignment\n");
                this.printUsage(printStream);
                return;
            }
            String string2 = stringArray2[0];
            int n2 = Integer.parseInt(stringArray2[1]);
            long l = 0L;
            if (stringArray2.length == 3) {
                l = CommandUtils.parsePointer(stringArray2[2], J9BuildFlags.J9VM_ENV_DATA64);
                bigInteger = bigInteger.subtract(CommandUtils.longToBigInteger(l));
            } else if (stringArray2.length == 4) {
                l = CommandUtils.parsePointer(stringArray2[2], J9BuildFlags.J9VM_ENV_DATA64);
                bigInteger = CommandUtils.parseNumber(stringArray2[3]);
                if (bigInteger.add(CommandUtils.longToBigInteger(l)).toString(16).length() > UDATA.SIZEOF) {
                    printStream.println("Warning: bytesToSearch value (" + stringArray2[3] + ") is larger than the max available memory after the search start address (" + stringArray2[2] + ").\n Pattern will be searched in all the remaining memory after the search start address");
                    bigInteger = CommandUtils.longToBigInteger(UDATA.MAX.longValue()).subtract(CommandUtils.longToBigInteger(l));
                }
            } else if (stringArray2.length > 4) {
                CommandUtils.dbgError(printStream, "Error: too many arguments\n");
            }
            n = string2.length() / 2;
            if (n > 1024) {
                CommandUtils.dbgPrint(printStream, String.format("Pattern is too long. Truncating to %d bytes\n", 1024));
                n = 1024;
            }
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                int n3 = this.hexValue(string2.charAt(i * 2));
                int n4 = this.hexValue(string2.charAt(i * 2 + 1));
                if (n3 < 0 || n4 < 0) {
                    CommandUtils.dbgError(printStream, "Error: non-hex value found in hex string\n");
                    return;
                }
                byArray[i] = (byte)((n3 << 4) + n4);
            }
            if (n2 == 0) {
                n2 = 1;
            }
            CommandUtils.dbgPrint(printStream, String.format("Searching for %d bytes. Alignment = %d, start = %s, bytesToSearch = %s ...\n", n, n2, U8Pointer.cast(l).getHexAddress(), bigInteger.toString()));
            long l2 = this.dbgFindPatternInRange(context, byArray, n2, l, bigInteger);
            if (0L != l2) {
                CommandUtils.dbgPrint(printStream, String.format("Result = %s\n", U8Pointer.cast(l2).getHexAddress()));
            } else {
                CommandUtils.dbgPrint(printStream, String.format("Result = No Match Found.\n", new Object[0]));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }
}

