/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class FileOutputChannel
implements IOutputChannel {
    private File file;
    private FileWriter fw;

    public FileOutputChannel(FileWriter fileWriter, File file) {
        this.fw = fileWriter;
        this.file = file;
    }

    @Override
    public void print(String string) {
        try {
            this.fw.write(Utils.toString(string));
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void printPrompt(String string) {
    }

    @Override
    public void println(String string) {
        try {
            this.fw.write(Utils.toString(string) + "\n");
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void error(String string) {
        try {
            this.fw.write("\n");
            this.fw.write("\tERROR: " + Utils.toString(string) + "\n");
            this.fw.write("\n");
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void error(String string, Exception exception) {
        try {
            this.fw.write("\n");
            this.fw.write("\tERROR: " + Utils.toString(string) + "\n");
            this.fw.write("\n");
            PrintWriter printWriter = new PrintWriter((Writer)this.fw, true);
            exception.printStackTrace(printWriter);
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printInput(long l, String string, String string2) {
        try {
            this.fw.write(new Date(l).toString() + " " + string + Utils.toString(string2) + "\n");
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this.fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileOutputChannel)) {
            return false;
        }
        return this.file.equals(((FileOutputChannel)object).getFile());
    }

    private Object getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

