/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.JdmpviewPrintStream;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Output
extends OutputStream
implements IOutputManager {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private PrintStream internalStream = new PrintStream(this.bos);
    private boolean isBufferingEnabled = false;
    Vector outputChannels = new Vector();
    long lastTimestamp = 0L;
    String lastPrompt = "";
    String lastInput = "";

    @Override
    public void clearBuffer() {
        this.bos.reset();
    }

    @Override
    public void setBuffering(boolean bl) {
        this.isBufferingEnabled = bl;
    }

    @Override
    public String getBuffer() {
        return this.bos.toString();
    }

    @Override
    public void print(String string) {
        if (this.isBufferingEnabled) {
            this.internalStream.print(string);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).print(string);
            }
        }
    }

    @Override
    public void printPrompt(String string) {
        if (this.isBufferingEnabled) {
            this.internalStream.print(string);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).printPrompt(string);
            }
        }
    }

    @Override
    public void println(String string) {
        if (this.isBufferingEnabled) {
            this.internalStream.println(string);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).println(string);
            }
        }
    }

    @Override
    public void addChannel(IOutputChannel iOutputChannel) {
        this.addChannel(iOutputChannel, false);
    }

    public void addChannel(IOutputChannel iOutputChannel, boolean bl) {
        this.outputChannels.add(iOutputChannel);
    }

    @Override
    public void removeChannel(Class<?> clazz) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            IOutputChannel iOutputChannel = (IOutputChannel)this.outputChannels.elementAt(i);
            if (!iOutputChannel.getClass().isAssignableFrom(clazz)) continue;
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
            this.outputChannels.removeElementAt(i);
        }
    }

    @Override
    public void removeChannel(IOutputChannel iOutputChannel) {
        this.outputChannels.remove(iOutputChannel);
    }

    @Override
    public void removeAllChannels() {
        this.outputChannels.clear();
    }

    public void removeFileChannel() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((IOutputChannel)this.outputChannels.elementAt(i) instanceof FileOutputChannel)) continue;
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
            this.outputChannels.removeElementAt(i);
        }
    }

    public void setConsoleNoPrint(boolean bl) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((IOutputChannel)this.outputChannels.elementAt(i) instanceof ConsoleOutputChannel)) continue;
            ((ConsoleOutputChannel)this.outputChannels.elementAt(i)).setNoPrint(bl);
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        String string = new String(byArray, n, n2);
        this.print(string);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        String string = new String(byArray);
        this.print(string);
    }

    @Override
    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        String string = new String(cArray);
        this.print(string);
    }

    @Override
    public void flush() {
    }

    @Override
    public PrintStream getPrintStream() {
        JdmpviewPrintStream jdmpviewPrintStream = new JdmpviewPrintStream(this);
        return jdmpviewPrintStream;
    }
}

