/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.SystemTrace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.CharConversion;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.FileFormatException;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class Dump
extends ImageInputStreamImpl {
    private String filename;
    private ImageInputStream raf;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;
    private AddressSpace[] spaces;
    private String title;
    private String productName;
    private String productVersion;
    private String productRelease;
    private String productModification;
    private Date creationDate;
    private long fileSize;
    AddressSpace rootSpace;
    AddressSpace highVirtualSharedSpace;
    private SoftReference<SystemTrace> systemTraceRef;
    static final int HEADERSIZE = 64;
    public static final int DATABLOCKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public static boolean isValid(String string) {
        try {
            new Dump(string, false);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (FileFormatException fileFormatException) {
            return false;
        }
    }

    public Dump(String string) throws FileNotFoundException, FileFormatException {
        this(string, true);
    }

    public Dump(ImageInputStream imageInputStream) throws FileNotFoundException, FileFormatException {
        this(imageInputStream, true);
    }

    public Dump(ImageInputStream imageInputStream, boolean bl) throws FileNotFoundException, FileFormatException {
        log.fine("Initialising from input stream");
        this.filename = "DataStream";
        this.raf = imageInputStream;
        this.fileSize = -1L;
        this.readFirstBlock();
        if (bl) {
            this.initialize();
        }
    }

    public Dump(String string, boolean bl) throws FileNotFoundException, FileFormatException {
        log.fine("opening dump " + string);
        this.filename = string;
        this.raf = new FileImageInputStream(new RandomAccessFile(string, "r"));
        this.fileSize = new File(string).length();
        this.readFirstBlock();
        if (bl) {
            this.initialize();
        }
    }

    public Dump(InputStream inputStream, boolean bl) throws FileNotFoundException, FileFormatException {
        log.fine("Creating dump image from input stream");
        this.filename = "stream";
        this.raf = new MemoryCacheImageInputStream(inputStream);
        this.readFirstBlock();
        if (bl) {
            this.initialize();
        }
    }

    public Dump(String string, ImageInputStream imageInputStream) throws FileNotFoundException, FileFormatException {
        this.filename = string;
        this.raf = imageInputStream;
        this.fileSize = new File(string).length();
        this.readFirstBlock();
        this.initialize();
    }

    public Dump(BufferedInputStream bufferedInputStream, String string) throws FileNotFoundException, FileFormatException {
        this.inputStream = bufferedInputStream;
        this.filename = string;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.readFirstBlock();
        this.initialize();
    }

    private void readFirstBlock() throws FileNotFoundException, FileFormatException {
        try {
            byte[] byArray = new byte[512];
            if (this.inputStream != null) {
                this.inputStream.mark(byArray.length * 2);
            }
            this.readFully(byArray);
            int n = Dump.readInt(byArray, 0);
            if (n != -992349888 && n != -992349632) {
                throw new FileFormatException("bad eyecatcher " + Dump.hex(n) + " in first block");
            }
            this.title = CharConversion.getEbcdicString(byArray, 88, 100);
            this.productName = CharConversion.getEbcdicString(byArray, 244, 16);
            this.productVersion = CharConversion.getEbcdicString(byArray, 260, 2);
            this.productRelease = CharConversion.getEbcdicString(byArray, 262, 2);
            this.productModification = CharConversion.getEbcdicString(byArray, 264, 2);
            long l = Dump.readInt(byArray, 72);
            long l2 = Dump.readInt(byArray, 76);
            this.creationDate = Dump.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
            if (this.inputStream != null) {
                this.inputStream.reset();
            } else {
                this.raf.seek(0L);
            }
        }
        catch (IOException iOException) {
            throw new FileFormatException("oops: " + iOException);
        }
    }

    public void initialize() throws FileNotFoundException, FileFormatException {
        try {
            log.fine("Scanning dump file");
            byte[] byArray = null;
            ObjectMap objectMap = new ObjectMap();
            long l = 0L;
            while (true) {
                if (this.inputStream == null) {
                    this.raf.seek(l);
                }
                if (this.inputStream != null) {
                    if (byArray == null) {
                        byArray = new byte[4160];
                    }
                } else if (l == 0L) {
                    byArray = new byte[512];
                } else if (l == 4160L) {
                    byArray = new byte[64];
                }
                try {
                    this.readFully(byArray);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (this.inputStream != null) {
                    this.outputStream.write(byArray, 0, 4160);
                }
                int n = Dump.readInt(byArray, 0);
                boolean bl = false;
                if (n == -992349888) {
                    bl = true;
                } else if (n != -992349632) {
                    throw new FileFormatException("bad eyecatcher " + Dump.hex(n) + " at offset " + l);
                }
                int n2 = Dump.readInt(byArray, 12);
                if (n2 < 0 && n2 != -910042680) {
                    log.fine("ignoring asid " + Dump.hex(n2) + " " + Dump.hex(Dump.readInt(byArray, 13)));
                } else {
                    AddressSpace addressSpace;
                    long l2;
                    long l3 = l2 = bl ? (long)Dump.readInt(byArray, 20) : Dump.readLong(byArray, 20);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("read block, asid = " + Dump.hex(n2) + " address = " + Dump.hex(l2));
                    }
                    if ((addressSpace = (AddressSpace)objectMap.get(n2)) == null) {
                        addressSpace = new AddressSpace(this, n2);
                        objectMap.put(n2, addressSpace);
                    }
                    addressSpace.mapAddressToFileOffset(l2, l + 64L);
                    if (n2 == 1) {
                        this.rootSpace = addressSpace;
                    }
                    if (n2 == -910042680) {
                        this.highVirtualSharedSpace = addressSpace;
                    }
                }
                l += 4160L;
            }
            this.spaces = (AddressSpace[])objectMap.toArray(new AddressSpace[0]);
            Arrays.sort(this.spaces, new Comparator<AddressSpace>(){

                @Override
                public int compare(AddressSpace addressSpace, AddressSpace addressSpace2) {
                    return addressSpace.getAsid() - addressSpace2.getAsid();
                }
            });
            this.seek(0L);
            log.fine("scan complete");
        }
        catch (FileFormatException fileFormatException) {
            throw fileFormatException;
        }
        catch (Exception exception) {
            log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump", "initialize", "Unexpected exception", exception);
            throw new Error("unexpected exception: " + exception);
        }
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return n2;
    }

    static long readLong(byte[] byArray, int n) {
        long l = Dump.readInt(byArray, n);
        long l2 = Dump.readInt(byArray, n + 4);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
        if (this.inputStream == null) {
            this.raf.seek(l);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.inputStream != null ? this.inputStream.read(byArray, n, n2) : this.raf.read(byArray, n, n2);
        if (n3 > 0) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.inputStream != null ? this.inputStream.read(byArray) : this.raf.read(byArray);
        if (n > 0) {
            this.streamPos += (long)n;
        }
        return n;
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.outputStream.close();
        } else {
            this.raf.close();
        }
    }

    public void localClose() throws IOException {
    }

    public AddressSpace[] getAddressSpaces() {
        return this.spaces;
    }

    public AddressSpace getAddressSpace(int n) {
        for (int i = 0; i < this.spaces.length; ++i) {
            if (this.spaces[i].getAsid() != n) continue;
            return this.spaces[i];
        }
        return null;
    }

    public boolean is64bit() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public String getProductModification() {
        return this.productModification;
    }

    public static Date mvsClockToDate(long l) {
        l >>>= 12;
        l /= 1000L;
        long l2 = 613608L;
        l2 *= 3600L;
        return new Date(l -= (l2 *= 1000L));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public SystemTrace getSystemTrace() throws IOException {
        SystemTrace systemTrace;
        SystemTrace systemTrace2 = systemTrace = this.systemTraceRef == null ? null : this.systemTraceRef.get();
        if (systemTrace != null) {
            return systemTrace;
        }
        for (int i = 0; i < this.spaces.length; ++i) {
            AddressSpace addressSpace = this.spaces[i];
            long l = addressSpace.getLowestAddress();
            int n = addressSpace.readInt(l);
            if (n != -471612472) continue;
            systemTrace = new SystemTrace(addressSpace);
            this.systemTraceRef = new SoftReference<SystemTrace>(systemTrace);
            return systemTrace;
        }
        throw new Error("no system trace found!");
    }

    public String getName() {
        return this.filename;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static String hex(long l) {
        return Long.toHexString(l);
    }

    public boolean equals(Object object) {
        Dump dump = (Dump)object;
        return dump.filename.equals(this.filename);
    }

    public int hashCode() {
        return this.filename.hashCode();
    }
}

