/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J9DDRDTFJUtils {
    private static final String DTFJ_LOGGER_NAME = "com.ibm.dtfj.log";
    private static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");

    public static Iterator emptyIterator() {
        return new LinkedList().iterator();
    }

    public static Iterator corruptIterator(CorruptData corruptData) {
        LinkedList<CorruptData> linkedList = new LinkedList<CorruptData>();
        linkedList.add(corruptData);
        return linkedList.iterator();
    }

    public static J9DDRCorruptData newCorruptData(IProcess iProcess, CorruptDataException corruptDataException) {
        return new J9DDRCorruptData(iProcess, corruptDataException);
    }

    public static J9DDRCorruptData newCorruptData(IProcess iProcess) {
        return new J9DDRCorruptData(iProcess);
    }

    public static J9DDRCorruptData newCorruptData(IProcess iProcess, String string) {
        return new J9DDRCorruptData(iProcess, string);
    }

    public static com.ibm.dtfj.image.CorruptDataException newCorruptDataException(IProcess iProcess, CorruptDataException corruptDataException) {
        return new DTFJCorruptDataException(new J9DDRCorruptData(iProcess, corruptDataException), (Throwable)corruptDataException);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButDataUnavailAsCorruptDataException(IProcess iProcess, Throwable throwable) throws DataUnavailable {
        if (throwable instanceof DataUnavailable) {
            throw (DataUnavailable)throwable;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(iProcess, throwable);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButMemAccExAsCorruptDataException(IProcess iProcess, Throwable throwable, Class<?>[] classArray) throws MemoryAccessException {
        if (throwable instanceof MemoryAccessException) {
            throw (MemoryAccessException)throwable;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(iProcess, throwable, classArray);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAllButMemAccExAndDataUnavailAsCorruptDataException(IProcess iProcess, Throwable throwable, Class<?>[] classArray) throws MemoryAccessException, DataUnavailable {
        if (throwable instanceof MemoryAccessException) {
            throw (MemoryAccessException)throwable;
        }
        if (throwable instanceof DataUnavailable) {
            throw (DataUnavailable)throwable;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(iProcess, throwable, classArray);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAsCorruptDataException(IProcess iProcess, Throwable throwable, Class<?>[] classArray) {
        Class<?> clazz;
        boolean bl = false;
        Class<?>[] classArray2 = classArray;
        int n = classArray2.length;
        for (int i = 0; !(i >= n || RuntimeException.class.isAssignableFrom(clazz = classArray2[i]) && (bl = throwable.getClass().equals(clazz))); ++i) {
        }
        if (bl) {
            throw (RuntimeException)throwable;
        }
        return J9DDRDTFJUtils.handleAsCorruptDataException(iProcess, throwable);
    }

    public static com.ibm.dtfj.image.CorruptDataException handleAsCorruptDataException(IProcess iProcess, Throwable throwable) {
        if (throwable instanceof com.ibm.dtfj.image.CorruptDataException) {
            return (com.ibm.dtfj.image.CorruptDataException)throwable;
        }
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(throwable)) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        if (throwable instanceof CorruptDataException) {
            CorruptDataException corruptDataException = (CorruptDataException)throwable;
            logger.log(Level.FINE, "Corrupt data encountered", throwable);
            return J9DDRDTFJUtils.newCorruptDataException(iProcess, corruptDataException);
        }
        String string = J9DDRDTFJUtils.logError(throwable);
        J9DDRCorruptData j9DDRCorruptData = J9DDRDTFJUtils.newCorruptData(iProcess, string);
        return new DTFJCorruptDataException(j9DDRCorruptData, throwable);
    }

    public static CorruptData handleAsCorruptData(IProcess iProcess, Throwable throwable) {
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(throwable)) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        if (throwable instanceof CorruptDataException) {
            CorruptDataException corruptDataException = (CorruptDataException)throwable;
            logger.log(Level.FINE, "Corrupt data encountered", throwable);
            return J9DDRDTFJUtils.newCorruptData(iProcess, corruptDataException);
        }
        String string = J9DDRDTFJUtils.logError(throwable);
        J9DDRCorruptData j9DDRCorruptData = J9DDRDTFJUtils.newCorruptData(iProcess, string);
        return j9DDRCorruptData;
    }

    private static boolean isErrorNotToBeIntercepted(Throwable throwable) {
        return throwable instanceof Error && !(throwable instanceof NoSuchFieldError);
    }

    private static String logError(Throwable throwable) {
        String string = null;
        if (throwable instanceof NoSuchFieldError) {
            string = "DDR structures in the core file are out of sync with the code base";
        }
        if (throwable instanceof RuntimeException) {
            string = "Internal runtime exception was encountered";
        }
        if (null == string) {
            string = "An unexpected exception occurred";
        }
        logger.log(Level.FINE, string, throwable);
        return string;
    }

    public static DataUnavailable handleAsDataUnavailable(Throwable throwable) {
        if (throwable instanceof DataUnavailable) {
            return (DataUnavailable)throwable;
        }
        if (J9DDRDTFJUtils.isErrorNotToBeIntercepted(throwable)) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        if (throwable instanceof DataUnavailable) {
            logger.log(Level.FINE, "Data unavailable", throwable);
            return (DataUnavailable)throwable;
        }
        String string = J9DDRDTFJUtils.logError(throwable);
        DataUnavailable dataUnavailable = new DataUnavailable(string);
        dataUnavailable.initCause(throwable);
        return dataUnavailable;
    }
}

