/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DTFJJavaMethod
implements JavaMethod {
    protected final DTFJJavaClass clazz;
    protected final J9ROMMethodPointer j9romMethod;
    protected final J9MethodPointer j9ramMethod;
    private List<Object> byteCodeSections;
    List<Object> compiledSections;

    public DTFJJavaMethod(DTFJJavaClass dTFJJavaClass, J9MethodPointer j9MethodPointer) throws CorruptDataException {
        this.clazz = dTFJJavaClass;
        this.j9ramMethod = j9MethodPointer;
        this.j9romMethod = J9MethodHelper.romMethod(j9MethodPointer);
    }

    public Iterator getBytecodeSections() {
        if (this.byteCodeSections == null) {
            this.byteCodeSections = new ArrayList<Object>();
            try {
                J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.getOriginalROMMethod(this.j9ramMethod);
                if (!j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccNative)) {
                    U8Pointer u8Pointer = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
                    UDATA uDATA = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
                    J9DDRImageSection j9DDRImageSection = DTFJContext.getImageSection(u8Pointer.getAddress(), "bytecode section at " + this.j9ramMethod.bytecodes().getAddress());
                    j9DDRImageSection.setSize(uDATA.longValue());
                    this.byteCodeSections.add(j9DDRImageSection);
                    if (!this.j9romMethod.equals(j9ROMMethodPointer)) {
                        j9DDRImageSection = DTFJContext.getImageSection(this.j9ramMethod.bytecodes().getAddress(), "bytecode section at " + this.j9ramMethod.bytecodes().getAddress());
                        j9DDRImageSection.setSize(uDATA.longValue());
                        this.byteCodeSections.add(j9DDRImageSection);
                    }
                }
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.byteCodeSections.add(corruptData);
            }
        }
        return this.byteCodeSections.iterator();
    }

    public Iterator getCompiledSections() {
        if (this.compiledSections == null) {
            this.compiledSections = new ArrayList<Object>();
            List<J9JITExceptionTablePointer> list = DTFJContext.getJITMetaData(this.j9ramMethod);
            if (list != null) {
                for (J9JITExceptionTablePointer j9JITExceptionTablePointer : list) {
                    CorruptData corruptData;
                    J9DDRImageSection j9DDRImageSection;
                    String string;
                    long l;
                    long l2;
                    try {
                        l2 = j9JITExceptionTablePointer.startPC().longValue();
                        l = j9JITExceptionTablePointer.endWarmPC().longValue() - l2;
                        string = String.format("jit section (%s) at %s", j9JITExceptionTablePointer.getAddress(), l2);
                        j9DDRImageSection = DTFJContext.getImageSection(l2, string);
                        j9DDRImageSection.setSize(l);
                        this.compiledSections.add(j9DDRImageSection);
                    }
                    catch (Throwable throwable) {
                        corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                        this.compiledSections.add(corruptData);
                    }
                    try {
                        l2 = j9JITExceptionTablePointer.startColdPC().longValue();
                        if (l2 == 0L) continue;
                        l = j9JITExceptionTablePointer.endPC().longValue() - l2;
                        string = String.format("cold jit section (%s) at %s", j9JITExceptionTablePointer.getAddress(), l2);
                        j9DDRImageSection = DTFJContext.getImageSection(l2, string);
                        j9DDRImageSection.setSize(l);
                        this.compiledSections.add(j9DDRImageSection);
                    }
                    catch (Throwable throwable) {
                        corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                        this.compiledSections.add(corruptData);
                    }
                }
            }
        }
        return this.compiledSections.iterator();
    }

    public JavaClass getDeclaringClass() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        return this.clazz;
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getReflectModifiers(this.j9romMethod);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getName(this.j9romMethod);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public String getSignature() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getSignature(this.j9romMethod);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public String getFilename() throws com.ibm.dtfj.image.CorruptDataException {
        return this.clazz.getFilename();
    }

    public String toString() {
        try {
            return this.clazz.toString() + "." + this.getName() + this.getSignature();
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return super.toString();
        }
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof DTFJJavaMethod)) {
                return false;
            }
            DTFJJavaMethod dTFJJavaMethod = (DTFJJavaMethod)object;
            return this.j9ramMethod.getAddress() == dTFJJavaMethod.j9ramMethod.getAddress();
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return false;
        }
    }

    public int hashCode() {
        return this.j9ramMethod.hashCode();
    }
}

