/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class ByteStream {
    ByteBuffer buffer;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    Vector rawData = new Vector();
    private int guardBytes;

    public ByteStream(byte[] byArray) {
        this.add(byArray);
    }

    public ByteStream(byte[] byArray, int n) {
        this.add(byArray, n);
    }

    public ByteStream(byte[] byArray, int n, int n2) {
        this.add(byArray, n, n2);
    }

    public ByteStream() {
    }

    private synchronized void commit(int n) throws BufferUnderflowException {
        int n2 = n + this.guardBytes;
        boolean bl = true;
        if (this.buffer != null && this.buffer.remaining() >= n2) {
            return;
        }
        if (this.rawData.isEmpty()) {
            throw new BufferUnderflowException();
        }
        Slice slice = (Slice)this.rawData.get(0);
        if (this.buffer != null && this.buffer.remaining() >= n && slice.length >= this.guardBytes) {
            return;
        }
        if (this.buffer == null || this.buffer.remaining() == 0) {
            this.rawData.remove(0);
            this.buffer = ByteBuffer.wrap(slice.data, slice.offset, slice.length);
        } else {
            byte[] byArray;
            int n3 = this.buffer.remaining();
            if (slice.length > n2) {
                byArray = new byte[n];
                int n4 = n - n3;
                this.buffer.get(byArray, 0, n3);
                System.arraycopy(slice.data, slice.offset, byArray, n3, n4);
                slice.offset += n4;
                slice.length -= n4;
                bl = false;
            } else {
                byArray = new byte[n3 + slice.length];
                this.buffer.get(byArray, 0, n3);
                System.arraycopy(slice.data, slice.offset, byArray, n3, slice.length);
                this.rawData.remove(0);
            }
            this.buffer = ByteBuffer.wrap(byArray);
        }
        this.buffer.order(this.byteOrder);
        if (bl && this.buffer.remaining() < n2) {
            this.commit(n);
        }
    }

    public void reverseBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - 1 - i];
            byArray[byArray.length - 1 - i] = by;
        }
    }

    public void add(byte[] byArray) {
        this.add(byArray, 0);
    }

    public void add(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        this.add(byArray, n, byArray.length - n);
    }

    public synchronized void add(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("can't add data with a negative size");
        }
        this.rawData.add(new Slice(byArray, n, n2));
    }

    public byte get() {
        this.commit(1);
        return this.buffer.get();
    }

    public byte get(int n) {
        this.commit(n + 1);
        return this.buffer.get(n);
    }

    public char getUTF8Char() {
        this.commit(1);
        return this.buffer.getChar();
    }

    public char getUTF8Char(int n) {
        this.commit(n + 1);
        return this.buffer.getChar(n);
    }

    public double getDouble() {
        this.commit(8);
        return this.buffer.getDouble();
    }

    public double getDouble(int n) {
        this.commit(n + 8);
        return this.buffer.getDouble(n);
    }

    public float getFloat() {
        this.commit(8);
        return this.buffer.getFloat();
    }

    public float getFloat(int n) {
        this.commit(n + 8);
        return this.buffer.getFloat(n);
    }

    public int getInt() {
        this.commit(4);
        return this.buffer.getInt();
    }

    public int getInt(int n) {
        this.commit(n + 4);
        return this.buffer.getInt(n);
    }

    public long getUnsignedInt() {
        this.commit(4);
        byte[] byArray = new byte[4];
        this.buffer.get(byArray);
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)byArray[3] << 24 & 0xFF000000L | (long)byArray[2] << 16 & 0xFF0000L | (long)byArray[1] << 8 & 0xFF00L | (long)byArray[0] & 0xFFL : (long)byArray[0] << 24 & 0xFF000000L | (long)byArray[1] << 16 & 0xFF0000L | (long)byArray[2] << 8 & 0xFF00L | (long)byArray[3] & 0xFFL;
    }

    public long getUnsignedInt(int n) {
        this.commit(n + 4);
        byte[] byArray = new byte[n + 4];
        this.peek(byArray);
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)byArray[n + 3] << 24 & 0xFF000000L | (long)byArray[n + 2] << 16 & 0xFF0000L | (long)byArray[n + 1] << 8 & 0xFF00L | (long)byArray[n + 0] & 0xFFL : (long)byArray[n + 0] << 24 & 0xFF000000L | (long)byArray[n + 1] << 16 & 0xFF0000L | (long)byArray[n + 2] << 8 & 0xFF00L | (long)byArray[n + 3] & 0xFFL;
    }

    public long getLong() {
        this.commit(8);
        return this.buffer.getLong();
    }

    public long getLong(int n) {
        this.commit(n + 8);
        return this.buffer.getLong(n);
    }

    public short getShort() {
        this.commit(2);
        return this.buffer.getShort();
    }

    public short getShort(int n) {
        this.commit(n + 2);
        return this.buffer.getShort(n);
    }

    public String getASCIIString(int n) {
        this.commit(n);
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        int n2 = 0;
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        try {
            return new String(byArray, 0, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getASCIIString() {
        block10: {
            if (this.buffer == null) {
                try {
                    this.commit(20);
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    if (this.buffer != null) break block10;
                    throw bufferUnderflowException;
                }
            }
        }
        int n = 0;
        while (true) {
            int n2 = this.buffer.position();
            byte by = 1;
            byte[] byArray = this.buffer.array();
            while (n < this.buffer.remaining() && by != 0) {
                by = byArray[n2 + n];
                ++n;
            }
            if (by == 0) {
                String string;
                try {
                    string = new String(byArray, n2, n - 1, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = new String(byArray, n2, n - 1);
                }
                this.buffer.position(n2 + n);
                return string;
            }
            try {
                this.commit(this.buffer.remaining() + 20);
                continue;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                if (n == this.buffer.remaining()) throw bufferUnderflowException;
                continue;
            }
            break;
        }
    }

    public String getUTF8String() throws UnsupportedEncodingException {
        this.commit(1);
        short s = this.getShort();
        byte[] byArray = new byte[s];
        this.commit(s);
        this.get(byArray);
        String string = new String(byArray, "UTF-8");
        if (byArray.length % 2 == 0) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < byArray.length - 1; ++n) {
                if (byArray[n] != 0) continue;
                bl2 = true;
                if (n % 2 == 0) continue;
                bl = true;
            }
            if (bl2) {
                if (bl) {
                    for (n = 0; n < byArray.length - 1; n += 2) {
                        byte by = byArray[n + 1];
                        byArray[n + 1] = byArray[n];
                        byArray[n] = by;
                    }
                }
                string = new String(byArray, "UTF-16");
            }
        }
        return string;
    }

    public BigInteger getBigInteger(int n) {
        this.commit(n);
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            this.reverseBytes(byArray);
        }
        return new BigInteger(1, byArray);
    }

    public void get(byte[] byArray) {
        this.commit(byArray.length);
        this.buffer.get(byArray);
    }

    public void get(byte[] byArray, int n, int n2) {
        this.commit(n2);
        this.buffer.get(byArray, n, n2);
    }

    public ByteOrder order() {
        return this.byteOrder;
    }

    public synchronized void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
        if (this.buffer != null) {
            this.buffer.order(this.byteOrder);
        }
    }

    public synchronized void setGuardBytes(int n) {
        this.guardBytes = n;
    }

    public int getGuardBytes() {
        return this.guardBytes;
    }

    public synchronized void truncate(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (n2 = this.rawData.size() - 1; n2 >= 0 && n > 0; --n2) {
            int n3 = n;
            Slice slice = (Slice)this.rawData.get(n2);
            n -= slice.length;
            if (n3 < slice.length) {
                slice.length -= n3;
                continue;
            }
            this.rawData.remove(n2);
        }
        if (n > 0 && this.buffer != null) {
            n2 = n;
            if ((n -= this.buffer.remaining()) < 0) {
                this.buffer.limit(this.buffer.limit() - n2);
            } else {
                this.buffer = null;
            }
        }
        if (n > 0) {
            throw new BufferUnderflowException();
        }
    }

    public synchronized int truncate(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = this.rawData.size() - 1; n >= 0 && n2 > 0; --n) {
            int n3 = n2;
            Slice slice = (Slice)this.rawData.get(n);
            n2 -= slice.length;
            if (n3 < slice.length) {
                slice.length -= n3;
                System.arraycopy(slice.data, slice.offset + slice.length, byArray, 0, n3);
                continue;
            }
            this.rawData.remove(n);
            System.arraycopy(slice.data, slice.offset, byArray, n2, slice.length);
        }
        if (n2 > 0 && this.buffer != null) {
            n = n2;
            if ((n2 -= this.buffer.remaining()) < 0) {
                this.buffer.limit(this.buffer.limit() - n);
                System.arraycopy(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position() + this.buffer.remaining(), byArray, 0, n);
            } else {
                System.arraycopy(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), byArray, n2, this.buffer.remaining());
                this.buffer = null;
            }
        }
        if (n2 < 0) {
            this.guardBytes -= byArray.length;
            return byArray.length;
        }
        this.guardBytes -= byArray.length - n2;
        return byArray.length - n2;
    }

    public int remaining() {
        int n = 0;
        if (this.buffer != null) {
            n += this.buffer.remaining();
        }
        for (int i = 0; i < this.rawData.size(); ++i) {
            Slice slice = (Slice)this.rawData.get(i);
            n += slice.length;
        }
        return n -= this.guardBytes;
    }

    public byte peek() throws BufferUnderflowException {
        byte[] byArray = new byte[1];
        if (this.peek(byArray) != 1) {
            throw new BufferUnderflowException();
        }
        return byArray[0];
    }

    public int peek(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        try {
            this.commit(byArray.length);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            n = this.buffer.remaining();
        }
        byte[] byArray2 = this.buffer.array();
        n2 = this.buffer.arrayOffset() + this.buffer.position();
        System.arraycopy(byArray2, n2, byArray, 0, n);
        return n;
    }

    public void skip(int n) {
        this.commit(n);
        this.buffer.position(this.buffer.position() + n);
    }

    public synchronized void put(byte[] byArray, int n) {
        int n2;
        if (n >= 0) {
            throw new IndexOutOfBoundsException("Value must be negative: " + n);
        }
        if (n < -this.guardBytes) {
            throw new IndexOutOfBoundsException("Insufficient guard bytes to insert at index: " + n);
        }
        int n3 = -n;
        int n4 = this.guardBytes - n3;
        Slice slice = null;
        for (n2 = this.rawData.size() - 1; n2 >= 0; --n2) {
            slice = (Slice)this.rawData.get(n2);
            if (n3 <= slice.length) break;
            n3 -= slice.length;
            slice = null;
        }
        if (slice == null) {
            if (this.buffer == null || n3 > this.buffer.remaining()) {
                throw new IndexOutOfBoundsException("Index references past the begining of the data");
            }
            n2 = this.buffer.arrayOffset() + this.buffer.limit() - n3 - n4;
            int n5 = n3 + n4;
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.buffer.array(), n2, byArray2, 0, n5);
            slice = new Slice(byArray2, 0, byArray2.length);
            this.rawData.add(0, slice);
            this.buffer.limit(this.buffer.limit() - n5);
        }
        byte[] byArray3 = new byte[slice.length + byArray.length];
        if (slice.length > n3) {
            System.arraycopy(slice.data, slice.offset, byArray3, 0, slice.length - n3);
        }
        System.arraycopy(byArray, 0, byArray3, slice.length - n3, byArray.length);
        System.arraycopy(slice.data, slice.offset + slice.length - n3, byArray3, slice.length - n3 + byArray.length, n3);
        this.guardBytes += byArray.length;
        slice.data = byArray3;
        slice.offset = 0;
        slice.length = byArray3.length;
    }

    public synchronized byte put(byte by, int n) {
        byte[] byArray;
        if (n >= 0) {
            throw new IndexOutOfBoundsException("Value must be negative: " + n);
        }
        if (n < -this.guardBytes) {
            throw new IndexOutOfBoundsException("Insufficient guard bytes to insert at index: " + n);
        }
        int n2 = -n;
        Slice slice = null;
        int n3 = 0;
        for (int i = this.rawData.size() - 1; i >= 0; --i) {
            slice = (Slice)this.rawData.get(i);
            if (n2 <= slice.length) break;
            n2 -= slice.length;
            slice = null;
        }
        if (slice != null) {
            byArray = slice.data;
            n3 = slice.offset + slice.length - n2;
        } else if (this.buffer != null && n2 <= this.buffer.remaining()) {
            byArray = this.buffer.array();
            n3 = this.buffer.arrayOffset() + this.buffer.position() + this.buffer.remaining() - n2;
        } else {
            throw new IndexOutOfBoundsException("Index references past the begining of the data");
        }
        byte by2 = byArray[n3];
        byArray[n3] = by;
        return by2;
    }

    static class Slice {
        byte[] data;
        int offset;
        int length;

        Slice(byte[] byArray, int n, int n2) {
            this.data = byArray;
            this.offset = n;
            this.length = n2;
        }
    }
}

