/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ActiveSection;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.ProcessorSection;
import com.ibm.jvm.trace.format.api.ServiceSection;
import com.ibm.jvm.trace.format.api.StartupSection;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TraceSection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TraceFileHeader {
    TraceContext context;
    String textSummary;
    int recordSize;
    int endianSignature;
    ByteOrder byteOrder;
    boolean ascii = true;
    protected DataHeader dataHeader;
    protected TraceSection traceSection;
    protected ServiceSection serviceSection;
    protected StartupSection startupSection;
    protected ActiveSection activeSection;
    protected ProcessorSection processorSection;
    private static final int BIG_ENDIAN_SIG = 305419896;
    private static final int LITTLE_ENDIAN_SIG = 2018915346;
    private static final int eyecatcherASCII = 0x55545448;
    private static final int eyecatcherEBCDIC = -454827064;

    TraceFileHeader(int n, ByteOrder byteOrder) {
        this.recordSize = n;
        this.byteOrder = byteOrder;
    }

    protected TraceFileHeader(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        int n = byteBuffer.position();
        traceContext.metadata = this;
        try {
            this.endianSignature = byteBuffer.getInt(n + 16 + 4);
            switch (this.endianSignature) {
                case 305419896: {
                    this.byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case 2018915346: {
                    this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid endian signature in trace file header: " + Long.toString(this.endianSignature, 16));
                }
            }
            traceContext.debug(this, 1, "Data is " + this.byteOrder.toString());
            byteBuffer.order(this.byteOrder);
            this.dataHeader = new DataHeader(traceContext, byteBuffer, "UTTH");
            if (this.dataHeader.ascii) {
                traceContext.debug(this, 1, "Eyecatchers are in ASCII");
                this.ascii = true;
            } else {
                traceContext.debug(this, 1, "Eyecatchers are in EBCDIC");
                this.ascii = false;
            }
            this.recordSize = byteBuffer.getInt();
            this.endianSignature = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            int n6 = byteBuffer.getInt();
            if (traceContext.debugStream != null) {
                traceContext.debug(this, 1, this.summary());
            }
            this.processorSection = new ProcessorSection(traceContext, (ByteBuffer)byteBuffer.position(n6 + n));
            this.traceSection = new TraceSection(traceContext, (ByteBuffer)byteBuffer.position(n2 + n));
            this.serviceSection = new ServiceSection(traceContext, (ByteBuffer)byteBuffer.position(n3 + n));
            this.startupSection = new StartupSection(traceContext, (ByteBuffer)byteBuffer.position(n4 + n));
            this.activeSection = new ActiveSection(traceContext, (ByteBuffer)byteBuffer.position(n5 + n));
            traceContext.version = (float)this.dataHeader.version + (float)this.dataHeader.modification / 10.0f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Truncated trace file header");
        }
    }

    public String toString() {
        return "Trace file header";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            stringBuilder.append("recordSize:     ").append(this.recordSize).append(System.getProperty("line.separator"));
            stringBuilder.append("endianSignature: 0x").append(Long.toString(this.endianSignature, 16)).append(System.getProperty("line.separator"));
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

