/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaStream;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaEvent
implements AutoCloseable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_BLOCKING_SYNC = 1;
    public static final int FLAG_DISABLE_TIMING = 2;
    public static final int FLAG_INTERPROCESS = 4;
    private final int deviceId;
    private final AtomicLong nativeHandle;

    private static native long create(int var0, int var1) throws CudaException;

    private static native void destroy(int var0, long var1) throws CudaException;

    private static native float elapsedTimeSince(long var0, long var2) throws CudaException;

    private static native int query(long var0);

    private static native void record(int var0, long var1, long var3) throws CudaException;

    private static native void synchronize(long var0) throws CudaException;

    public CudaEvent(CudaDevice cudaDevice) throws CudaException {
        this(cudaDevice, 0);
    }

    public CudaEvent(CudaDevice cudaDevice, int n) throws CudaException {
        this.deviceId = cudaDevice.getDeviceId();
        this.nativeHandle = new AtomicLong(CudaEvent.create(this.deviceId, n));
    }

    @Override
    public void close() throws CudaException {
        long l = this.nativeHandle.getAndSet(0L);
        if (l != 0L) {
            CudaEvent.destroy(this.deviceId, l);
        }
    }

    public float elapsedTimeSince(CudaEvent cudaEvent) throws CudaException {
        return CudaEvent.elapsedTimeSince(this.getHandle(), cudaEvent.getHandle());
    }

    long getHandle() {
        long l = this.nativeHandle.get();
        if (l == 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    public int query() {
        return CudaEvent.query(this.getHandle());
    }

    public void record(CudaDevice cudaDevice) throws CudaException {
        CudaEvent.record(cudaDevice.getDeviceId(), 0L, this.getHandle());
    }

    public void record(CudaStream cudaStream) throws CudaException {
        CudaEvent.record(cudaStream.deviceId, cudaStream.getHandle(), this.getHandle());
    }

    public void synchronize() throws CudaException {
        CudaEvent.synchronize(this.getHandle());
    }
}

