/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.util.CurveDB;
import sun.security.util.NamedCurve;

final class SunECEntries {
    private static final boolean nativeCryptTrace = NativeCrypto.isTraceEnabled();
    private static final boolean isAIX = "AIX".equals(System.getProperty("os.name"));
    private static final boolean useNativeECDH = NativeCrypto.isAlgorithmEnabled((String)"jdk.nativeEC", (String)"ECDH");
    private static final boolean useNativeECKeyGen = NativeCrypto.isAlgorithmEnabled((String)"jdk.nativeECKeyGen", (String)"ECKeyGen");
    private static final boolean useNativeECDSA = NativeCrypto.isAlgorithmEnabled((String)"jdk.nativeECDSA", (String)"ECDSA");

    private SunECEntries() {
    }

    static void putEntries(Map<Object, Object> map, boolean bl) {
        map.put("KeyFactory.EC", "sun.security.ec.ECKeyFactory");
        map.put("Alg.Alias.KeyFactory.EllipticCurve", "EC");
        map.put("KeyFactory.EC ImplementedIn", "Software");
        map.put("AlgorithmParameters.EC", "sun.security.util.ECParameters");
        map.put("Alg.Alias.AlgorithmParameters.EllipticCurve", "EC");
        map.put("Alg.Alias.AlgorithmParameters.1.2.840.10045.2.1", "EC");
        map.put("AlgorithmParameters.EC KeySize", "256");
        map.put("AlgorithmParameters.EC ImplementedIn", "Software");
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile(",|\\[|\\]");
        Collection collection = CurveDB.getSupportedCurves();
        for (NamedCurve namedCurve : collection) {
            String[] stringArray;
            if (!bl2) {
                stringBuilder.append("|");
            } else {
                bl2 = false;
            }
            stringBuilder.append("[");
            for (String string : stringArray = pattern.split(namedCurve.getName())) {
                stringBuilder.append(string.trim());
                stringBuilder.append(",");
            }
            stringBuilder.append(namedCurve.getObjectId());
            stringBuilder.append("]");
        }
        map.put("AlgorithmParameters.EC SupportedCurves", stringBuilder.toString());
        if (!bl) {
            return;
        }
        if (useNativeECDSA && NativeCrypto.getVersionIfAvailable() >= 0x10101000L) {
            map.put("Signature.NONEwithECDSA", "sun.security.ec.NativeECDSASignature$Raw");
            map.put("Signature.SHA1withECDSA", "sun.security.ec.NativeECDSASignature$SHA1");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.1", "SHA1withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.1", "SHA1withECDSA");
            map.put("Signature.SHA224withECDSA", "sun.security.ec.NativeECDSASignature$SHA224");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.1", "SHA224withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.1", "SHA224withECDSA");
            map.put("Signature.SHA256withECDSA", "sun.security.ec.NativeECDSASignature$SHA256");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.2", "SHA256withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.2", "SHA256withECDSA");
            map.put("Signature.SHA384withECDSA", "sun.security.ec.NativeECDSASignature$SHA384");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.3", "SHA384withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.3", "SHA384withECDSA");
            map.put("Signature.SHA512withECDSA", "sun.security.ec.NativeECDSASignature$SHA512");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.4", "SHA512withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.4", "SHA512withECDSA");
        } else {
            map.put("Signature.NONEwithECDSA", "sun.security.ec.ECDSASignature$Raw");
            map.put("Signature.SHA1withECDSA", "sun.security.ec.ECDSASignature$SHA1");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.1", "SHA1withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.1", "SHA1withECDSA");
            map.put("Signature.SHA224withECDSA", "sun.security.ec.ECDSASignature$SHA224");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.1", "SHA224withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.1", "SHA224withECDSA");
            map.put("Signature.SHA256withECDSA", "sun.security.ec.ECDSASignature$SHA256");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.2", "SHA256withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.2", "SHA256withECDSA");
            map.put("Signature.SHA384withECDSA", "sun.security.ec.ECDSASignature$SHA384");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.3", "SHA384withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.3", "SHA384withECDSA");
            map.put("Signature.SHA512withECDSA", "sun.security.ec.ECDSASignature$SHA512");
            map.put("Alg.Alias.Signature.OID.1.2.840.10045.4.3.4", "SHA512withECDSA");
            map.put("Alg.Alias.Signature.1.2.840.10045.4.3.4", "SHA512withECDSA");
        }
        String string = "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey";
        map.put("Signature.NONEwithECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA1withECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA224withECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA256withECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA384withECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA512withECDSA SupportedKeyClasses", string);
        map.put("Signature.SHA1withECDSA KeySize", "256");
        map.put("Signature.NONEwithECDSA ImplementedIn", "Software");
        map.put("Signature.SHA1withECDSA ImplementedIn", "Software");
        map.put("Signature.SHA224withECDSA ImplementedIn", "Software");
        map.put("Signature.SHA256withECDSA ImplementedIn", "Software");
        map.put("Signature.SHA384withECDSA ImplementedIn", "Software");
        map.put("Signature.SHA512withECDSA ImplementedIn", "Software");
        if (useNativeECKeyGen && NativeCrypto.getVersionIfAvailable() >= 0x10100000L && !isAIX) {
            map.put("KeyPairGenerator.EC", "sun.security.ec.NativeECKeyPairGenerator");
        } else {
            map.put("KeyPairGenerator.EC", "sun.security.ec.ECKeyPairGenerator");
        }
        map.put("Alg.Alias.KeyPairGenerator.EllipticCurve", "EC");
        map.put("KeyPairGenerator.EC KeySize", "256");
        map.put("KeyPairGenerator.EC ImplementedIn", "Software");
        if (useNativeECDH) {
            map.put("KeyAgreement.ECDH", "sun.security.ec.NativeECDHKeyAgreement");
        } else {
            map.put("KeyAgreement.ECDH", "sun.security.ec.ECDHKeyAgreement");
        }
        map.put("KeyAgreement.ECDH SupportedKeyClasses", string);
        map.put("KeyAgreement.ECDH ImplementedIn", "Software");
    }
}

