/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public class GCClassSuperclassesIterator
extends GCIterator {
    protected PointerPointer superclasses;
    protected UDATA classDepth;
    protected UDATA index;

    protected GCClassSuperclassesIterator(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        this.superclasses = j9ClassPointer.superclasses();
        this.classDepth = J9ClassHelper.classDepth(j9ClassPointer);
        this.index = new UDATA(0L);
    }

    public static GCClassSuperclassesIterator fromJ9Class(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new GCClassSuperclassesIterator(j9ClassPointer);
    }

    @Override
    public boolean hasNext() {
        if (this.classDepth.eq(0L)) {
            return false;
        }
        return this.index.lt(this.classDepth);
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            try {
                J9ClassPointer j9ClassPointer = J9ClassPointer.cast(this.superclasses.at(this.index));
                this.index = this.index.add(1L);
                return j9ClassPointer;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            VoidPointer voidPointer = VoidPointer.cast(this.superclasses.add(this.index));
            this.index = this.index.add(1L);
            return voidPointer;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

