/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.memory;

import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.memory.IMemoryTypes;

public class MemorySectionParser
extends SectionParser
implements IMemoryTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public MemorySectionParser() {
        super("MEMINFO");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        if (this.fImageAddressSpaceBuilder != null) {
            this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        }
        this.memInfo();
    }

    private void memInfo() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineOptional("1STHEAPALLOC");
        iAttributeValueMap = this.processTagLineOptional("1STHEAPFREE");
        while ((iAttributeValueMap = this.processTagLineOptional("1STSEGTYPE")) != null) {
            String string = iAttributeValueMap.getTokenValue("memory_segment_name");
            while ((iAttributeValueMap = this.processTagLineOptional("1STSEGMENT")) != null) {
                long l;
                long l2 = iAttributeValueMap.getLongValue("memory_segment_id");
                String string2 = l2 != -1L ? string + " segment 0x" + Long.toHexString(l2) : string;
                long l3 = iAttributeValueMap.getLongValue("memory_segment_head");
                long l4 = iAttributeValueMap.getLongValue("memory_segment_size");
                long l5 = iAttributeValueMap.getLongValue("memory_segment_free");
                long l6 = iAttributeValueMap.getLongValue("memory_segment_tail");
                if (l3 != -1L && l5 != -1L && (l = l5 - l3) != 0L) {
                    this.fImageAddressSpaceBuilder.addImageSection(string2 + " head", l3, l);
                }
                if (l5 != -1L && l6 != -1L && (l = l6 - l5) != 0L) {
                    this.fImageAddressSpaceBuilder.addImageSection(string2 + " free", l5, l);
                }
                if (l3 == -1L || l6 == -1L || l4 == -1L || (l = l3 + l4 - l6) == 0L) continue;
                this.fImageAddressSpaceBuilder.addImageSection(string2 + " tail", l6, l);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

