/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import java.io.PrintStream;
import java.util.ArrayList;

public class Table {
    int numColumns = -1;
    String title = null;
    ArrayList<String[]> rows = new ArrayList();

    public Table(String string) {
        this.title = string;
    }

    public Table row(String ... stringArray) {
        if (-1 == this.numColumns) {
            this.numColumns = stringArray.length;
        } else if (stringArray.length != this.numColumns) {
            throw new IllegalArgumentException("Invalid row, expected " + this.numColumns + " elements but got " + stringArray.length);
        }
        this.rows.add(stringArray);
        return this;
    }

    private int[] computeColumnWidths() {
        int[] nArray = new int[this.numColumns];
        for (String[] stringArray : this.rows) {
            int n = 0;
            for (String string : stringArray) {
                if (string.length() > nArray[n]) {
                    nArray[n] = string.length();
                }
                ++n;
            }
        }
        return nArray;
    }

    public void render(PrintStream printStream) {
        int[] nArray = this.computeColumnWidths();
        this.title.length();
        int n = 0;
        String string = "  ";
        printStream.println();
        printStream.println(this.title);
        for (int i = 0; i < this.title.length(); ++i) {
            printStream.append("=");
        }
        printStream.println();
        for (String[] stringArray : this.rows) {
            int n2 = 0;
            for (String string2 : stringArray) {
                int n3 = nArray[n2];
                String string3 = "%-" + n3 + "s";
                printStream.append(String.format(string3, string2));
                printStream.append(string);
                ++n2;
            }
            printStream.append("\n");
            if (n == 0) {
                for (int i = 0; i < this.numColumns; ++i) {
                    int n4 = nArray[i];
                    for (int j = 0; j < n4; ++j) {
                        printStream.append("-");
                    }
                    printStream.append(string);
                }
                printStream.append("\n");
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        new Table("Test").row("col1", "col2", "col3").row("value-1", "value-2", "value-3").row("a longer value", "short", "value-3").render(System.out);
    }
}

