/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9SFStackFrame;

public class TerseStackWalkerCallbacks
implements IStackWalkerCallbacks {
    @Override
    public FrameCallbackResult frameWalkFunction(WalkState walkState) {
        try {
            if (walkState.method.notNull()) {
                J9MethodPointer j9MethodPointer = walkState.method;
                J9UTF8Pointer j9UTF8Pointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer).romClass().className();
                J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer);
                J9UTF8Pointer j9UTF8Pointer2 = j9ROMMethodPointer.nameAndSignature().name();
                J9UTF8Pointer j9UTF8Pointer3 = j9ROMMethodPointer.nameAndSignature().signature();
                StackWalkerUtils.swPrintf(walkState, 0, "\t!j9method {3}   {0}.{1}{2}", J9UTF8Helper.stringValue(j9UTF8Pointer), J9UTF8Helper.stringValue(j9UTF8Pointer2), J9UTF8Helper.stringValue(j9UTF8Pointer3), walkState.method.getHexAddress());
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_JNI_NATIVE_METHOD) {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        Native method frame", new Object[0]);
            } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_GENERIC_SPECIAL) {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        Generic special frame", new Object[0]);
            } else if (walkState.pc.getAddress() == J9SFStackFrame.J9SF_FRAME_TYPE_METHODTYPE) {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        MethodType frame", new Object[0]);
            } else if (walkState.pc.getAddress() > J9SFStackFrame.J9SF_MAX_SPECIAL_FRAME_TYPE) {
                if (walkState.pc.getAddress() == walkState.javaVM.callInReturnPC().getAddress() || walkState.pc.getAddress() == walkState.javaVM.callInReturnPC().getAddress() + 3L) {
                    StackWalkerUtils.swPrintf(walkState, 0, "\t                        JNI call-in frame", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 0, "\t                        unknown frame type {0} *{1}", walkState.pc, walkState.pc.getHexAddress());
                }
            } else {
                StackWalkerUtils.swPrintf(walkState, 0, "\t                        known but unhandled frame type {0}", walkState.pc);
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
        return FrameCallbackResult.KEEP_ITERATING;
    }

    @Override
    public void objectSlotWalkFunction(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
    }

    @Override
    public void fieldSlotWalkFunction(WalkState walkState, ObjectReferencePointer objectReferencePointer, VoidPointer voidPointer) {
    }
}

