/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;

public class U64Pointer
extends UDATAPointer {
    public static final int SIZEOF = 8;
    public static final U64Pointer NULL = new U64Pointer(0L);

    protected U64Pointer(long l) {
        super(l);
    }

    public static U64Pointer cast(AbstractPointer abstractPointer) {
        return U64Pointer.cast(abstractPointer.getAddress());
    }

    public static U64Pointer cast(UDATA uDATA) {
        return U64Pointer.cast(uDATA.longValue());
    }

    public static U64Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new U64Pointer(l);
    }

    @Override
    public U64 at(long l) throws CorruptDataException {
        return new U64(this.getLongAtOffset(l * 8L));
    }

    @Override
    public U64 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public U64Pointer untag() {
        return this.untag(7L);
    }

    @Override
    public U64Pointer untag(long l) {
        return new U64Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U64Pointer add(long l) {
        return new U64Pointer(this.address + 8L * l);
    }

    @Override
    public U64Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public U64Pointer addOffset(long l) {
        return new U64Pointer(this.address + l);
    }

    @Override
    public U64Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public U64Pointer sub(long l) {
        return new U64Pointer(this.address - 8L * l);
    }

    @Override
    public U64Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public U64Pointer subOffset(long l) {
        return new U64Pointer(this.address - l);
    }

    @Override
    public U64Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 8L;
    }
}

