/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

public class ByteArrayMarshaller {
    private ByteArrayMarshaller() {
    }

    public static void writeShort(short s, byte[] byArray, int n, boolean bl) {
        if (n + 2 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeShort is trying to access byteArray[" + n + "] and byteArray[" + (n + 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            ByteArrayMarshaller.writeShort_(s, byArray, n, true);
        } else {
            ByteArrayMarshaller.writeShort_(s, byArray, n, false);
        }
    }

    private static void writeShort_(short s, byte[] byArray, int n, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(s >> 8);
            byArray[n + 1] = (byte)s;
        } else {
            byArray[n + 1] = (byte)(s >> 8);
            byArray[n] = (byte)s;
        }
    }

    public static void writeShort(short s, byte[] byArray, int n, boolean bl, int n2) {
        if (n + n2 > byArray.length && n2 > 0 && n2 <= 2) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeShort is trying to access byteArray[" + n + "] to byteArray[" + (n + n2 - 1) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("numBytes == " + n2);
        }
        if (bl) {
            ByteArrayMarshaller.writeShort_(s, byArray, n, true, n2);
        } else {
            ByteArrayMarshaller.writeShort_(s, byArray, n, false, n2);
        }
    }

    private static void writeShort_(short s, byte[] byArray, int n, boolean bl, int n2) {
        int n3 = n;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                byArray[n3] = (byte)s;
                break;
            }
            case 2: {
                if (bl) {
                    byArray[n3] = (byte)(s >> 8);
                    byArray[n3 + 1] = (byte)s;
                    break;
                }
                byArray[n3 + 1] = (byte)(s >> 8);
                byArray[n3] = (byte)s;
            }
        }
    }

    public static void writeInt(int n, byte[] byArray, int n2, boolean bl) {
        if (n2 + 4 > byArray.length || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeInt is trying to access byteArray[" + n2 + "] to byteArray[" + (n2 + 3) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            ByteArrayMarshaller.writeInt_(n, byArray, n2, true);
        } else {
            ByteArrayMarshaller.writeInt_(n, byArray, n2, false);
        }
    }

    private static void writeInt_(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2] = (byte)(n >> 24);
            byArray[n2 + 1] = (byte)(n >> 16);
            byArray[n2 + 2] = (byte)(n >> 8);
            byArray[n2 + 3] = (byte)n;
        } else {
            byArray[n2 + 3] = (byte)(n >> 24);
            byArray[n2 + 2] = (byte)(n >> 16);
            byArray[n2 + 1] = (byte)(n >> 8);
            byArray[n2] = (byte)n;
        }
    }

    public static void writeInt(int n, byte[] byArray, int n2, boolean bl, int n3) {
        if (n2 + n3 > byArray.length && n3 <= 4 && n3 > 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeInt is trying to access byteArray[" + n2 + "] to byteArray[" + (n2 + n3 - 1) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException("numBytes == " + n3);
        }
        if (bl) {
            ByteArrayMarshaller.writeInt_(n, byArray, n2, true, n3);
        } else {
            ByteArrayMarshaller.writeInt_(n, byArray, n2, false, n3);
        }
    }

    private static void writeInt_(int n, byte[] byArray, int n2, boolean bl, int n3) {
        int n4 = n2;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                byArray[n4] = (byte)n;
                break;
            }
            case 2: {
                if (bl) {
                    byArray[n4] = (byte)(n >> 8);
                    byArray[n4 + 1] = (byte)n;
                    break;
                }
                byArray[n4 + 1] = (byte)(n >> 8);
                byArray[n4] = (byte)n;
                break;
            }
            case 3: {
                if (bl) {
                    byArray[n4] = (byte)(n >> 16);
                    byArray[n4 + 1] = (byte)(n >> 8);
                    byArray[n4 + 2] = (byte)n;
                    break;
                }
                byArray[n4 + 2] = (byte)(n >> 16);
                byArray[n4 + 1] = (byte)(n >> 8);
                byArray[n4] = (byte)n;
                break;
            }
            case 4: {
                if (bl) {
                    byArray[n4] = (byte)(n >> 24);
                    byArray[n4 + 1] = (byte)(n >> 16);
                    byArray[n4 + 2] = (byte)(n >> 8);
                    byArray[n4 + 3] = (byte)n;
                    break;
                }
                byArray[n4 + 3] = (byte)(n >> 24);
                byArray[n4 + 2] = (byte)(n >> 16);
                byArray[n4 + 1] = (byte)(n >> 8);
                byArray[n4] = (byte)n;
            }
        }
    }

    public static void writeLong(long l, byte[] byArray, int n, boolean bl) {
        if (n + 8 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeLong is trying to access byteArray[" + n + "] to byteArray[" + (n + 7) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            ByteArrayMarshaller.writeLong_(l, byArray, n, true);
        } else {
            ByteArrayMarshaller.writeLong_(l, byArray, n, false);
        }
    }

    private static void writeLong_(long l, byte[] byArray, int n, boolean bl) {
        if (bl) {
            byArray[n] = (byte)(l >> 56);
            byArray[n + 1] = (byte)(l >> 48);
            byArray[n + 2] = (byte)(l >> 40);
            byArray[n + 3] = (byte)(l >> 32);
            byArray[n + 4] = (byte)(l >> 24);
            byArray[n + 5] = (byte)(l >> 16);
            byArray[n + 6] = (byte)(l >> 8);
            byArray[n + 7] = (byte)l;
        } else {
            byArray[n + 7] = (byte)(l >> 56);
            byArray[n + 6] = (byte)(l >> 48);
            byArray[n + 5] = (byte)(l >> 40);
            byArray[n + 4] = (byte)(l >> 32);
            byArray[n + 3] = (byte)(l >> 24);
            byArray[n + 2] = (byte)(l >> 16);
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n] = (byte)l;
        }
    }

    public static void writeLong(long l, byte[] byArray, int n, boolean bl, int n2) {
        if (n + n2 > byArray.length && n2 > 0 && n2 <= 8) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeLong is trying to access byteArray[" + n + "] to byteArray[" + (n + n2 - 1) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("numBytes == " + n2);
        }
        if (bl) {
            ByteArrayMarshaller.writeLong_(l, byArray, n, true, n2);
        } else {
            ByteArrayMarshaller.writeLong_(l, byArray, n, false, n2);
        }
    }

    private static void writeLong_(long l, byte[] byArray, int n, boolean bl, int n2) {
        int n3 = n;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                byArray[n3] = (byte)l;
                break;
            }
            case 2: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 8);
                    byArray[n3 + 1] = (byte)l;
                    break;
                }
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 3: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 16);
                    byArray[n3 + 1] = (byte)(l >> 8);
                    byArray[n3 + 2] = (byte)l;
                    break;
                }
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 4: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 24);
                    byArray[n3 + 1] = (byte)(l >> 16);
                    byArray[n3 + 2] = (byte)(l >> 8);
                    byArray[n3 + 3] = (byte)l;
                    break;
                }
                byArray[n3 + 3] = (byte)(l >> 24);
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 5: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 32);
                    byArray[n3 + 1] = (byte)(l >> 24);
                    byArray[n3 + 2] = (byte)(l >> 16);
                    byArray[n3 + 3] = (byte)(l >> 8);
                    byArray[n3 + 4] = (byte)l;
                    break;
                }
                byArray[n3 + 4] = (byte)(l >> 32);
                byArray[n3 + 3] = (byte)(l >> 24);
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 6: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 40);
                    byArray[n3 + 1] = (byte)(l >> 32);
                    byArray[n3 + 2] = (byte)(l >> 24);
                    byArray[n3 + 3] = (byte)(l >> 16);
                    byArray[n3 + 4] = (byte)(l >> 8);
                    byArray[n3 + 5] = (byte)l;
                    break;
                }
                byArray[n3 + 5] = (byte)(l >> 40);
                byArray[n3 + 4] = (byte)(l >> 32);
                byArray[n3 + 3] = (byte)(l >> 24);
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 7: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 48);
                    byArray[n3 + 1] = (byte)(l >> 40);
                    byArray[n3 + 2] = (byte)(l >> 32);
                    byArray[n3 + 3] = (byte)(l >> 24);
                    byArray[n3 + 4] = (byte)(l >> 16);
                    byArray[n3 + 5] = (byte)(l >> 8);
                    byArray[n3 + 6] = (byte)l;
                    break;
                }
                byArray[n3 + 6] = (byte)(l >> 48);
                byArray[n3 + 5] = (byte)(l >> 40);
                byArray[n3 + 4] = (byte)(l >> 32);
                byArray[n3 + 3] = (byte)(l >> 24);
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
                break;
            }
            case 8: {
                if (bl) {
                    byArray[n3] = (byte)(l >> 56);
                    byArray[n3 + 1] = (byte)(l >> 48);
                    byArray[n3 + 2] = (byte)(l >> 40);
                    byArray[n3 + 3] = (byte)(l >> 32);
                    byArray[n3 + 4] = (byte)(l >> 24);
                    byArray[n3 + 5] = (byte)(l >> 16);
                    byArray[n3 + 6] = (byte)(l >> 8);
                    byArray[n3 + 7] = (byte)l;
                    break;
                }
                byArray[n3 + 7] = (byte)(l >> 56);
                byArray[n3 + 6] = (byte)(l >> 48);
                byArray[n3 + 5] = (byte)(l >> 40);
                byArray[n3 + 4] = (byte)(l >> 32);
                byArray[n3 + 3] = (byte)(l >> 24);
                byArray[n3 + 2] = (byte)(l >> 16);
                byArray[n3 + 1] = (byte)(l >> 8);
                byArray[n3] = (byte)l;
            }
        }
    }

    public static void writeFloat(float f, byte[] byArray, int n, boolean bl) {
        if (n + 4 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeFloat is trying to access byteArray[" + n + "] to byteArray[" + (n + 3) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            ByteArrayMarshaller.writeFloat_(f, byArray, n, true);
        } else {
            ByteArrayMarshaller.writeFloat_(f, byArray, n, false);
        }
    }

    private static void writeFloat_(float f, byte[] byArray, int n, boolean bl) {
        ByteArrayMarshaller.writeInt(Float.floatToIntBits(f), byArray, n, bl);
    }

    public static void writeDouble(double d, byte[] byArray, int n, boolean bl) {
        if (n + 8 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeDouble is trying to access byteArray[" + n + "] to byteArray[" + (n + 7) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            ByteArrayMarshaller.writeDouble_(d, byArray, n, true);
        } else {
            ByteArrayMarshaller.writeDouble_(d, byArray, n, false);
        }
    }

    private static void writeDouble_(double d, byte[] byArray, int n, boolean bl) {
        ByteArrayMarshaller.writeLong(Double.doubleToLongBits(d), byArray, n, bl);
    }
}

