/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.management.MemoryUsage;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class MemoryUsageUtil {
    private static CompositeType compositeType;
    private static CompositeType tabularRowType;
    private static TabularType tabularType;

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                String[] stringArray = new String[]{"init", "used", "committed", "max"};
                String[] stringArray2 = new String[]{"init", "used", "committed", "max"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                try {
                    compositeType = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    private static CompositeType getTabularRowType() {
        block3: {
            if (null == tabularRowType) {
                String[] stringArray = new String[]{"key", "value"};
                String[] stringArray2 = new String[]{"key", "value"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, MemoryUsageUtil.getCompositeType()};
                try {
                    tabularRowType = new CompositeType("MemoryUsageKeyValue", "MemoryUsageKeyValue", stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return tabularRowType;
    }

    public static TabularType getTabularType() {
        block3: {
            if (null == tabularType) {
                CompositeType compositeType = MemoryUsageUtil.getTabularRowType();
                try {
                    tabularType = new TabularType("Memory Usage Map", "Memory Usage Map", compositeType, new String[]{"key"});
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return tabularType;
    }

    public static CompositeData toCompositeData(MemoryUsage memoryUsage) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            compositeDataSupport = null;
            if (memoryUsage != null) {
                CompositeType compositeType = MemoryUsageUtil.getCompositeType();
                String[] stringArray = new String[]{"init", "used", "committed", "max"};
                Object[] objectArray = new Object[]{memoryUsage.getInit(), memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax()};
                try {
                    compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeDataSupport;
    }

    public static TabularData toTabularData(Map<String, MemoryUsage> map) {
        TabularDataSupport tabularDataSupport = null;
        if (null != map) {
            CompositeType compositeType = MemoryUsageUtil.getTabularRowType();
            String[] stringArray = new String[]{"key", "value"};
            tabularDataSupport = new TabularDataSupport(MemoryUsageUtil.getTabularType());
            for (Map.Entry<String, MemoryUsage> entry : map.entrySet()) {
                CompositeDataSupport compositeDataSupport;
                block4: {
                    Object[] objectArray = new Object[]{entry.getKey(), MemoryUsageUtil.toCompositeData(entry.getValue())};
                    compositeDataSupport = null;
                    try {
                        compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                    }
                    catch (OpenDataException openDataException) {
                        if (!ManagementUtils.VERBOSE_MODE) break block4;
                        openDataException.printStackTrace(System.err);
                    }
                }
                tabularDataSupport.put(compositeDataSupport);
            }
        }
        return tabularDataSupport;
    }

    private MemoryUsageUtil() {
    }
}

