/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Objects;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

final class MethodHandleResolver {
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final JITHelpers JITHELPERS = JITHelpers.getHelpers();
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    MethodHandleResolver() {
    }

    private static final native int getCPTypeAt(Object var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Object var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Object var0, int var1);

    private static final native String getCPClassNameAt(Object var0, int var1);

    private static Object constructorPlaceHolder(Object object) {
        return object;
    }

    private static final Object invokeBsm(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
        Object object = null;
        switch (objectArray.length) {
            case 3: {
                object = methodHandle.invoke(objectArray[0], objectArray[1], objectArray[2]);
                break;
            }
            case 4: {
                object = methodHandle.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                break;
            }
            case 5: {
                object = methodHandle.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
                break;
            }
            case 6: {
                object = methodHandle.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5]);
                break;
            }
            case 7: {
                object = methodHandle.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6]);
                break;
            }
            default: {
                object = methodHandle.invokeWithArguments(objectArray);
            }
        }
        return object;
    }

    private static final Object resolveInvokeDynamic(long l, String string, String string2, long l2) throws Throwable {
        MethodHandle methodHandle = null;
        MethodType methodType = null;
        try {
            VMLangAccess vMLangAccess = VM.getVMLangAccess();
            Class<?> clazz = MethodHandleResolver.getClassFromJ9Class(l);
            Object object = vMLangAccess.getInternalConstantPoolFromJ9Class(l, clazz);
            methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, vMLangAccess.getClassloader(clazz), null);
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(clazz, false);
            try {
                lookup.accessCheckArgRetTypes(methodType);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessError illegalAccessError = new IllegalAccessError();
                illegalAccessError.initCause(illegalAccessException);
                throw illegalAccessError;
            }
            short s = UNSAFE.getShort(l2);
            int n = UNSAFE.getShort(l2 + 2L);
            long l3 = l2 + 4L;
            MethodHandle methodHandle2 = MethodHandleResolver.getCPMethodHandleAt(object, s);
            if (methodHandle2 == null) {
                throw new NullPointerException(Msg.getString("K05cd", (Object)clazz.toString(), s));
            }
            Object[] objectArray = new Object[3 + n];
            objectArray[0] = lookup;
            objectArray[1] = string;
            objectArray[2] = methodType;
            int n2 = methodHandle2.type().parameterCount();
            for (int i = 0; i < n; ++i) {
                objectArray[3 + i] = MethodHandleResolver.getAdditionalBsmArg(vMLangAccess, object, clazz, methodHandle2, l3, n2, i);
            }
            CallSite callSite = (CallSite)MethodHandleResolver.invokeBsm(methodHandle2, objectArray);
            if (callSite != null) {
                MethodType methodType2 = callSite.type();
                if (methodType2 != methodType) {
                    throw WrongMethodTypeException.newWrongMethodTypeException(methodType, methodType2);
                }
                methodHandle = callSite.dynamicInvoker();
            }
        }
        catch (Throwable throwable) {
            if (methodType == null) {
                throw new BootstrapMethodError(throwable);
            }
            try {
                MethodHandle methodHandle3 = MethodHandles.throwException(methodType.returnType(), BootstrapMethodError.class);
                MethodHandle methodHandle4 = MethodHandles.Lookup.IMPL_LOOKUP.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                methodHandle = MethodHandles.foldArguments(methodHandle3, methodHandle4.bindTo(throwable));
                methodHandle = MethodHandles.dropArguments(methodHandle, 0, methodType.parameterList());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error(noSuchMethodException);
            }
        }
        return methodHandle;
    }

    private static final MethodHandle sendResolveMethodHandle(int n, Class<?> clazz, Class<?> clazz2, String string, String string2, ClassLoader classLoader) throws Throwable {
        MethodType methodType = null;
        try {
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(clazz, false);
            MethodHandle methodHandle = null;
            switch (n) {
                case 1: {
                    methodHandle = lookup.findGetter(clazz2, string, MethodHandleResolver.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 2: {
                    methodHandle = lookup.findStaticGetter(clazz2, string, MethodHandleResolver.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 3: {
                    methodHandle = lookup.findSetter(clazz2, string, MethodHandleResolver.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 4: {
                    methodHandle = lookup.findStaticSetter(clazz2, string, MethodHandleResolver.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 5: {
                    methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findVirtual(clazz2, string, methodType);
                    break;
                }
                case 6: {
                    methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findStatic(clazz2, string, methodType);
                    break;
                }
                case 7: {
                    methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findSpecial(clazz2, string, methodType, clazz);
                    break;
                }
                case 8: {
                    methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findConstructor(clazz2, methodType);
                    break;
                }
                case 9: {
                    methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findVirtual(clazz2, string, methodType);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return methodHandle;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage()).initCause(illegalAccessException);
        }
    }

    private static final Class<?> resolveFieldHandleHelper(String string, MethodHandles.Lookup lookup, ClassLoader classLoader) throws Throwable {
        MethodType methodType = MethodTypeHelper.vmResolveFromMethodDescriptorString("(" + string + ")V", classLoader, null);
        lookup.accessCheckArgRetTypes(methodType);
        return methodType.parameterType(0);
    }

    private static final Class<?> getClassFromJ9Class(long l) throws Throwable {
        Class clazz = null;
        clazz = JITHELPERS.is32Bit() ? JITHELPERS.getClassFromJ9Class32((int)l) : JITHELPERS.getClassFromJ9Class64(l);
        Objects.requireNonNull(clazz);
        return clazz;
    }

    private static final Class<?> fromFieldDescriptorString(String string, ClassLoader classLoader) {
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", string));
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        MethodTypeHelper.parseIntoClass(cArray, 0, arrayList, classLoader, string);
        return arrayList.get(0);
    }

    private static final Object getAdditionalBsmArg(VMLangAccess vMLangAccess, Object object, Class<?> clazz, MethodHandle methodHandle, long l, int n, int n2) throws Throwable {
        boolean bl = methodHandle.isVarargsCollector();
        ConstantPool constantPool = vMLangAccess.getConstantPool(object);
        int n3 = 3 + n2;
        short s = UNSAFE.getShort(l + (long)(n2 * 2));
        int n4 = MethodHandleResolver.getCPTypeAt(object, s);
        Object object2 = null;
        switch (n4) {
            case 1: {
                object2 = constantPool.getClassAt(s);
                if (object2 != null) break;
                throw MethodHandleResolver.throwNoClassDefFoundError(object, s);
            }
            case 2: {
                object2 = constantPool.getStringAt(s);
                break;
            }
            case 3: {
                int n5 = constantPool.getIntAt(s);
                Class<?> clazz2 = null;
                if (bl && n3 >= n - 1) {
                    clazz2 = methodHandle.type().lastParameterType().getComponentType();
                } else if (n3 < n) {
                    clazz2 = methodHandle.type().parameterType(n3);
                }
                if (clazz2 == Short.TYPE) {
                    object2 = (short)n5;
                    break;
                }
                if (clazz2 == Boolean.TYPE) {
                    object2 = n5 == 0 ? Boolean.FALSE : Boolean.TRUE;
                    break;
                }
                if (clazz2 == Byte.TYPE) {
                    object2 = (byte)n5;
                    break;
                }
                if (clazz2 == Character.TYPE) {
                    object2 = Character.valueOf((char)n5);
                    break;
                }
                object2 = n5;
                break;
            }
            case 4: {
                object2 = Float.valueOf(constantPool.getFloatAt(s));
                break;
            }
            case 5: {
                object2 = constantPool.getLongAt(s);
                break;
            }
            case 6: {
                object2 = constantPool.getDoubleAt(s);
                break;
            }
            case 13: {
                object2 = MethodHandleResolver.getCPMethodTypeAt(object, s);
                break;
            }
            case 14: {
                object2 = MethodHandleResolver.getCPMethodHandleAt(object, s);
                break;
            }
        }
        object2.getClass();
        return object2;
    }

    private static final Throwable throwNoClassDefFoundError(Object object, int n) {
        String string = MethodHandleResolver.getCPClassNameAt(object, n);
        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(string);
        noClassDefFoundError.initCause(new ClassNotFoundException(string));
        throw noClassDefFoundError;
    }

    static long getJ9ClassFromClass(Class<?> clazz) {
        if (JITHELPERS.is32Bit()) {
            return JITHELPERS.getJ9ClassFromClass32(clazz);
        }
        return JITHELPERS.getJ9ClassFromClass64(clazz);
    }

    private static final Object linkCallerMethod(Class<?> clazz, int n, Class<?> clazz2, String string, String string2) throws Throwable {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }
}

