/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public abstract class DefaultRowSorter<M, I>
extends RowSorter<M> {
    private boolean sortsOnUpdates;
    private Row[] viewToModel;
    private int[] modelToView;
    private Comparator[] comparators;
    private boolean[] isSortable;
    private RowSorter.SortKey[] cachedSortKeys;
    private Comparator[] sortComparators;
    private RowFilter<? super M, ? super I> filter;
    private FilterEntry filterEntry;
    private List<RowSorter.SortKey> sortKeys = Collections.emptyList();
    private boolean[] useToString;
    private boolean sorted;
    private int maxSortKeys = 3;
    private ModelWrapper<M, I> modelWrapper;
    private int modelRowCount;

    protected final void setModelWrapper(ModelWrapper<M, I> modelWrapper) {
        if (modelWrapper == null) {
            throw new IllegalArgumentException("modelWrapper most be non-null");
        }
        ModelWrapper<M, I> modelWrapper2 = this.modelWrapper;
        this.modelWrapper = modelWrapper;
        if (modelWrapper2 != null) {
            this.modelStructureChanged();
        } else {
            this.modelRowCount = this.getModelWrapper().getRowCount();
        }
    }

    protected final ModelWrapper<M, I> getModelWrapper() {
        return this.modelWrapper;
    }

    @Override
    public final M getModel() {
        return this.getModelWrapper().getModel();
    }

    public void setSortable(int n, boolean bl) {
        this.checkColumn(n);
        if (this.isSortable == null) {
            this.isSortable = new boolean[this.getModelWrapper().getColumnCount()];
            for (int i = this.isSortable.length - 1; i >= 0; --i) {
                this.isSortable[i] = true;
            }
        }
        this.isSortable[n] = bl;
    }

    public boolean isSortable(int n) {
        this.checkColumn(n);
        return this.isSortable == null ? true : this.isSortable[n];
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> list) {
        List<RowSorter.SortKey> list2 = this.sortKeys;
        if (list != null && list.size() > 0) {
            int n = this.getModelWrapper().getColumnCount();
            for (RowSorter.SortKey sortKey : list) {
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < n) continue;
                throw new IllegalArgumentException("Invalid SortKey");
            }
            this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(list));
        } else {
            this.sortKeys = Collections.emptyList();
        }
        if (!this.sortKeys.equals(list2)) {
            this.fireSortOrderChanged();
            if (this.viewToModel == null) {
                this.sort();
            } else {
                this.sortExistingData();
            }
        }
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    public void setMaxSortKeys(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid max");
        }
        this.maxSortKeys = n;
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    public void setSortsOnUpdates(boolean bl) {
        this.sortsOnUpdates = bl;
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setRowFilter(RowFilter<? super M, ? super I> rowFilter) {
        this.filter = rowFilter;
        this.sort();
    }

    public RowFilter<? super M, ? super I> getRowFilter() {
        return this.filter;
    }

    @Override
    public void toggleSortOrder(int n) {
        this.checkColumn(n);
        if (this.isSortable(n)) {
            int n2;
            List<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (n2 = list.size() - 1; n2 >= 0 && ((RowSorter.SortKey)list.get(n2)).getColumn() != n; --n2) {
            }
            if (n2 == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(n, SortOrder.ASCENDING);
                list.add(0, sortKey);
            } else if (n2 == 0) {
                list.set(0, this.toggle((RowSorter.SortKey)list.get(0)));
            } else {
                list.remove(n2);
                list.add(0, new RowSorter.SortKey(n, SortOrder.ASCENDING));
            }
            if (list.size() > this.getMaxSortKeys()) {
                list = list.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(list);
        }
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey sortKey) {
        if (sortKey.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(sortKey.getColumn(), SortOrder.DESCENDING);
        }
        return new RowSorter.SortKey(sortKey.getColumn(), SortOrder.ASCENDING);
    }

    @Override
    public int convertRowIndexToView(int n) {
        if (this.modelToView == null) {
            if (n < 0 || n >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return n;
        }
        return this.modelToView[n];
    }

    @Override
    public int convertRowIndexToModel(int n) {
        if (this.viewToModel == null) {
            if (n < 0 || n >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return n;
        }
        return this.viewToModel[n].modelIndex;
    }

    private boolean isUnsorted() {
        List<RowSorter.SortKey> list = this.getSortKeys();
        int n = list.size();
        return n == 0 || list.get(0).getSortOrder() == SortOrder.UNSORTED;
    }

    private void sortExistingData() {
        int[] nArray = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        this.cacheSortKeys(this.getSortKeys());
        if (this.isUnsorted()) {
            if (this.getRowFilter() == null) {
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                int n = 0;
                for (int i = 0; i < this.modelToView.length; ++i) {
                    if (this.modelToView[i] == -1) continue;
                    this.viewToModel[n].modelIndex = i;
                    this.modelToView[i] = n++;
                }
            }
        } else {
            Arrays.sort(this.viewToModel);
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(nArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sort() {
        this.sorted = true;
        int[] nArray = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        if (this.isUnsorted()) {
            this.cachedSortKeys = new RowSorter.SortKey[0];
            if (this.getRowFilter() == null) {
                if (this.viewToModel == null) return;
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                this.initializeFilteredMapping();
            }
        } else {
            this.cacheSortKeys(this.getSortKeys());
            if (this.getRowFilter() != null) {
                this.initializeFilteredMapping();
            } else {
                this.createModelToView(this.getModelWrapper().getRowCount());
                this.createViewToModel(this.getModelWrapper().getRowCount());
            }
            Arrays.sort(this.viewToModel);
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(nArray);
    }

    private void updateUseToString() {
        int n = this.getModelWrapper().getColumnCount();
        if (this.useToString == null || this.useToString.length != n) {
            this.useToString = new boolean[n];
        }
        --n;
        while (n >= 0) {
            this.useToString[n] = this.useToString(n);
            --n;
        }
    }

    private void initializeFilteredMapping() {
        int n;
        int n2 = this.getModelWrapper().getRowCount();
        int n3 = 0;
        this.createModelToView(n2);
        for (n = 0; n < n2; ++n) {
            if (this.include(n)) {
                this.modelToView[n] = n - n3;
                continue;
            }
            this.modelToView[n] = -1;
            ++n3;
        }
        this.createViewToModel(n2 - n3);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.modelToView[n] == -1) continue;
            this.viewToModel[n4++].modelIndex = n;
        }
    }

    private void createModelToView(int n) {
        if (this.modelToView == null || this.modelToView.length != n) {
            this.modelToView = new int[n];
        }
    }

    private void createViewToModel(int n) {
        int n2;
        int n3 = 0;
        if (this.viewToModel != null) {
            n3 = Math.min(n, this.viewToModel.length);
            if (this.viewToModel.length != n) {
                Row[] rowArray = this.viewToModel;
                this.viewToModel = new Row[n];
                System.arraycopy((Object)rowArray, 0, (Object)this.viewToModel, 0, n3);
            }
        } else {
            this.viewToModel = new Row[n];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.viewToModel[n2].modelIndex = n2;
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.viewToModel[n2] = new Row(this, n2);
        }
    }

    private void cacheSortKeys(List<? extends RowSorter.SortKey> list) {
        int n = list.size();
        this.sortComparators = new Comparator[n];
        for (int i = 0; i < n; ++i) {
            this.sortComparators[i] = this.getComparator0(list.get(i).getColumn());
        }
        this.cachedSortKeys = list.toArray(new RowSorter.SortKey[n]);
    }

    protected boolean useToString(int n) {
        return this.getComparator(n) == null;
    }

    private void setModelToViewFromViewToModel(boolean bl) {
        int n;
        if (bl) {
            for (n = this.modelToView.length - 1; n >= 0; --n) {
                this.modelToView[n] = -1;
            }
        }
        for (n = this.viewToModel.length - 1; n >= 0; --n) {
            this.modelToView[this.viewToModel[n].modelIndex] = n;
        }
    }

    private int[] getViewToModelAsInts(Row[] rowArray) {
        if (rowArray != null) {
            int[] nArray = new int[rowArray.length];
            for (int i = rowArray.length - 1; i >= 0; --i) {
                nArray[i] = rowArray[i].modelIndex;
            }
            return nArray;
        }
        return new int[0];
    }

    public void setComparator(int n, Comparator<?> comparator) {
        this.checkColumn(n);
        if (this.comparators == null) {
            this.comparators = new Comparator[this.getModelWrapper().getColumnCount()];
        }
        this.comparators[n] = comparator;
    }

    public Comparator<?> getComparator(int n) {
        this.checkColumn(n);
        if (this.comparators != null) {
            return this.comparators[n];
        }
        return null;
    }

    private Comparator getComparator0(int n) {
        Comparator<?> comparator = this.getComparator(n);
        if (comparator != null) {
            return comparator;
        }
        return Collator.getInstance();
    }

    private RowFilter.Entry<M, I> getFilterEntry(int n) {
        if (this.filterEntry == null) {
            this.filterEntry = new FilterEntry();
        }
        this.filterEntry.modelIndex = n;
        return this.filterEntry;
    }

    @Override
    public int getViewRowCount() {
        if (this.viewToModel != null) {
            return this.viewToModel.length;
        }
        return this.getModelWrapper().getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.getModelWrapper().getRowCount();
    }

    private void allChanged() {
        this.modelToView = null;
        this.viewToModel = null;
        this.comparators = null;
        this.isSortable = null;
        if (this.isUnsorted()) {
            this.sort();
        } else {
            this.setSortKeys(null);
        }
    }

    @Override
    public void modelStructureChanged() {
        this.allChanged();
        this.modelRowCount = this.getModelWrapper().getRowCount();
    }

    @Override
    public void allRowsChanged() {
        this.modelRowCount = this.getModelWrapper().getRowCount();
        this.sort();
    }

    @Override
    public void rowsInserted(int n, int n2) {
        this.checkAgainstModel(n, n2);
        int n3 = this.getModelWrapper().getRowCount();
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = n3;
        if (this.shouldOptimizeChange(n, n2)) {
            this.rowsInserted0(n, n2);
        }
    }

    @Override
    public void rowsDeleted(int n, int n2) {
        this.checkAgainstModel(n, n2);
        if (n >= this.modelRowCount || n2 >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = this.getModelWrapper().getRowCount();
        if (this.shouldOptimizeChange(n, n2)) {
            this.rowsDeleted0(n, n2);
        }
    }

    @Override
    public void rowsUpdated(int n, int n2) {
        this.checkAgainstModel(n, n2);
        if (n >= this.modelRowCount || n2 >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        if (this.getSortsOnUpdates()) {
            if (this.shouldOptimizeChange(n, n2)) {
                this.rowsUpdated0(n, n2);
            }
        } else {
            this.sorted = false;
        }
    }

    @Override
    public void rowsUpdated(int n, int n2, int n3) {
        this.checkColumn(n3);
        this.rowsUpdated(n, n2);
    }

    private void checkAgainstModel(int n, int n2) {
        if (n > n2 || n < 0 || n2 < 0 || n > this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
    }

    private boolean include(int n) {
        RowFilter<M, I> rowFilter = this.getRowFilter();
        if (rowFilter != null) {
            return rowFilter.include(this.getFilterEntry(n));
        }
        return true;
    }

    private int compare(int n, int n2) {
        for (int i = 0; i < this.cachedSortKeys.length; ++i) {
            int n3;
            int n4 = this.cachedSortKeys[i].getColumn();
            SortOrder sortOrder = this.cachedSortKeys[i].getSortOrder();
            if (sortOrder == SortOrder.UNSORTED) {
                n3 = n - n2;
            } else {
                Object object;
                Object object2;
                if (this.useToString[n4]) {
                    object2 = this.getModelWrapper().getStringValueAt(n, n4);
                    object = this.getModelWrapper().getStringValueAt(n2, n4);
                } else {
                    object2 = this.getModelWrapper().getValueAt(n, n4);
                    object = this.getModelWrapper().getValueAt(n2, n4);
                }
                n3 = object2 == null ? (object == null ? 0 : -1) : (object == null ? 1 : this.sortComparators[i].compare(object2, object));
                if (sortOrder == SortOrder.DESCENDING) {
                    n3 *= -1;
                }
            }
            if (n3 == 0) continue;
            return n3;
        }
        return n - n2;
    }

    private boolean isTransformed() {
        return this.viewToModel != null;
    }

    private void insertInOrder(List<Row> list, Row[] rowArray) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = Arrays.binarySearch(rowArray, list.get(i));
            if (n3 < 0) {
                n3 = -1 - n3;
            }
            System.arraycopy((Object)rowArray, n, (Object)this.viewToModel, n + i, n3 - n);
            this.viewToModel[n3 + i] = list.get(i);
            n = n3;
        }
        System.arraycopy((Object)rowArray, n, (Object)this.viewToModel, n + n2, rowArray.length - n);
    }

    private boolean shouldOptimizeChange(int n, int n2) {
        if (!this.isTransformed()) {
            return false;
        }
        if (!this.sorted || n2 - n > this.viewToModel.length / 10) {
            this.sort();
            return false;
        }
        return true;
    }

    private void rowsInserted0(int n, int n2) {
        int n3;
        int[] nArray = this.getViewToModelAsInts(this.viewToModel);
        int n4 = n2 - n + 1;
        ArrayList<Row> arrayList = new ArrayList<Row>(n4);
        for (n3 = n; n3 <= n2; ++n3) {
            if (!this.include(n3)) continue;
            arrayList.add(new Row(this, n3));
        }
        for (n3 = this.modelToView.length - 1; n3 >= n; --n3) {
            int n5 = this.modelToView[n3];
            if (n5 == -1) continue;
            this.viewToModel[n5].modelIndex += n4;
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            Row[] rowArray = this.viewToModel;
            this.viewToModel = new Row[this.viewToModel.length + arrayList.size()];
            this.insertInOrder(arrayList, rowArray);
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(nArray);
    }

    private void rowsDeleted0(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = this.getViewToModelAsInts(this.viewToModel);
        int n5 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            n3 = this.modelToView[n4];
            if (n3 == -1) continue;
            ++n5;
            this.viewToModel[n3] = null;
        }
        int n6 = n2 - n + 1;
        for (n4 = this.modelToView.length - 1; n4 > n2; --n4) {
            n3 = this.modelToView[n4];
            if (n3 == -1) continue;
            this.viewToModel[n3].modelIndex -= n6;
        }
        if (n5 > 0) {
            Row[] rowArray = new Row[this.viewToModel.length - n5];
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < this.viewToModel.length; ++n4) {
                if (this.viewToModel[n4] != null) continue;
                System.arraycopy((Object)this.viewToModel, n8, (Object)rowArray, n7, n4 - n8);
                n7 += n4 - n8;
                n8 = n4 + 1;
            }
            System.arraycopy((Object)this.viewToModel, n8, (Object)rowArray, n7, this.viewToModel.length - n8);
            this.viewToModel = rowArray;
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(nArray);
    }

    private void rowsUpdated0(int n, int n2) {
        int[] nArray = this.getViewToModelAsInts(this.viewToModel);
        int n3 = n2 - n + 1;
        if (this.getRowFilter() == null) {
            Object[] objectArray = new Row[n3];
            int n4 = 0;
            int n5 = n;
            while (n5 <= n2) {
                objectArray[n4] = this.viewToModel[this.modelToView[n5]];
                ++n5;
                ++n4;
            }
            Arrays.sort(objectArray);
            Row[] rowArray = new Row[this.viewToModel.length - n3];
            n4 = 0;
            for (n5 = 0; n5 < this.viewToModel.length; ++n5) {
                int n6 = this.viewToModel[n5].modelIndex;
                if (n6 >= n && n6 <= n2) continue;
                rowArray[n4++] = this.viewToModel[n5];
            }
            this.insertInOrder(Arrays.asList(objectArray), rowArray);
            this.setModelToViewFromViewToModel(false);
        } else {
            int n7;
            ArrayList<Row> arrayList = new ArrayList<Row>(n3);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (n7 = n; n7 <= n2; ++n7) {
                if (this.modelToView[n7] == -1) {
                    if (!this.include(n7)) continue;
                    arrayList.add(new Row(this, n7));
                    ++n8;
                    continue;
                }
                if (!this.include(n7)) {
                    ++n9;
                } else {
                    arrayList.add(this.viewToModel[this.modelToView[n7]]);
                }
                this.modelToView[n7] = -2;
                ++n10;
            }
            Collections.sort(arrayList);
            Row[] rowArray = new Row[this.viewToModel.length - n10];
            int n11 = 0;
            for (n7 = 0; n7 < this.viewToModel.length; ++n7) {
                int n12 = this.viewToModel[n7].modelIndex;
                if (this.modelToView[n12] == -2) continue;
                rowArray[n11++] = this.viewToModel[n7];
            }
            if (n8 != n9) {
                this.viewToModel = new Row[this.viewToModel.length + n8 - n9];
            }
            this.insertInOrder(arrayList, rowArray);
            this.setModelToViewFromViewToModel(true);
        }
        this.fireRowSorterChanged(nArray);
    }

    private void checkColumn(int n) {
        if (n < 0 || n >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    private static class Row
    implements Comparable<Row> {
        private DefaultRowSorter sorter;
        int modelIndex;

        public Row(DefaultRowSorter defaultRowSorter, int n) {
            this.sorter = defaultRowSorter;
            this.modelIndex = n;
        }

        @Override
        public int compareTo(Row row) {
            return this.sorter.compare(this.modelIndex, row.modelIndex);
        }
    }

    private class FilterEntry
    extends RowFilter.Entry<M, I> {
        int modelIndex;

        private FilterEntry() {
        }

        @Override
        public M getModel() {
            return DefaultRowSorter.this.getModelWrapper().getModel();
        }

        @Override
        public int getValueCount() {
            return DefaultRowSorter.this.getModelWrapper().getColumnCount();
        }

        @Override
        public Object getValue(int n) {
            return DefaultRowSorter.this.getModelWrapper().getValueAt(this.modelIndex, n);
        }

        @Override
        public String getStringValue(int n) {
            return DefaultRowSorter.this.getModelWrapper().getStringValueAt(this.modelIndex, n);
        }

        @Override
        public I getIdentifier() {
            return DefaultRowSorter.this.getModelWrapper().getIdentifier(this.modelIndex);
        }
    }

    protected static abstract class ModelWrapper<M, I> {
        protected ModelWrapper() {
        }

        public abstract M getModel();

        public abstract int getColumnCount();

        public abstract int getRowCount();

        public abstract Object getValueAt(int var1, int var2);

        public String getStringValueAt(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            if (object == null) {
                return "";
            }
            String string = object.toString();
            if (string == null) {
                return "";
            }
            return string;
        }

        public abstract I getIdentifier(int var1);
    }
}

