/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class OutFileTool
extends Tool
implements IPipe {
    public static final String COMMAND_OVERWRITE = ">";
    public static final String COMMAND_APPEND = ">>";
    public static final String ARGUMENT_DESCRIPTION = "<targetFilePath>";
    public static final String HELP_DESCRIPTION = "to be used at the end of a command to redirect messages to a file (overwrite|append).";
    public static final String USAGE = ">|>>\t<targetFilePath>\tto be used at the end of a command to redirect messages to a file (overwrite|append).";

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase(COMMAND_OVERWRITE) || string.equalsIgnoreCase(COMMAND_APPEND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        String string2;
        Attributes attributes = this.readAttributes(string, stringArray);
        if (attributes == null) {
            printStream.println(USAGE);
            return;
        }
        if (attributes.filePath == null) {
            printStream.println("Missing file name for redirection");
            printStream.println(USAGE);
        }
        if ((string2 = attributes.filePath.trim()).charAt(string2.length() - 1) == File.separatorChar) {
            printStream.println("Invalid redirection path - missing filename");
            printStream.println(USAGE);
        }
        PrintStream printStream2 = null;
        try {
            printStream2 = this.getOutputFile(attributes);
            ToolsRegistry.process(attributes.nextCommand, attributes.nextCommandArgs, printStream2);
        }
        catch (IOException iOException) {
            printStream.println("Problem running command: ");
            printStream.println(iOException.getMessage());
        }
        finally {
            if (printStream2 != null) {
                printStream2.flush();
                printStream2.close();
            }
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return ">|>>";
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private PrintStream getOutputFile(Attributes attributes) throws IOException {
        String string;
        File file;
        PrintStream printStream = null;
        String string2 = attributes.filePath;
        File file2 = new File(string2);
        if (string2.indexOf(File.separator) > -1 && !(file = new File(string = string2.substring(0, string2.lastIndexOf(File.separator)))).exists() && !file.mkdirs()) {
            throw new IOException("Could not create some of the requested directories: " + string);
        }
        printStream = attributes.append && file2.exists() ? new PrintStream(new FileOutputStream(file2, true)) : new PrintStream(file2);
        return printStream;
    }

    private Attributes readAttributes(String string, String[] stringArray) {
        String string2 = null;
        String string3 = null;
        String[] stringArray2 = null;
        if (stringArray.length < 2) {
            return null;
        }
        int n = 0;
        string2 = stringArray[n++];
        string3 = stringArray[n++];
        stringArray2 = new String[stringArray.length - n];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + n];
        }
        return new Attributes(string2, string3, stringArray2, string.equalsIgnoreCase(COMMAND_APPEND));
    }

    private class Attributes {
        private String filePath = null;
        private String nextCommand = null;
        private String[] nextCommandArgs = null;
        private boolean append = false;

        public Attributes(String string, String string2, String[] stringArray, boolean bl) {
            this.filePath = string;
            this.nextCommand = string2;
            this.nextCommandArgs = stringArray;
            this.append = bl;
        }
    }
}

