/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoProcCommand
extends BaseJdmpviewCommand {
    public InfoProcCommand() {
        this.addCommand("info process", "", "displays threads, command line arguments, environment");
        this.addCommand("info proc", "", "shortened form of info process");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"info proc\" command does not take any parameters");
            return;
        }
        this.printAddressSpaceInfo();
    }

    private void printAddressSpaceInfo() {
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        ImageProcess imageProcess = imageAddressSpace.getCurrentProcess();
        if (imageProcess == null) {
            this.out.print("\t(No process in this address space)\n");
        } else {
            this.printProcessInfo();
        }
        this.out.print("\n");
    }

    private void printProcessInfo() {
        this.out.print("\n");
        this.printProcessID();
        this.out.print("\n");
        this.printThreads();
        this.out.print("\n");
        this.printCommandLine();
        if (this.ctx.getRuntime() != null) {
            this.out.print("\n");
            this.printJITOptions();
        }
        this.out.print("\n");
        this.printEnvironmentVariables();
    }

    private void printProcessID() {
        this.out.print("\t Process ID:");
        this.out.print("\n\t  ");
        try {
            this.out.print(this.ctx.getProcess().getID());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.print("\n");
    }

    private void printJITOptions() {
        try {
            if (this.ctx.getRuntime().isJITEnabled()) {
                this.out.println("\t JIT was enabled for this runtime");
                Properties properties = this.ctx.getRuntime().getJITProperties();
                StringBuilder stringBuilder = new StringBuilder("\t ");
                for (Object object : properties.keySet()) {
                    stringBuilder.append(" " + object + " " + properties.get(object) + ",");
                }
                this.out.println(stringBuilder.substring(0, stringBuilder.length() - 1));
            } else {
                this.out.println("\t JIT was disabled for this runtime");
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println("\t JIT options\n");
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println("\t JIT options not supported by this implementation of DTFJ");
        }
    }

    private void printThreads() {
        ImageProcess imageProcess = this.ctx.getProcess();
        this.out.print("\t Native thread IDs:");
        this.out.print("\n\t  ");
        int n = 10;
        Iterator iterator = imageProcess.getThreads();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.print("\n\t  <corrupt data>");
                continue;
            }
            ImageThread imageThread = (ImageThread)e;
            try {
                String string = imageThread.getID();
                if (string == null) continue;
                if (n + string.length() > 80) {
                    this.out.print("\n\t  ");
                    n = 10;
                }
                this.out.print(imageThread.getID() + " ");
                n += string.length() + 1;
            }
            catch (CorruptDataException corruptDataException) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
        }
        this.out.print("\n");
    }

    private void printCommandLine() {
        String string;
        ImageProcess imageProcess = this.ctx.getProcess();
        this.out.print("\t Command line:\n\t  ");
        try {
            string = imageProcess.getCommandLine();
            if (null == string) {
                this.out.print("<null>");
            } else {
                this.out.print(string);
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print("Could not determine command line");
        }
        this.out.println();
        this.out.println();
        try {
            string = this.ctx.getRuntime().getJavaVMInitArgs();
            if (string != null) {
                this.out.print("\t Java VM init options: ");
                Iterator iterator = string.getOptions();
                while (iterator.hasNext()) {
                    this.out.println();
                    Object e = iterator.next();
                    if (!(e instanceof JavaVMOption)) continue;
                    JavaVMOption javaVMOption = (JavaVMOption)e;
                    this.out.print("\t  " + javaVMOption.getOptionString());
                    if (javaVMOption.getExtraInfo().getAddress() == 0L) continue;
                    this.out.print(" " + Utils.toHex(javaVMOption.getExtraInfo()));
                }
            } else {
                this.out.print(Exceptions.getDataUnavailableString());
            }
        }
        catch (Exception exception) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        this.out.print("\n");
    }

    private void printEnvironmentVariables() {
        Properties properties;
        ImageProcess imageProcess = this.ctx.getProcess();
        this.out.print("\t Environment variables:");
        this.out.print("\n");
        try {
            properties = imageProcess.getEnvironment();
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print("\t  " + Exceptions.getCorruptDataExceptionString() + "\n");
            return;
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.print("\t  " + Exceptions.getDataUnavailableString() + "\n");
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.printVariableInfo(string, properties.getProperty(string));
        }
    }

    private void printVariableInfo(String string, String string2) {
        this.out.print("\t  " + string + "=" + string2 + "\n");
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays process ID, threads, command line arguments and environment variables for the current process\n\nparameters: none\n\nprints the following information about the current process\n\n  - process ID for the process and thread IDs for all its threads\n  - the command line arguments and JVM init arguments it's using\n  - its environment variables\n\nnote: to view the shared libraries used by a process, use the \"info mod\" command\n");
    }
}

