/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.types.U32;
import java.util.Iterator;

public final class VMConstantPool {
    private static Object[] _constantPool = null;
    private static U32Pointer _cpShapeDescription;
    private static J9ROMConstantPoolItemPointer _romCPStart;
    private static J9RAMConstantPoolItemPointer _ramCPStart;

    public static J9ClassPointer getClass(long l) throws CorruptDataException {
        if ((long)_constantPool.length <= l || 0L > l) {
            throw new IndexOutOfBoundsException("Index outside of constant pool bounds");
        }
        int n = (int)l;
        long l2 = ConstantPoolHelpers.J9_CP_TYPE(_cpShapeDescription, n);
        if (J9ConstantPool.J9CPTYPE_CLASS != l2) {
            throw new CorruptDataException("VMConstantPool[" + l + "] CP_TYPE is not J9CPTYPE_CLASS");
        }
        J9ClassPointer j9ClassPointer = null;
        if (null != _constantPool[n]) {
            j9ClassPointer = (J9ClassPointer)_constantPool[n];
        } else {
            J9RAMConstantPoolItemPointer j9RAMConstantPoolItemPointer = _ramCPStart.add(l);
            j9ClassPointer = J9RAMClassRefPointer.cast(j9RAMConstantPoolItemPointer).value();
            VMConstantPool._constantPool[n] = j9ClassPointer;
        }
        return j9ClassPointer;
    }

    public static J9ObjectFieldOffset getFieldOffset(long l) throws CorruptDataException {
        if ((long)_constantPool.length <= l || 0L > l) {
            throw new IndexOutOfBoundsException("Index outside of constant pool bounds");
        }
        int n = (int)l;
        long l2 = ConstantPoolHelpers.J9_CP_TYPE(_cpShapeDescription, n);
        if (J9ConstantPool.J9CPTYPE_FIELD != l2) {
            throw new CorruptDataException("VMConstantPool[" + l + "] CP_TYPE is not J9CPTYPE_FIELD");
        }
        J9ObjectFieldOffset j9ObjectFieldOffset = null;
        if (null != _constantPool[n]) {
            j9ObjectFieldOffset = (J9ObjectFieldOffset)_constantPool[n];
        } else {
            J9ROMFieldRefPointer j9ROMFieldRefPointer = J9ROMFieldRefPointer.cast(_romCPStart.add(n));
            J9ClassPointer j9ClassPointer = VMConstantPool.getClass(j9ROMFieldRefPointer.classRefCPIndex().longValue());
            J9ClassPointer j9ClassPointer2 = j9ClassPointer;
            if (j9ClassPointer2.notNull()) {
                String string = J9UTF8Helper.stringValue(j9ROMFieldRefPointer.nameAndSignature().name());
                String string2 = J9UTF8Helper.stringValue(j9ROMFieldRefPointer.nameAndSignature().signature());
                while (j9ClassPointer2.notNull() && null == j9ObjectFieldOffset) {
                    Iterator<J9ObjectFieldOffset> iterator = J9ClassHelper.getFieldOffsets(j9ClassPointer2);
                    while (iterator.hasNext()) {
                        J9ObjectFieldOffset j9ObjectFieldOffset2 = iterator.next();
                        if (!j9ObjectFieldOffset2.getName().equals(string) || !j9ObjectFieldOffset2.getSignature().equals(string2)) continue;
                        j9ObjectFieldOffset = j9ObjectFieldOffset2;
                        break;
                    }
                    j9ClassPointer2 = J9ClassHelper.superclass(j9ClassPointer2);
                }
                if (null == j9ObjectFieldOffset) {
                    throw new CorruptDataException("VMConstantPool[" + l + "] field not found: " + J9ClassHelper.getName(j9ClassPointer) + "." + string + " " + string2);
                }
                VMConstantPool._constantPool[n] = j9ObjectFieldOffset;
            }
        }
        return j9ObjectFieldOffset;
    }

    static {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9ConstantPoolPointer j9ConstantPoolPointer = J9ConstantPoolPointer.cast(j9JavaVMPointer.jclConstantPoolEA());
            J9ClassPointer j9ClassPointer = j9ConstantPoolPointer.ramClass();
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            if (j9ROMClassPointer.romConstantPoolCount().gte(new U32(Integer.MAX_VALUE))) {
                throw new CorruptDataException("ROM constantpoolcount exceeds Integer.MAX_VALUE");
            }
            int n = j9ROMClassPointer.romConstantPoolCount().intValue();
            _constantPool = new Object[n];
            _cpShapeDescription = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
            _romCPStart = J9ROMClassHelper.constantPool(j9ROMClassPointer);
            _ramCPStart = J9RAMConstantPoolItemPointer.cast(j9ConstantPoolPointer);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Problem reading the VMConstantPool", corruptDataException, false);
        }
    }
}

