/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.Utilities;

final class SSLExtensions {
    private final SSLHandshake.HandshakeMessage handshakeMessage;
    private Map<SSLExtension, byte[]> extMap = new LinkedHashMap<SSLExtension, byte[]>();
    private int encodedLength;
    private final Map<Integer, byte[]> logMap = SSLLogger.isOn ? new LinkedHashMap() : null;

    SSLExtensions(SSLHandshake.HandshakeMessage handshakeMessage) {
        this.handshakeMessage = handshakeMessage;
        this.encodedLength = 2;
    }

    SSLExtensions(SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer, SSLExtension[] sSLExtensionArray) throws IOException {
        int n;
        int n2;
        this.handshakeMessage = handshakeMessage;
        this.encodedLength = n2 + 2;
        for (n2 = Record.getInt16(byteBuffer); n2 > 0; n2 -= n + 4) {
            int n3 = Record.getInt16(byteBuffer);
            n = Record.getInt16(byteBuffer);
            if (n > byteBuffer.remaining()) {
                throw handshakeMessage.handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Error parsing extension (" + n3 + "): no sufficient data");
            }
            boolean bl = true;
            SSLHandshake sSLHandshake = handshakeMessage.handshakeType();
            if (SSLExtension.isConsumable(n3) && SSLExtension.valueOf(sSLHandshake, n3) == null) {
                if (n3 == SSLExtension.CH_SUPPORTED_GROUPS.id && sSLHandshake == SSLHandshake.SERVER_HELLO) {
                    bl = false;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Received buggy supported_groups extension in the ServerHello handshake message", new Object[0]);
                    }
                } else {
                    if (sSLHandshake == SSLHandshake.SERVER_HELLO) {
                        throw handshakeMessage.handshakeContext.conContext.fatal(Alert.UNSUPPORTED_EXTENSION, "extension (" + n3 + ") should not be presented in " + sSLHandshake.name);
                    }
                    bl = false;
                }
            }
            if (bl) {
                bl = false;
                for (SSLExtension sSLExtension : sSLExtensionArray) {
                    if (sSLExtension.id != n3 || sSLExtension.onLoadConsumer == null) continue;
                    if (sSLExtension.handshakeType != sSLHandshake) {
                        throw handshakeMessage.handshakeContext.conContext.fatal(Alert.UNSUPPORTED_EXTENSION, "extension (" + n3 + ") should not be presented in " + sSLHandshake.name);
                    }
                    byte[] byArray = new byte[n];
                    byteBuffer.get(byArray);
                    this.extMap.put(sSLExtension, byArray);
                    if (this.logMap != null) {
                        this.logMap.put(n3, byArray);
                    }
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            if (this.logMap != null) {
                byte[] n4 = new byte[n];
                byteBuffer.get(n4);
                this.logMap.put(n3, n4);
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore unknown or unsupported extension", SSLExtensions.toString(n3, n4));
                continue;
            }
            int n4 = byteBuffer.position() + n;
            byteBuffer.position(n4);
        }
    }

    byte[] get(SSLExtension sSLExtension) {
        return this.extMap.get(sSLExtension);
    }

    void consumeOnLoad(HandshakeContext handshakeContext, SSLExtension[] sSLExtensionArray) throws IOException {
        for (SSLExtension sSLExtension : sSLExtensionArray) {
            if (handshakeContext.negotiatedProtocol != null && !sSLExtension.isAvailable(handshakeContext.negotiatedProtocol)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore unsupported extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            if (!this.extMap.containsKey(sSLExtension)) {
                if (sSLExtension.onLoadAbsence != null) {
                    sSLExtension.absentOnLoad(handshakeContext, this.handshakeMessage);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore unavailable extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            if (sSLExtension.onLoadConsumer == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Ignore unsupported extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.extMap.get(sSLExtension));
            sSLExtension.consumeOnLoad(handshakeContext, this.handshakeMessage, byteBuffer);
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.fine("Consumed extension: " + sSLExtension.name, new Object[0]);
        }
    }

    void consumeOnTrade(HandshakeContext handshakeContext, SSLExtension[] sSLExtensionArray) throws IOException {
        for (SSLExtension sSLExtension : sSLExtensionArray) {
            if (!this.extMap.containsKey(sSLExtension)) {
                if (sSLExtension.onTradeAbsence != null) {
                    sSLExtension.absentOnTrade(handshakeContext, this.handshakeMessage);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore unavailable extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            if (sSLExtension.onTradeConsumer == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Ignore impact of unsupported extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            sSLExtension.consumeOnTrade(handshakeContext, this.handshakeMessage);
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.fine("Populated with extension: " + sSLExtension.name, new Object[0]);
        }
    }

    void produce(HandshakeContext handshakeContext, SSLExtension[] sSLExtensionArray) throws IOException {
        for (SSLExtension sSLExtension : sSLExtensionArray) {
            if (this.extMap.containsKey(sSLExtension)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore, duplicated extension: " + sSLExtension.name, new Object[0]);
                continue;
            }
            if (sSLExtension.networkProducer == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Ignore, no extension producer defined: " + sSLExtension.name, new Object[0]);
                continue;
            }
            byte[] byArray = sSLExtension.produce(handshakeContext, this.handshakeMessage);
            if (byArray != null) {
                this.extMap.put(sSLExtension, byArray);
                this.encodedLength += byArray.length + 4;
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.fine("Ignore, context unavailable extension: " + sSLExtension.name, new Object[0]);
        }
    }

    void reproduce(HandshakeContext handshakeContext, SSLExtension[] sSLExtensionArray) throws IOException {
        for (SSLExtension sSLExtension : sSLExtensionArray) {
            if (sSLExtension.networkProducer == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.warning("Ignore, no extension producer defined: " + sSLExtension.name, new Object[0]);
                continue;
            }
            byte[] byArray = sSLExtension.produce(handshakeContext, this.handshakeMessage);
            if (byArray != null) {
                if (this.extMap.containsKey(sSLExtension)) {
                    byte[] byArray2 = this.extMap.replace(sSLExtension, byArray);
                    if (byArray2 != null) {
                        this.encodedLength -= byArray2.length + 4;
                    }
                    this.encodedLength += byArray.length + 4;
                    continue;
                }
                this.extMap.put(sSLExtension, byArray);
                this.encodedLength += byArray.length + 4;
                continue;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
            SSLLogger.fine("Ignore, context unavailable extension: " + sSLExtension.name, new Object[0]);
        }
    }

    int length() {
        if (this.extMap.isEmpty()) {
            return 0;
        }
        return this.encodedLength;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.length();
        if (n == 0) {
            return;
        }
        handshakeOutStream.putInt16(n - 2);
        for (SSLExtension sSLExtension : SSLExtension.values()) {
            byte[] byArray = this.extMap.get(sSLExtension);
            if (byArray == null) continue;
            handshakeOutStream.putInt16(sSLExtension.id);
            handshakeOutStream.putBytes16(byArray);
        }
    }

    public String toString() {
        if (this.extMap.isEmpty() && (this.logMap == null || this.logMap.isEmpty())) {
            return "<no extension>";
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        if (this.logMap != null && !this.logMap.isEmpty()) {
            for (Map.Entry<Integer, byte[]> entry : this.logMap.entrySet()) {
                SSLExtension sSLExtension = SSLExtension.valueOf(this.handshakeMessage.handshakeType(), entry.getKey());
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",\n");
                }
                if (sSLExtension != null) {
                    stringBuilder.append(sSLExtension.toString(ByteBuffer.wrap(entry.getValue())));
                    continue;
                }
                stringBuilder.append(SSLExtensions.toString(entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
        for (Map.Entry<SSLExtension, byte[]> entry : this.extMap.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(entry.getKey().toString(ByteBuffer.wrap(entry.getValue())));
        }
        return stringBuilder.toString();
    }

    private static String toString(int n, byte[] byArray) {
        String string = SSLExtension.nameOf(n);
        MessageFormat messageFormat = new MessageFormat("\"{0} ({1})\": '{'\n{2}\n'}'", Locale.ENGLISH);
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string2 = hexDumpEncoder.encodeBuffer(byArray);
        Object[] objectArray = new Object[]{string, n, Utilities.indent(string2)};
        return messageFormat.format(objectArray);
    }
}

