/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandParser {
    private String originalLine;
    private List<String> allTokens = new ArrayList<String>();
    private String command;
    private List<String> arguments = new ArrayList<String>();
    private String redirectionFilename;
    private boolean isAppendToFile;
    private boolean isRedirectedToFile;

    public CommandParser(String string) throws ParseException {
        this.originalLine = string;
        this.tokenise(string);
        this.parse(this.allTokens);
    }

    public CommandParser(String string, String[] stringArray) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        this.originalLine = string;
        for (String string2 : stringArray) {
            this.originalLine = this.originalLine + " " + string2;
        }
        this.parse(arrayList);
    }

    public String toString() {
        return this.originalLine;
    }

    public String getOriginalLine() {
        return this.originalLine;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isRedirectedToFile() {
        return this.isRedirectedToFile || this.isAppendToFile;
    }

    public String[] getArguments() {
        return this.arguments.toArray(new String[0]);
    }

    public PrintStream getOutputFile() throws IOException {
        String string;
        File file;
        if (!this.isRedirectedToFile && !this.isAppendToFile) {
            throw new IllegalStateException("Attempt to create output file for a command which does not contain file redirection.");
        }
        PrintStream printStream = null;
        File file2 = new File(this.redirectionFilename);
        if (this.redirectionFilename.indexOf(File.separator) > -1 && !(file = new File(string = this.redirectionFilename.substring(0, this.redirectionFilename.lastIndexOf(File.separator)))).exists() && !file.mkdirs()) {
            throw new IOException("Could not create some of the requested directories: " + string);
        }
        printStream = this.isAppendToFile && file2.exists() ? new PrintStream(new FileOutputStream(file2, true)) : new PrintStream(file2);
        return printStream;
    }

    private void tokenise(String string) throws ParseException {
        char[] cArray = string.toCharArray();
        int n = 0;
        TokenisingState tokenisingState = new GenericTokenState(this);
        do {
            tokenisingState = tokenisingState.process(Character.valueOf(cArray[n++]));
            if (n != cArray.length) continue;
            tokenisingState.endOfInput();
        } while (n < cArray.length);
    }

    private void parse(List<String> list) throws ParseException {
        int n;
        if (list.size() == 0) {
            return;
        }
        this.command = list.get(0);
        for (n = 1; n < list.size() && !list.get(n).equals(">") && !list.get(n).equals(">>"); ++n) {
            this.arguments.add(list.get(n));
        }
        if (n < list.size()) {
            if (list.get(n).equals(">")) {
                this.isAppendToFile = false;
                this.isRedirectedToFile = true;
            } else {
                this.isAppendToFile = true;
                this.isRedirectedToFile = false;
            }
            if (n + 1 < list.size()) {
                String string = list.get(n + 1).trim();
                if (string.charAt(string.length() - 1) == File.separatorChar) {
                    throw new ParseException("Invalid redirection path - missing filename", n);
                }
                this.redirectionFilename = list.get(n + 1);
            } else {
                throw new ParseException("Missing file name for redirection", n);
            }
        }
    }

    class FilenameState
    extends TokenisingState {
        private Character quoteType;
        private boolean alreadyStarted;
        private boolean alreadyFinished;

        protected FilenameState(CommandParser commandParser2) {
            super(commandParser2);
            this.quoteType = null;
            this.alreadyStarted = false;
            this.alreadyFinished = false;
        }

        @Override
        protected TokenisingState process(Character c) throws ParseException {
            if (this.alreadyFinished) {
                throw new ParseException("Only one file name is permitted", 0);
            }
            if (!this.alreadyStarted) {
                if (c.equals(Character.valueOf('\"')) || c.equals(Character.valueOf('\''))) {
                    this.quoteType = c;
                } else {
                    this.currentToken.append(c);
                }
                this.alreadyStarted = true;
            } else if (c.equals(this.quoteType)) {
                this.storeToken();
                this.alreadyFinished = true;
            } else if (Character.isWhitespace(c.charValue())) {
                if (this.quoteType != null) {
                    this.currentToken.append(c);
                } else {
                    this.storeToken();
                    this.alreadyFinished = true;
                }
            } else {
                this.currentToken.append(c);
            }
            return this;
        }

        @Override
        protected void endOfInput() throws ParseException {
            if (!this.alreadyStarted) {
                throw new ParseException("Missing file name", 0);
            }
            if (this.alreadyStarted && !this.alreadyFinished && this.quoteType != null) {
                throw new ParseException("Unmatched " + this.quoteType + " in file name", 0);
            }
            this.storeToken();
        }
    }

    class QuotedStringState
    extends TokenisingState {
        private Character quoteType;
        private boolean escape;

        protected QuotedStringState(CommandParser commandParser2, Character c) {
            super(commandParser2);
            this.escape = false;
            this.quoteType = c;
        }

        @Override
        protected TokenisingState process(Character c) throws ParseException {
            switch (c.charValue()) {
                case '\\': {
                    if (this.escape) {
                        this.currentToken.append(c);
                        this.escape = false;
                    } else {
                        this.escape = true;
                    }
                    return this;
                }
                case '\"': 
                case '\'': {
                    if (c != this.quoteType) {
                        this.currentToken.append(c);
                        return this;
                    }
                    if (this.escape) {
                        this.currentToken.append(c);
                        this.escape = false;
                        return this;
                    }
                    this.storeToken();
                    return new GenericTokenState(this.context);
                }
            }
            if (this.escape) {
                this.currentToken.append("\\");
                this.escape = false;
            }
            this.currentToken.append(c);
            return this;
        }

        @Override
        protected void endOfInput() throws ParseException {
            if (this.currentToken.length() > 0) {
                throw new ParseException("Unmatched " + this.quoteType, 0);
            }
        }
    }

    class GenericTokenState
    extends TokenisingState {
        protected GenericTokenState(CommandParser commandParser2) {
            super(commandParser2);
        }

        @Override
        protected TokenisingState process(Character c) throws ParseException {
            if (Character.isWhitespace(c.charValue())) {
                if (this.currentToken.toString().equals(">") || this.currentToken.toString().equals(">>")) {
                    this.storeToken();
                    return new FilenameState(this.context);
                }
                this.storeToken();
                return this;
            }
            switch (c.charValue()) {
                case '\"': 
                case '\'': {
                    if (this.currentToken.length() > 0) {
                        throw new ParseException("'" + c + "' invalid inside a string", 0);
                    }
                    return new QuotedStringState(this.context, c);
                }
            }
            this.currentToken.append(c);
            return this;
        }

        @Override
        protected void endOfInput() {
            this.storeToken();
        }
    }

    abstract class TokenisingState {
        protected CommandParser context;
        protected StringBuilder currentToken = new StringBuilder();

        protected abstract TokenisingState process(Character var1) throws ParseException;

        protected TokenisingState(CommandParser commandParser2) {
            this.context = commandParser2;
        }

        protected void storeToken() {
            if (this.currentToken.length() > 0) {
                this.context.allTokens.add(this.currentToken.toString());
                this.currentToken = new StringBuilder();
            }
        }

        protected abstract void endOfInput() throws ParseException;
    }
}

