/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public final class ObjectModel {
    protected static final GCObjectModel gcObjectModel;

    private ObjectModel() {
    }

    public static UDATA adjustSizeInBytes(UDATA uDATA) {
        return gcObjectModel.adjustSizeInBytes(uDATA);
    }

    public static long getObjectAlignmentInBytes() {
        return gcObjectModel.getObjectAlignmentInBytes();
    }

    public static UDATA getClassShape(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getClassShape(j9ObjectPointer);
    }

    public static UDATA getClassShape(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return gcObjectModel.getClassShape(j9ClassPointer);
    }

    public static boolean isIndexable(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isIndexable(j9ObjectPointer);
    }

    public static boolean isIndexable(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return gcObjectModel.isIndexable(j9ClassPointer);
    }

    public static boolean isHoleObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isHoleObject(j9ObjectPointer);
    }

    public static boolean isSingleSlotHoleObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isSingleSlotHoleObject(j9ObjectPointer);
    }

    public static UDATA getSizeInBytesMultiSlotHoleObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesMultiSlotHoleObject(j9ObjectPointer);
    }

    public static UDATA getSizeInBytesSingleSlotHoleObject(J9ObjectPointer j9ObjectPointer) {
        return gcObjectModel.getSizeInBytesSingleSlotHoleObject(j9ObjectPointer);
    }

    public static UDATA getSizeInBytesHoleObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesHoleObject(j9ObjectPointer);
    }

    public static boolean isDarkMatterObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isDarkMatterObject(j9ObjectPointer);
    }

    public static UDATA getSizeInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesWithHeader(j9ObjectPointer);
    }

    public static UDATA getTotalFootprintInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getTotalFootprintInBytesWithHeader(j9ObjectPointer);
    }

    public static UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getConsumedSizeInBytesWithHeader(j9ObjectPointer);
    }

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getSizeInBytesWithHeader(j9ObjectPointer));
    }

    public UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getConsumedSizeInBytesWithHeader(j9ObjectPointer));
    }

    public static U32 getAge(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getAge(j9ObjectPointer);
    }

    public static boolean isRemembered(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isRemembered(j9ObjectPointer);
    }

    public static UDATA getRememberedBits(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getRememberedBits(j9ObjectPointer);
    }

    public static boolean isOld(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.isOld(j9ObjectPointer);
    }

    public static UDATA getSizeInElements(J9ObjectPointer j9ObjectPointer) throws IllegalArgumentException, CorruptDataException {
        return gcObjectModel.getSizeInElements(j9ObjectPointer);
    }

    public static long getScanType(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getScanType(j9ObjectPointer);
    }

    public static boolean hasBeenHashed(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.hasBeenHashed(j9ObjectPointer);
    }

    public static boolean hasBeenMoved(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.hasBeenMoved(j9ObjectPointer);
    }

    public static I32 getObjectHashCode(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getObjectHashCode(j9ObjectPointer);
    }

    public static UDATA getHashcodeOffset(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getHashcodeOffset(j9ObjectPointer);
    }

    public static UDATA getDataSizeInBytes(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return gcObjectModel.getDataSizeInBytes(j9IndexableObjectPointer);
    }

    public static UDATA getHeaderSize(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return gcObjectModel.getHeaderSize(j9ObjectPointer);
    }

    public static VoidPointer getElementAddress(J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        return gcObjectModel.getElementAddress(j9IndexableObjectPointer, n, n2);
    }

    public static GCHeapRegionDescriptor findRegionForPointer(J9JavaVMPointer j9JavaVMPointer, GCHeapRegionManager gCHeapRegionManager, AbstractPointer abstractPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor) {
        GCHeapRegionDescriptor gCHeapRegionDescriptor2 = null;
        if (gCHeapRegionDescriptor != null && gCHeapRegionDescriptor.isAddressInRegion(abstractPointer)) {
            return gCHeapRegionDescriptor;
        }
        gCHeapRegionDescriptor2 = ObjectModel.regionForAddress(j9JavaVMPointer, gCHeapRegionManager, abstractPointer);
        if (null != gCHeapRegionDescriptor2) {
            return gCHeapRegionDescriptor2;
        }
        try {
            GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
            while (gCHeapRegionIterator.hasNext()) {
                gCHeapRegionDescriptor2 = GCHeapRegionDescriptor.fromHeapRegionDescriptor(gCHeapRegionIterator.next());
                if (!ObjectModel.isPointerInRegion(abstractPointer, gCHeapRegionDescriptor2)) continue;
                return gCHeapRegionDescriptor2;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        return null;
    }

    public static GCHeapRegionDescriptor regionForAddress(J9JavaVMPointer j9JavaVMPointer, GCHeapRegionManager gCHeapRegionManager, AbstractPointer abstractPointer) {
        try {
            if (null == gCHeapRegionManager) {
                MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = MM_GCExtensionsPointer.cast(j9JavaVMPointer.gcExtensions()).heapRegionManager();
                gCHeapRegionManager = GCHeapRegionManager.fromHeapRegionManager(mM_HeapRegionManagerPointer);
            }
            return gCHeapRegionManager.regionDescriptorForAddress(abstractPointer);
        }
        catch (CorruptDataException corruptDataException) {
            return null;
        }
    }

    public static boolean isPointerInRegion(AbstractPointer abstractPointer, GCHeapRegionDescriptor gCHeapRegionDescriptor) {
        return abstractPointer.gte(gCHeapRegionDescriptor.getLowAddress()) && abstractPointer.lt(gCHeapRegionDescriptor.getHighAddress());
    }

    public static boolean isPointerInHeap(J9JavaVMPointer j9JavaVMPointer, AbstractPointer abstractPointer) {
        return ObjectModel.findRegionForPointer(j9JavaVMPointer, null, abstractPointer, null) != null;
    }

    public static boolean isInlineContiguousArraylet(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return gcObjectModel.isInlineContiguousArraylet(j9IndexableObjectPointer);
    }

    public static boolean hasCorrectDataAddrPointer(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return gcObjectModel.hasCorrectDataAddrPointer(j9IndexableObjectPointer);
    }

    static {
        GCObjectModel gCObjectModel = null;
        try {
            gCObjectModel = GCObjectModel.from();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error initializing the object model", corruptDataException, true);
            gCObjectModel = null;
        }
        gcObjectModel = gCObjectModel;
    }
}

