/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.MM_StringTable;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public class StringTable {
    protected MM_StringTablePointer _stringTable;
    protected long _tableCount;
    StringHashFunction<PointerPointer> _hashFn;

    protected StringTable(MM_StringTablePointer mM_StringTablePointer) throws CorruptDataException {
        this._stringTable = mM_StringTablePointer;
        this._tableCount = mM_StringTablePointer._tableCount().longValue();
        this._hashFn = new StringHashFunction();
    }

    public static StringTable from() throws CorruptDataException {
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        return new StringTable(mM_GCExtensionsPointer.stringTable());
    }

    public SlotIterator<J9ObjectPointer> iterator() {
        return new SlotIterator<J9ObjectPointer>(){
            private SlotIterator<PointerPointer> hashTableIterator = null;
            private long currentIndex = 0L;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.hashTableIterator != null) {
                        if (this.hashTableIterator.hasNext()) {
                            return true;
                        }
                        ++this.currentIndex;
                    }
                    if (this.currentIndex >= StringTable.this._tableCount) {
                        this.hashTableIterator = null;
                        return false;
                    }
                    try {
                        J9HashTablePointer j9HashTablePointer = J9HashTablePointer.cast(StringTable.this._stringTable._table().at(this.currentIndex));
                        HashTable<PointerPointer> hashTable = HashTable.fromJ9HashTable(j9HashTablePointer, false, PointerPointer.class, StringTable.this._hashFn, new StringComparatorFunction());
                        this.hashTableIterator = hashTable.iterator();
                        continue;
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    PointerPointer pointerPointer = (PointerPointer)this.hashTableIterator.next();
                    return J9ObjectPointer.cast(pointerPointer);
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    return VoidPointer.cast(this.hashTableIterator.nextAddress());
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    public SlotIterator<J9ObjectPointer> cacheIterator() {
        return new SlotIterator<J9ObjectPointer>(){
            private UDATA cacheTableIndex = new UDATA(0L);
            private UDATA cacheSize;
            private PointerPointer cache;
            {
                try {
                    this.cacheSize = StringTable.this.getCacheSize();
                    this.cache = StringTable.this._stringTable._cacheEA();
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                    this.cacheSize = new UDATA(0L);
                }
            }

            @Override
            public boolean hasNext() {
                while (this.cacheTableIndex.lt(this.cacheSize)) {
                    try {
                        if (this.cache.at(this.cacheTableIndex).notNull()) {
                            return true;
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                    }
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                }
                return false;
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    try {
                        J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(this.cache.at(this.cacheTableIndex));
                        this.cacheTableIndex = this.cacheTableIndex.add(1L);
                        return j9ObjectPointer;
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    VoidPointer voidPointer = VoidPointer.cast(this.cache.add(this.cacheTableIndex));
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                    return voidPointer;
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    private UDATA getTableIndex(UDATA uDATA) throws CorruptDataException {
        return uDATA.mod(this._stringTable._tableCount());
    }

    private J9HashTablePointer getTable(UDATA uDATA) throws CorruptDataException {
        J9HashTablePointer j9HashTablePointer = J9HashTablePointer.cast(this._stringTable._table().at(uDATA));
        return j9HashTablePointer;
    }

    public J9ObjectPointer search(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = this._hashFn.hash(PointerPointer.cast(j9ObjectPointer));
        UDATA uDATA2 = this.getTableIndex(uDATA);
        J9HashTablePointer j9HashTablePointer = this.getTable(uDATA2);
        HashTable<J9ObjectPointer> hashTable = HashTable.fromJ9HashTable(j9HashTablePointer, false, J9ObjectPointer.class, new StringHashFunction(), new StringComparatorFunction());
        J9ObjectPointer j9ObjectPointer2 = hashTable.find(j9ObjectPointer);
        return j9ObjectPointer2;
    }

    protected UDATA getCacheSize() {
        return new UDATA(MM_StringTable.cacheSize);
    }

    public static class StringHashFunction<StructType extends AbstractPointer>
    implements HashTable.HashFunction<StructType> {
        @Override
        public UDATA hash(StructType StructType) {
            try {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(StructType);
                String string = J9ObjectHelper.stringValue(j9ObjectPointer);
                U32 u32 = new U32(string.hashCode());
                return new UDATA(u32);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", corruptDataException, false);
                return new UDATA(0L);
            }
        }
    }

    public static class StringComparatorFunction<StructType extends AbstractPointer>
    implements HashTable.HashComparatorFunction<StructType> {
        @Override
        public int compare(StructType StructType, StructType StructType2) throws CorruptDataException {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(StructType);
            J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(StructType2);
            String string = J9ObjectHelper.stringValue(j9ObjectPointer);
            String string2 = J9ObjectHelper.stringValue(j9ObjectPointer2);
            return string.compareTo(string2);
        }
    }

    public static class StringEqualFunction<StructType extends AbstractPointer>
    implements HashTable.HashEqualFunction<StructType> {
        @Override
        public boolean equal(StructType StructType, StructType StructType2) {
            try {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(StructType);
                J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(StructType2);
                String string = J9ObjectHelper.stringValue(j9ObjectPointer);
                String string2 = J9ObjectHelper.stringValue(j9ObjectPointer2);
                return string.equals(string2);
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error checking equality", corruptDataException, true);
                return false;
            }
        }
    }
}

