/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class VoidPointer
extends Pointer {
    public static final VoidPointer NULL = new VoidPointer(0L);

    protected VoidPointer(long l) {
        super(l);
    }

    public static VoidPointer cast(AbstractPointer abstractPointer) {
        return VoidPointer.cast(abstractPointer.getAddress());
    }

    public static VoidPointer cast(UDATA uDATA) {
        return VoidPointer.cast(uDATA.longValue());
    }

    public static VoidPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new VoidPointer(l);
    }

    @Override
    public Scalar at(long l) throws CorruptDataException {
        throw new NullPointerDereference("Can not dereference a void *");
    }

    @Override
    public Scalar at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public VoidPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public VoidPointer untag(long l) {
        return new VoidPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public VoidPointer add(long l) {
        return new VoidPointer(this.address + SIZEOF * l);
    }

    @Override
    public VoidPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public VoidPointer addOffset(long l) {
        return new VoidPointer(this.address + l);
    }

    @Override
    public VoidPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public AbstractPointer sub(long l) {
        throw new UnsupportedOperationException("Pointer math not supported on void pointers");
    }

    @Override
    public AbstractPointer sub(Scalar scalar) {
        throw new UnsupportedOperationException("Pointer math not supported on void pointers");
    }

    @Override
    public VoidPointer subOffset(long l) {
        return new VoidPointer(this.address - l);
    }

    @Override
    public VoidPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        throw new UnsupportedOperationException();
    }
}

