/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.CommonData;

public class ExternalDecimal {
    private static byte EXTERNAL_DECIMAL_SPACE_SYMBOL = (byte)64;
    private static int EXTERNAL_DECIMAL_INVALID_DIGIT = 2;
    private static int EXTERNAL_DECIMAL_INVALID_SIGN = 1;

    private ExternalDecimal() {
    }

    public static int checkExternalDecimal(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Precision must be greater than 0.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Offset must be non-negative integer.");
        }
        if (n3 < 1 || n3 > 4) {
            throw new IllegalArgumentException("Invalid decimalType.");
        }
        int n5 = n + CommonData.getExternalByteCounts(n2, n3);
        if (n5 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. checkExternalDecimal is trying to access byteArray[" + n + "] to byteArray[" + (n5 - 1) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        return ExternalDecimal.checkExternalDecimal_(byArray, n, n2, n3, n4);
    }

    private static int checkExternalDecimal_(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 == 1 && (n2 == n4 || n4 < 0)) {
            return 3;
        }
        int n7 = n;
        int n8 = n7 + CommonData.getExternalByteCounts(n2, n3) - 1;
        boolean bl = false;
        switch (n3) {
            case 1: {
                bl = true;
                n6 = byArray[n8];
                --n8;
                n7 += n4;
                break;
            }
            case 3: {
                n6 = byArray[n8];
                --n8;
                break;
            }
            case 2: {
                bl = true;
                n6 = byArray[n7];
                ++n7;
                break;
            }
            case 4: {
                n6 = byArray[n7];
                ++n7;
                break;
            }
            default: {
                n6 = -97;
            }
        }
        int n9 = 0;
        if (n3 == 1 && n4 > 0) {
            for (n5 = n; n5 < n7; ++n5) {
                if (byArray[n5] == EXTERNAL_DECIMAL_SPACE_SYMBOL || (byArray[n5] & 0xFFFFFFF0 & 0xF0) == 240 && (byArray[n5] & 0xF) <= 9) continue;
                n9 = EXTERNAL_DECIMAL_INVALID_DIGIT;
            }
        }
        for (n5 = n7; n5 <= n8 && n9 < EXTERNAL_DECIMAL_INVALID_DIGIT; ++n5) {
            if (byArray[n5] != EXTERNAL_DECIMAL_SPACE_SYMBOL && (byArray[n5] & 0xFFFFFFF0 & 0xF0) == 240 && (byArray[n5] & 0xF) <= 9) continue;
            n9 = EXTERNAL_DECIMAL_INVALID_DIGIT;
        }
        if (bl) {
            if ((n6 & 0xF) > 9) {
                n9 = EXTERNAL_DECIMAL_INVALID_DIGIT;
            }
            if ((n6 & 0xFFFFFFF0 & 0xF0) < 160) {
                n9 |= EXTERNAL_DECIMAL_INVALID_SIGN;
            }
        } else if (!bl && n6 != 96 && n6 != 78) {
            n9 |= EXTERNAL_DECIMAL_INVALID_SIGN;
        }
        return n9;
    }
}

