/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.environment;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.environment.IEnvironmentTypes;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EnvironmentSectionParser
extends SectionParser
implements IEnvironmentTypes {
    private IImageProcessBuilder fImageProcessBuilder;
    private IJavaRuntimeBuilder fRuntimeBuilder;

    public EnvironmentSectionParser() {
        super("ENVINFO");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.parseVersion();
        this.parseUserArgs();
        this.parseEnvironmentVars();
        this.parseJVMMI();
    }

    private void parseVersion() throws ParserException {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        IParserToken iParserToken;
        int n2;
        Object object;
        Object object2;
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineOptional("1CIJAVAVERSION");
        if (iAttributeValueMap != null) {
            int n3 = iAttributeValueMap.getIntValue("pointer_size");
            if (n3 != -1) {
                this.fImageProcessBuilder.setPointerSize(n3);
            }
            object2 = iAttributeValueMap.getTokenValue("environment_arg_string");
            object = "j2re 1.";
            if (((String)object2).toLowerCase().startsWith((String)object) && ((String)object2).length() > ((String)object).length() + 1) {
                String string5 = ((String)object2).substring(((String)object).length(), ((String)object2).indexOf(46, ((String)object).length() + 1));
                try {
                    n2 = Integer.parseInt(string5);
                    if (n2 <= 4) {
                        throw new ParserException("Javacore files earlier than 1.5.0 are not supported");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.handleError("Error determining Java version", numberFormatException);
                }
            }
            if ((iAttributeValueMap = this.processTagLineOptional("1CIVMVERSION")) != null) {
                object2 = this.buildVersionString((String)object2, iAttributeValueMap);
            }
            if ((iAttributeValueMap = this.processTagLineOptional("1CIJITVERSION")) != null) {
                object2 = this.buildVersionString((String)object2, iAttributeValueMap);
            }
            if ((iAttributeValueMap = this.processTagLineOptional("1CIGCVERSION")) != null) {
                object2 = this.buildVersionString((String)object2, iAttributeValueMap);
            }
            if (object2 != null) {
                this.fRuntimeBuilder.setJavaVersion((String)object2);
            }
        } else {
            this.processTagLineOptional("1CIVMVERSION");
            this.processTagLineOptional("1CIJITVERSION");
            this.processTagLineOptional("1CIGCVERSION");
        }
        iAttributeValueMap = this.processTagLineOptional("1CIJITMODES");
        if (iAttributeValueMap != null && (iParserToken = iAttributeValueMap.getToken("environment_jit_mode")) != null) {
            object2 = iParserToken.getValue().trim();
            if (((String)object2).toLowerCase().startsWith("unavailable")) {
                this.fRuntimeBuilder.setJITEnabled(false);
            } else {
                this.fRuntimeBuilder.setJITEnabled(true);
                object = ((String)object2).split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string6 = object[i].trim();
                    n = string6.indexOf(32);
                    if (n == -1) {
                        this.fRuntimeBuilder.addJITProperty((String)object[i], "<default value>");
                        continue;
                    }
                    String string7 = string6.substring(0, n);
                    string4 = string6.substring(n + 1);
                    this.fRuntimeBuilder.addJITProperty(string7, string4);
                }
            }
        }
        this.processTagLineOptional("1CIRUNNINGAS");
        iAttributeValueMap = this.processTagLineOptional("1CISTARTTIME");
        if (iAttributeValueMap != null && (string3 = iAttributeValueMap.getTokenValue("environment_start_time")) != null && (object = ((SimpleDateFormat)(object2 = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss:SSS"))).parse(string3, new ParsePosition(0))) != null) {
            this.fRuntimeBuilder.setStartTime(((Date)object).getTime());
        }
        if ((iAttributeValueMap = this.processTagLineOptional("1CISTARTNANO")) != null && (string2 = iAttributeValueMap.getTokenValue("environment_start_nano")) != null) {
            this.fRuntimeBuilder.setStartTimeNanos(Long.parseLong(string2));
        }
        if ((iAttributeValueMap = this.processTagLineOptional("1CIPROCESSID")) != null && (string = iAttributeValueMap.getTokenValue("environment_pid_string")) != null) {
            this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder().setID(string);
        }
        String string8 = null;
        iAttributeValueMap = this.processTagLineOptional("1CICMDLINE");
        if (iAttributeValueMap != null) {
            string8 = iAttributeValueMap.getTokenValue("environment_cmd_line");
            if ("[not available]".equals(string8)) {
                string8 = null;
            } else {
                this.fImageProcessBuilder.setCommandLine(string8);
            }
        }
        object2 = null;
        iAttributeValueMap = this.processTagLineOptional("1CIJAVAHOMEDIR");
        if (iAttributeValueMap != null) {
            object2 = iAttributeValueMap.getTokenValue("environment_arg_string");
        }
        object = null;
        iAttributeValueMap = this.processTagLineOptional("1CIJAVADLLDIR");
        if (iAttributeValueMap != null) {
            object = iAttributeValueMap.getTokenValue("environment_arg_string");
        }
        if (string8 != null) {
            if (object != null) {
                int n4 = string8.indexOf(47) + 1;
                if (n4 == 0) {
                    n4 = string8.length();
                }
                if ((n2 = string8.indexOf(92) + 1) == 0) {
                    n2 = string8.length();
                }
                n = Math.min(n4, n2);
                for (int i = string8.length(); i > n; --i) {
                    string4 = string8.substring(0, i);
                    int n5 = ((String)object).indexOf(string4);
                    if (n5 < 0) continue;
                    string8 = ((String)object).substring(0, n5) + string8;
                    break;
                }
            }
            int n6 = 0;
            if (object != null) {
                for (n6 = ((String)object).length(); n6 >= 0 && !string8.startsWith(((String)object).substring(0, n6)); --n6) {
                }
            }
            String string9 = (n2 = string8.indexOf(32, n6)) >= 0 ? string8.substring(0, n2) : string8;
            ImageModule imageModule = this.fImageProcessBuilder.addLibrary(string9);
            this.fImageProcessBuilder.setExecutable(imageModule);
        }
        this.processTagLineOptional("1CISYSCP");
    }

    private String buildVersionString(String string, IAttributeValueMap iAttributeValueMap) {
        String string2 = iAttributeValueMap.getTokenValue("environment_arg_string");
        if (string2 != null) {
            string = string != null ? string + "\n" + string2 : string2;
        }
        return string;
    }

    private void parseUserArgs() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineRequired("1CIUSERARGS");
        if (iAttributeValueMap != null) {
            boolean bl = false;
            while ((iAttributeValueMap = this.processTagLineOptional("2CIUSERARG")) != null) {
                if (!bl) {
                    bl = true;
                    try {
                        this.fRuntimeBuilder.addVMInitArgs();
                    }
                    catch (BuilderFailureException builderFailureException) {
                        this.handleError("Failed to add JavaVMInitArgs to builder: ", builderFailureException);
                    }
                }
                String string = iAttributeValueMap.getTokenValue("environment_arg_string");
                long l = iAttributeValueMap.getLongValue("environment_arg_extra");
                try {
                    if (l == -1L) {
                        if (string == null) continue;
                        this.fRuntimeBuilder.addVMOption(string);
                        continue;
                    }
                    this.fRuntimeBuilder.addVMOption(string, l);
                }
                catch (BuilderFailureException builderFailureException) {
                    this.handleError("Failed to add VM option to builder: " + string + " ", builderFailureException);
                }
            }
        }
    }

    private void parseJVMMI() throws ParserException {
        this.processTagLineOptional("1CIJVMMI");
        this.processTagLineOptional("2CIJVMMIOFF");
    }

    private void parseEnvironmentVars() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineOptional("1CIENVVARS");
        if (iAttributeValueMap != null) {
            while ((iAttributeValueMap = this.processTagLineOptional("2CIENVVAR")) != null) {
                String string = iAttributeValueMap.getTokenValue("environment_variable_name");
                String string2 = iAttributeValueMap.getTokenValue("environment_variable_value");
                if (string == null || string2 == null) continue;
                this.fImageProcessBuilder.addEnvironmentVariable(string, string2);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

