/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import openj9.internal.security.RestrictedSecurity;
import sun.security.pkcs11.Config;
import sun.security.pkcs11.P11AEADCipher;
import sun.security.pkcs11.P11Cipher;
import sun.security.pkcs11.P11Digest;
import sun.security.pkcs11.P11ECDHKeyAgreement;
import sun.security.pkcs11.P11ECUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyAgreement;
import sun.security.pkcs11.P11KeyGenerator;
import sun.security.pkcs11.P11KeyPairGenerator;
import sun.security.pkcs11.P11Mac;
import sun.security.pkcs11.P11PSSSignature;
import sun.security.pkcs11.P11RSACipher;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Signature;
import sun.security.pkcs11.P11TlsKeyMaterialGenerator;
import sun.security.pkcs11.P11TlsMasterSecretGenerator;
import sun.security.pkcs11.P11TlsPrfGenerator;
import sun.security.pkcs11.P11TlsRsaPremasterSecretGenerator;
import sun.security.pkcs11.Secmod;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.Debug;
import sun.security.util.ECParameters;
import sun.security.util.ECUtil;
import sun.security.util.GCMParameters;
import sun.security.util.ResourcesMgr;

public final class SunPKCS11
extends AuthProvider {
    private static final long serialVersionUID = -1354835039035306505L;
    static final Debug debug = Debug.getInstance("sunpkcs11");
    private static int dummyConfigId;
    final PKCS11 p11;
    private final String configName;
    final Config config;
    final long slotID;
    private CallbackHandler pHandler;
    private final Object LOCK_HANDLER;
    final boolean removable;
    final Secmod.Module nssModule;
    final boolean nssUseSecmodTrust;
    private volatile Token token;
    private TokenPoller poller;
    static SunPKCS11 mysunpkcs11;
    static final ThreadLocal<Boolean> isExportWrapKey;
    private static final Map<Integer, List<Descriptor>> descriptors;
    private static final String MD = "MessageDigest";
    private static final String SIG = "Signature";
    private static final String KPG = "KeyPairGenerator";
    private static final String KG = "KeyGenerator";
    private static final String AGP = "AlgorithmParameters";
    private static final String KF = "KeyFactory";
    private static final String SKF = "SecretKeyFactory";
    private static final String CIP = "Cipher";
    private static final String MAC = "Mac";
    private static final String KA = "KeyAgreement";
    private static final String KS = "KeyStore";
    private static final String SR = "SecureRandom";

    Token getToken() {
        return this.token;
    }

    public SunPKCS11() {
        super("SunPKCS11-Dummy", 1.8, "SunPKCS11-Dummy");
        this.LOCK_HANDLER = new Object();
        throw new ProviderException("SunPKCS11 requires configuration file argument");
    }

    public SunPKCS11(String string) {
        this(SunPKCS11.checkNull(string), null);
    }

    public SunPKCS11(InputStream inputStream) {
        this(SunPKCS11.getDummyConfigName(), SunPKCS11.checkNull(inputStream));
    }

    private static <T> T checkNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    private static synchronized String getDummyConfigName() {
        int n = ++dummyConfigId;
        return "---DummyConfig-" + n + "---";
    }

    @Deprecated
    public SunPKCS11(String string, InputStream inputStream) {
        block59: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            super("SunPKCS11-" + Config.getConfig(string, inputStream).getName(), 1.8, Config.getConfig(string, inputStream).getDescription());
            this.LOCK_HANDLER = new Object();
            this.configName = string;
            this.config = Config.removeConfig(string);
            if (debug != null) {
                System.out.println("SunPKCS11 loading " + string);
            }
            String string2 = this.config.getLibrary();
            String string3 = this.config.getFunctionList();
            Object object7 = this.config.getSlotID();
            int n = this.config.getSlotListIndex();
            boolean bl = this.config.getNssUseSecmod();
            boolean bl2 = this.config.getNssUseSecmodTrust();
            Secmod.Module module = null;
            if (bl) {
                int n2;
                object6 = Secmod.getInstance();
                object5 = this.config.getNssDbMode();
                try {
                    object4 = this.config.getNssLibraryDirectory();
                    object3 = this.config.getNssSecmodDirectory();
                    n2 = this.config.getNssOptimizeSpace();
                    if (((Secmod)object6).isInitialized()) {
                        String string4;
                        if (object3 != null && (string4 = ((Secmod)object6).getConfigDir()) != null && !string4.equals(object3)) {
                            throw new ProviderException("Secmod directory " + (String)object3 + " invalid, NSS already initialized with " + string4);
                        }
                        if (object4 != null && (string4 = ((Secmod)object6).getLibDir()) != null && !string4.equals(object4)) {
                            throw new ProviderException("NSS library directory " + (String)object4 + " invalid, NSS already initialized with " + string4);
                        }
                    } else {
                        if (object5 != Secmod.DbMode.NO_DB) {
                            if (object3 == null) {
                                throw new ProviderException("Secmod not initialized and nssSecmodDirectory not specified");
                            }
                        } else if (object3 != null) {
                            throw new ProviderException("nssSecmodDirectory must not be specified in noDb mode");
                        }
                        ((Secmod)object6).initialize((Secmod.DbMode)((Object)object5), (String)object3, (String)object4, n2 != 0);
                    }
                }
                catch (IOException iOException) {
                    throw new ProviderException("Could not initialize NSS", iOException);
                }
                object4 = ((Secmod)object6).getModules();
                if (this.config.getShowInfo()) {
                    System.out.println("NSS modules: " + object4);
                }
                if ((object3 = this.config.getNssModule()) == null) {
                    module = ((Secmod)object6).getModule(Secmod.ModuleType.FIPS);
                    if (module != null) {
                        object3 = "fips";
                    } else {
                        Object object8 = object3 = object5 == Secmod.DbMode.NO_DB ? "crypto" : "keystore";
                    }
                }
                if (((String)object3).equals("fips")) {
                    module = ((Secmod)object6).getModule(Secmod.ModuleType.FIPS);
                    bl2 = true;
                    string3 = "FC_GetFunctionList";
                } else if (((String)object3).equals("keystore")) {
                    module = ((Secmod)object6).getModule(Secmod.ModuleType.KEYSTORE);
                    bl2 = true;
                } else if (((String)object3).equals("crypto")) {
                    module = ((Secmod)object6).getModule(Secmod.ModuleType.CRYPTO);
                } else if (((String)object3).equals("trustanchors")) {
                    module = ((Secmod)object6).getModule(Secmod.ModuleType.TRUSTANCHOR);
                    bl2 = true;
                } else if (((String)object3).startsWith("external-")) {
                    try {
                        n2 = Integer.parseInt(((String)object3).substring("external-".length()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                    if (n2 < 1) {
                        throw new ProviderException("Invalid external module: " + (String)object3);
                    }
                    int n3 = 0;
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object = (Secmod.Module)object2.next();
                        if (((Secmod.Module)object).getType() != Secmod.ModuleType.EXTERNAL || ++n3 != n2) continue;
                        module = object;
                        break;
                    }
                    if (module == null) {
                        throw new ProviderException("Invalid module " + (String)object3 + ": only " + n3 + " external NSS modules available");
                    }
                } else {
                    throw new ProviderException("Unknown NSS module: " + (String)object3);
                }
                if (module == null) {
                    throw new ProviderException("NSS module not available: " + (String)object3);
                }
                if (module.hasInitializedProvider()) {
                    throw new ProviderException("Secmod module already configured");
                }
                string2 = module.libraryName;
                n = module.slot;
            }
            this.nssUseSecmodTrust = bl2;
            this.nssModule = module;
            object6 = new File(string2);
            if (!((File)object6).getName().equals(string2) && !new File(string2).isFile()) {
                object5 = "Library " + string2 + " does not exist";
                if (this.config.getHandleStartupErrors() == 1) {
                    throw new ProviderException((String)object5);
                }
                throw new UnsupportedOperationException((String)object5);
            }
            try {
                if (debug != null) {
                    debug.println("Initializing PKCS#11 library " + string2);
                }
                object5 = new CK_C_INITIALIZE_ARGS();
                object4 = this.config.getNssArgs();
                if (object4 != null) {
                    ((CK_C_INITIALIZE_ARGS)object5).pReserved = object4;
                }
                ((CK_C_INITIALIZE_ARGS)object5).flags = 2L;
                try {
                    object3 = PKCS11.getInstance(string2, string3, (CK_C_INITIALIZE_ARGS)object5, this.config.getOmitInitialize());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (debug != null) {
                        debug.println("Multi-threaded initialization failed: " + pKCS11Exception);
                    }
                    if (!this.config.getAllowSingleThreadedModules()) {
                        throw pKCS11Exception;
                    }
                    if (object4 == null) {
                        object5 = null;
                    } else {
                        ((CK_C_INITIALIZE_ARGS)object5).flags = 0L;
                    }
                    object3 = PKCS11.getInstance(string2, string3, (CK_C_INITIALIZE_ARGS)object5, this.config.getOmitInitialize());
                }
                this.p11 = object3;
                CK_INFO cK_INFO = this.p11.C_GetInfo();
                if (cK_INFO.cryptokiVersion.major < 2) {
                    throw new ProviderException("Only PKCS#11 v2.0 and later supported, library version is v" + cK_INFO.cryptokiVersion);
                }
                boolean bl3 = this.config.getShowInfo();
                if (bl3) {
                    System.out.println("Information for provider " + this.getName());
                    System.out.println("Library info:");
                    System.out.println(cK_INFO);
                }
                if (object7 < 0L || bl3) {
                    object2 = this.p11.C_GetSlotList(false);
                    if (bl3) {
                        System.out.println("All slots: " + SunPKCS11.toString(object2));
                        object2 = this.p11.C_GetSlotList(true);
                        System.out.println("Slots with tokens: " + SunPKCS11.toString(object2));
                    }
                    if (object7 < 0L) {
                        if (n < 0 || n >= ((Object)object2).length) {
                            throw new ProviderException("slotListIndex is " + n + " but token only has " + ((long[])object2).length + " slots");
                        }
                        object7 = object2[n];
                    }
                }
                this.slotID = object7;
                object2 = this.p11.C_GetSlotInfo((long)object7);
                this.removable = (object2.flags & 2L) != 0L;
                this.initToken((CK_SLOT_INFO)object2);
                if (module != null) {
                    module.setProvider(this);
                }
                if (!RestrictedSecurity.isFIPSEnabled()) break block59;
                if (debug != null) {
                    debug.println("FIPS mode in SunPKCS11");
                }
                object = (Consumer)((Object)this.p11);
                object.accept(this);
                mysunpkcs11 = this;
                Session session = null;
                try {
                    session = this.token.getOpSession();
                    this.p11.C_Login(session.id(), 1L, new char[0]);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    throw pKCS11Exception;
                }
                finally {
                    this.token.releaseSession(session);
                }
            }
            catch (Exception exception) {
                if (this.config.getHandleStartupErrors() == 2) {
                    throw new UnsupportedOperationException("Initialization failed", exception);
                }
                throw new ProviderException("Initialization failed", exception);
            }
        }
    }

    private static String toString(long[] lArray) {
        if (lArray.length == 0) {
            return "(none)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static String[] s(String ... stringArray) {
        return stringArray;
    }

    byte[] exportKey(long l, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, long l2) throws PKCS11Exception {
        P11Key p11Key;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = this.token.getAttributes("generate", 4L, 31L, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, 32L)});
        Session session = this.token.getObjSession();
        try {
            long l3 = this.token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(4224L), cK_ATTRIBUTEArray2);
            isExportWrapKey.set(Boolean.TRUE);
            p11Key = (P11Key)((Object)P11Key.secretKey(session, l3, "AES", 32, null));
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw pKCS11Exception;
        }
        finally {
            isExportWrapKey.set(Boolean.TRUE);
            this.token.releaseSession(session);
        }
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(4229L, new byte[16]);
        long l4 = p11Key.getKeyID();
        byte[] byArray = this.token.p11.C_WrapKey(l, cK_MECHANISM, l4, l2);
        try {
            byte[] byArray2;
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)p11Key, new IvParameterSpec((byte[])cK_MECHANISM.pParameter), null);
            byte[] byArray3 = byArray2 = cipher.doFinal(byArray);
            return byArray3;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new PKCS11Exception(5L);
        }
        finally {
            p11Key.releaseKeyID();
        }
    }

    private static BigInteger getBigIntegerOrZero(Map<Long, CK_ATTRIBUTE> map, long l) {
        CK_ATTRIBUTE cK_ATTRIBUTE = map.get(l);
        return cK_ATTRIBUTE != null ? cK_ATTRIBUTE.getBigInteger() : BigInteger.ZERO;
    }

    /*
     * Unable to fully structure code
     */
    long importKey(long var1_1, CK_ATTRIBUTE[] var3_2) throws PKCS11Exception {
        var6_3 = 0L;
        var8_4 = 0L;
        var10_5 = null;
        var11_6 = new HashMap<Long, CK_ATTRIBUTE>();
        for (CK_ATTRIBUTE var15_14 : var3_2) {
            if (var15_14.type == 0L) {
                var6_3 = var15_14.getLong();
            }
            if (var15_14.type == 256L) {
                var8_4 = var15_14.getLong();
            }
            var11_6.put(var15_14.type, var15_14);
        }
        if (var6_3 == 3L) {
            if (var8_4 == 0L) {
                try {
                    var10_5 = RSAPrivateCrtKeyImpl.newKey(RSAUtil.KeyType.RSA, null, SunPKCS11.getBigIntegerOrZero(var11_6, 288L), SunPKCS11.getBigIntegerOrZero(var11_6, 290L), SunPKCS11.getBigIntegerOrZero(var11_6, 291L), SunPKCS11.getBigIntegerOrZero(var11_6, 292L), SunPKCS11.getBigIntegerOrZero(var11_6, 293L), SunPKCS11.getBigIntegerOrZero(var11_6, 294L), SunPKCS11.getBigIntegerOrZero(var11_6, 295L), SunPKCS11.getBigIntegerOrZero(var11_6, 296L)).getEncoded();
                }
                catch (InvalidKeyException var12_8) {
                    throw new PKCS11Exception(5L);
                }
            } else if (var8_4 == 3L) {
                var12_7 = (CK_ATTRIBUTE)var11_6.get(384L);
                if (var12_7 == null) {
                    throw new PKCS11Exception(5L);
                }
                try {
                    var10_5 = P11ECUtil.generateECPrivateKey(var11_6.getOrDefault(17L, new CK_ATTRIBUTE(17L, BigInteger.ZERO)).getBigInteger(), ECUtil.getECParameterSpec(Security.getProvider("SunEC"), var12_7.getByteArray())).getEncoded();
                    if (!this.token.config.getNssNetscapeDbWorkaround() || var11_6.containsKey(3584088832L)) ** GOTO lbl38
                    var11_6.put(3584088832L, new CK_ATTRIBUTE(3584088832L, BigInteger.ZERO));
                }
                catch (IOException | InvalidKeySpecException var13_10) {
                    throw new PKCS11Exception(5L);
                }
            }
        } else if (var6_3 == 4L) {
            var12_7 = (CK_ATTRIBUTE)var11_6.get(17L);
            if (var12_7 == null) {
                throw new PKCS11Exception(5L);
            }
            var10_5 = var12_7.getByteArray();
        }
lbl38:
        // 7 sources

        if (var10_5 != null && var10_5.length > 0 && (var6_3 == 4L || var6_3 == 3L && (var8_4 == 3L || var8_4 == 0L))) {
            var12_7 = this.token.getAttributes("generate", 4L, 31L, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, 32L)});
            var13_11 = this.token.getObjSession();
            try {
                var15_15 = this.token.p11.C_GenerateKey(var13_11.id(), new CK_MECHANISM(4224L), (CK_ATTRIBUTE[])var12_7);
                var14_13 = (P11Key)P11Key.secretKey(var13_11, var15_15, "AES", 32, null);
            }
            catch (PKCS11Exception var15_16) {
                throw var15_16;
            }
            finally {
                this.token.releaseSession(var13_11);
            }
            var15_15 = var14_13.getKeyID();
            try {
                var17_18 = new CK_MECHANISM(4229L, new byte[16]);
                var18_20 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                var18_20.init(1, (Key)var14_13, new IvParameterSpec((byte[])var17_18.pParameter), null);
                var19_21 = var18_20.doFinal(var10_5);
                var20_22 = this.token.getAttributes("import", var6_3, var8_4, var11_6.values().toArray(new CK_ATTRIBUTE[var11_6.size()]));
                var4_23 = this.token.p11.C_UnwrapKey(var1_1, var17_18, var15_15, var19_21, var20_22);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | PKCS11Exception var17_19) {
                throw new PKCS11Exception(5L);
            }
            finally {
                var14_13.releaseKeyID();
            }
        }
        throw new PKCS11Exception(5L);
        return var4_23;
    }

    private static int[] m(long l) {
        return new int[]{(int)l};
    }

    private static int[] m(long l, long l2) {
        return new int[]{(int)l, (int)l2};
    }

    private static int[] m(long l, long l2, long l3) {
        return new int[]{(int)l, (int)l2, (int)l3};
    }

    private static int[] m(long l, long l2, long l3, long l4) {
        return new int[]{(int)l, (int)l2, (int)l3, (int)l4};
    }

    private static void d(String string, String string2, String string3, int[] nArray) {
        SunPKCS11.register(new Descriptor(string, string2, string3, null, nArray));
    }

    private static void d(String string, String string2, String string3, String[] stringArray, int[] nArray) {
        SunPKCS11.register(new Descriptor(string, string2, string3, stringArray, nArray));
    }

    private static void register(Descriptor descriptor) {
        for (int i = 0; i < descriptor.mechanisms.length; ++i) {
            int n = descriptor.mechanisms[i];
            Integer n2 = n;
            List<Descriptor> list = descriptors.get(n2);
            if (list == null) {
                list = new ArrayList<Descriptor>();
                descriptors.put(n2, list);
            }
            list.add(descriptor);
        }
    }

    private void createPoller() {
        if (this.poller != null) {
            return;
        }
        TokenPoller tokenPoller = new TokenPoller(this);
        Thread thread = new Thread((Runnable)tokenPoller, "Poller " + this.getName());
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.poller = tokenPoller;
    }

    private void destroyPoller() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller = null;
        }
    }

    private boolean hasValidToken() {
        Token token = this.token;
        return token != null && token.isValid();
    }

    synchronized void uninitToken(Token token) {
        if (this.token != token) {
            return;
        }
        this.destroyPoller();
        this.token = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SunPKCS11.this.clear();
                return null;
            }
        });
        this.createPoller();
    }

    private static boolean isLegacy(CK_MECHANISM_INFO cK_MECHANISM_INFO) throws PKCS11Exception {
        boolean bl = false;
        if (cK_MECHANISM_INFO != null) {
            if ((cK_MECHANISM_INFO.flags & 0x200L) != 0L) {
                bl |= (cK_MECHANISM_INFO.flags & 0x100L) == 0L;
            }
            if ((cK_MECHANISM_INFO.flags & 0x2000L) != 0L) {
                bl |= (cK_MECHANISM_INFO.flags & 0x800L) == 0L;
            }
        }
        return bl;
    }

    private void initToken(CK_SLOT_INFO cK_SLOT_INFO) throws PKCS11Exception {
        if (cK_SLOT_INFO == null) {
            cK_SLOT_INFO = this.p11.C_GetSlotInfo(this.slotID);
        }
        if (this.removable && (cK_SLOT_INFO.flags & 1L) == 0L) {
            this.createPoller();
            return;
        }
        this.destroyPoller();
        boolean bl = this.config.getShowInfo();
        if (bl) {
            System.out.println("Slot info for slot " + this.slotID + ":");
            System.out.println(cK_SLOT_INFO);
        }
        final Token token = new Token(this);
        if (bl) {
            System.out.println("Token info for token in slot " + this.slotID + ":");
            System.out.println(token.tokenInfo);
        }
        long[] lArray = this.p11.C_GetMechanismList(this.slotID);
        final HashMap<Descriptor, Integer> hashMap = new HashMap<Descriptor, Integer>();
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            CK_MECHANISM_INFO cK_MECHANISM_INFO = token.getMechanismInfo(l);
            if (bl) {
                System.out.println("Mechanism " + Functions.getMechanismName(l) + ":");
                System.out.println(cK_MECHANISM_INFO == null ? "  info n/a" : cK_MECHANISM_INFO);
            }
            if (!this.config.isEnabled(l)) {
                if (!bl) continue;
                System.out.println("DISABLED in configuration");
                continue;
            }
            if (SunPKCS11.isLegacy(cK_MECHANISM_INFO)) {
                if (!bl) continue;
                System.out.println("DISABLED due to legacy");
                continue;
            }
            if (l >>> 32 != 0L) {
                if (!bl) continue;
                System.out.println("DISABLED due to unknown mech value");
                continue;
            }
            int n = (int)l;
            Integer n2 = n;
            List<Descriptor> list = descriptors.get(n2);
            if (list == null) continue;
            block1: for (Descriptor descriptor : list) {
                Integer n3 = (Integer)hashMap.get(descriptor);
                if (n3 == null) {
                    hashMap.put(descriptor, n2);
                    continue;
                }
                int n4 = n3;
                for (int j = 0; j < descriptor.mechanisms.length; ++j) {
                    int n5 = descriptor.mechanisms[j];
                    if (n == n5) {
                        hashMap.put(descriptor, n2);
                        continue block1;
                    }
                    if (n4 == n5) continue block1;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Map.Entry entry : hashMap.entrySet()) {
                    Descriptor descriptor = (Descriptor)entry.getKey();
                    int n = (Integer)entry.getValue();
                    P11Service p11Service = descriptor.service(token, n);
                    SunPKCS11.this.putService(p11Service);
                }
                if ((token.tokenInfo.flags & 1L) != 0L && SunPKCS11.this.config.isEnabled(2147483424L) && !token.sessionManager.lowMaxSessions()) {
                    SunPKCS11.this.putService(new P11Service(token, SunPKCS11.SR, "PKCS11", "sun.security.pkcs11.P11SecureRandom", null, 2147483424L));
                }
                if (SunPKCS11.this.config.isEnabled(2147483425L)) {
                    SunPKCS11.this.putService(new P11Service(token, SunPKCS11.KS, "PKCS11", "sun.security.pkcs11.P11KeyStore", SunPKCS11.s(new String[]{"PKCS11-" + SunPKCS11.this.config.getName()}), 2147483425L));
                }
                return null;
            }
        });
        this.token = token;
    }

    @Override
    public void login(Subject subject, CallbackHandler callbackHandler) throws LoginException {
        Object object;
        Object object2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (debug != null) {
                debug.println("checking login permission");
            }
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            throw new LoginException("No token present");
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("login operation not required for token - ignoring login request");
            }
            return;
        }
        try {
            if (this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        char[] cArray = null;
        if ((this.token.tokenInfo.flags & 0x100L) == 0L) {
            object2 = this.getCallbackHandler(callbackHandler);
            if (object2 == null) {
                throw new LoginException("no password provided, and no callback handler available for retrieving password");
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("PKCS11.Token.providerName.Password."));
            object = new Object[]{this.getName()};
            PasswordCallback passwordCallback = new PasswordCallback(messageFormat.format(object), false);
            Callback[] callbackArray = new Callback[]{passwordCallback};
            try {
                object2.handle(callbackArray);
            }
            catch (Exception exception) {
                LoginException loginException = new LoginException("Unable to perform password callback");
                loginException.initCause(exception);
                throw loginException;
            }
            cArray = passwordCallback.getPassword();
            passwordCallback.clearPassword();
            if (cArray == null && debug != null) {
                debug.println("caller passed NULL pin");
            }
        }
        object2 = null;
        try {
            object2 = this.token.getOpSession();
            this.p11.C_Login(((Session)object2).id(), 1L, cArray);
            if (debug != null) {
                debug.println("login succeeded");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 256L) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
            if (pKCS11Exception.getErrorCode() == 160L) {
                object = new FailedLoginException();
                ((Throwable)object).initCause(pKCS11Exception);
                throw object;
            }
            object = new LoginException();
            ((Throwable)object).initCause(pKCS11Exception);
            throw object;
        }
        finally {
            this.token.releaseSession((Session)object2);
            if (cArray != null) {
                Arrays.fill(cArray, ' ');
            }
        }
    }

    @Override
    public void logout() throws LoginException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            return;
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("logout operation not required for token - ignoring logout request");
            }
            return;
        }
        try {
            if (!this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Logout(session.id());
            if (debug != null) {
                debug.println("logout succeeded");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 257L) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
            LoginException loginException = new LoginException();
            loginException.initCause(pKCS11Exception);
            throw loginException;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            this.pHandler = callbackHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler(CallbackHandler callbackHandler) {
        if (callbackHandler != null) {
            return callbackHandler;
        }
        if (debug != null) {
            debug.println("getting provider callback handler");
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            if (this.pHandler != null) {
                return this.pHandler;
            }
            try {
                CallbackHandler callbackHandler2;
                if (debug != null) {
                    debug.println("getting default callback handler");
                }
                this.pHandler = callbackHandler2 = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                    @Override
                    public CallbackHandler run() throws Exception {
                        String string = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (string == null || string.length() == 0) {
                            if (debug != null) {
                                debug.println("no default handler set");
                            }
                            return null;
                        }
                        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                        return (CallbackHandler)clazz.newInstance();
                    }
                });
                return callbackHandler2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (debug != null) {
                    debug.println("Unable to load default callback handler");
                    privilegedActionException.printStackTrace();
                }
            }
        }
        return null;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SunPKCS11Rep(this);
    }

    static {
        isExportWrapKey = ThreadLocal.withInitial(() -> Boolean.FALSE);
        descriptors = new HashMap<Integer, List<Descriptor>>();
        String string = "sun.security.pkcs11.P11Digest";
        String string2 = "sun.security.pkcs11.P11MAC";
        String string3 = "sun.security.pkcs11.P11KeyPairGenerator";
        String string4 = "sun.security.pkcs11.P11KeyGenerator";
        String string5 = "sun.security.pkcs11.P11RSAKeyFactory";
        String string6 = "sun.security.pkcs11.P11DSAKeyFactory";
        String string7 = "sun.security.pkcs11.P11DHKeyFactory";
        String string8 = "sun.security.pkcs11.P11KeyAgreement";
        String string9 = "sun.security.pkcs11.P11SecretKeyFactory";
        String string10 = "sun.security.pkcs11.P11Cipher";
        String string11 = "sun.security.pkcs11.P11RSACipher";
        String string12 = "sun.security.pkcs11.P11AEADCipher";
        String string13 = "sun.security.pkcs11.P11Signature";
        String string14 = "sun.security.pkcs11.P11PSSSignature";
        SunPKCS11.d(MD, "MD2", string, SunPKCS11.m(512L));
        SunPKCS11.d(MD, "MD5", string, SunPKCS11.m(528L));
        SunPKCS11.d(MD, "SHA1", string, SunPKCS11.s("SHA", "SHA-1", "1.3.14.3.2.26", "OID.1.3.14.3.2.26"), SunPKCS11.m(544L));
        SunPKCS11.d(MD, "SHA-224", string, SunPKCS11.s("2.16.840.1.101.3.4.2.4", "OID.2.16.840.1.101.3.4.2.4"), SunPKCS11.m(597L));
        SunPKCS11.d(MD, "SHA-256", string, SunPKCS11.s("2.16.840.1.101.3.4.2.1", "OID.2.16.840.1.101.3.4.2.1"), SunPKCS11.m(592L));
        SunPKCS11.d(MD, "SHA-384", string, SunPKCS11.s("2.16.840.1.101.3.4.2.2", "OID.2.16.840.1.101.3.4.2.2"), SunPKCS11.m(608L));
        SunPKCS11.d(MD, "SHA-512", string, SunPKCS11.s("2.16.840.1.101.3.4.2.3", "OID.2.16.840.1.101.3.4.2.3"), SunPKCS11.m(624L));
        SunPKCS11.d(MD, "SHA-512/224", string, SunPKCS11.s("2.16.840.1.101.3.4.2.5", "OID.2.16.840.1.101.3.4.2.5"), SunPKCS11.m(72L));
        SunPKCS11.d(MD, "SHA-512/256", string, SunPKCS11.s("2.16.840.1.101.3.4.2.6", "OID.2.16.840.1.101.3.4.2.6"), SunPKCS11.m(76L));
        SunPKCS11.d(MAC, "HmacMD5", string2, SunPKCS11.m(529L));
        SunPKCS11.d(MAC, "HmacSHA1", string2, SunPKCS11.s("1.2.840.113549.2.7", "OID.1.2.840.113549.2.7"), SunPKCS11.m(545L));
        SunPKCS11.d(MAC, "HmacSHA224", string2, SunPKCS11.s("1.2.840.113549.2.8", "OID.1.2.840.113549.2.8"), SunPKCS11.m(598L));
        SunPKCS11.d(MAC, "HmacSHA256", string2, SunPKCS11.s("1.2.840.113549.2.9", "OID.1.2.840.113549.2.9"), SunPKCS11.m(593L));
        SunPKCS11.d(MAC, "HmacSHA384", string2, SunPKCS11.s("1.2.840.113549.2.10", "OID.1.2.840.113549.2.10"), SunPKCS11.m(609L));
        SunPKCS11.d(MAC, "HmacSHA512", string2, SunPKCS11.s("1.2.840.113549.2.11", "OID.1.2.840.113549.2.11"), SunPKCS11.m(625L));
        SunPKCS11.d(MAC, "HmacSHA512/224", string2, SunPKCS11.s("1.2.840.113549.2.12", "OID.1.2.840.113549.2.12"), SunPKCS11.m(73L));
        SunPKCS11.d(MAC, "HmacSHA512/256", string2, SunPKCS11.s("1.2.840.113549.2.13", "OID.1.2.840.113549.2.13"), SunPKCS11.m(77L));
        SunPKCS11.d(MAC, "SslMacMD5", string2, SunPKCS11.m(896L));
        SunPKCS11.d(MAC, "SslMacSHA1", string2, SunPKCS11.m(897L));
        SunPKCS11.d(KPG, "RSA", string3, SunPKCS11.s("1.2.840.113549.1.1", "OID.1.2.840.113549.1.1"), SunPKCS11.m(0L));
        SunPKCS11.d(KPG, "DSA", string3, SunPKCS11.s("1.3.14.3.2.12", "1.2.840.10040.4.1", "OID.1.2.840.10040.4.1"), SunPKCS11.m(16L));
        SunPKCS11.d(KPG, "DH", string3, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(32L));
        SunPKCS11.d(KPG, "EC", string3, SunPKCS11.m(4160L));
        SunPKCS11.d(KG, "ARCFOUR", string4, SunPKCS11.s("RC4"), SunPKCS11.m(272L));
        SunPKCS11.d(KG, "DES", string4, SunPKCS11.m(288L));
        SunPKCS11.d(KG, "DESede", string4, SunPKCS11.m(305L, 304L));
        SunPKCS11.d(KG, "AES", string4, SunPKCS11.m(4224L));
        SunPKCS11.d(KG, "Blowfish", string4, SunPKCS11.m(4240L));
        SunPKCS11.d(KF, "RSA", string5, SunPKCS11.s("1.2.840.113549.1.1", "OID.1.2.840.113549.1.1"), SunPKCS11.m(0L, 1L, 3L));
        SunPKCS11.d(KF, "DSA", string6, SunPKCS11.s("1.3.14.3.2.12", "1.2.840.10040.4.1", "OID.1.2.840.10040.4.1"), SunPKCS11.m(16L, 17L, 18L));
        SunPKCS11.d(KF, "DH", string7, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(32L, 33L));
        SunPKCS11.d(KF, "EC", string7, SunPKCS11.m(4160L, 4176L, 4161L, 4162L));
        SunPKCS11.d(AGP, "EC", "sun.security.util.ECParameters", SunPKCS11.s("1.2.840.10045.2.1"), SunPKCS11.m(4160L, 4176L, 4161L, 4162L));
        SunPKCS11.d(AGP, "GCM", "sun.security.util.GCMParameters", SunPKCS11.m(4231L));
        SunPKCS11.d(KA, "DH", string8, SunPKCS11.s("DiffieHellman"), SunPKCS11.m(33L));
        SunPKCS11.d(KA, "ECDH", "sun.security.pkcs11.P11ECDHKeyAgreement", SunPKCS11.m(4176L));
        SunPKCS11.d(SKF, "ARCFOUR", string9, SunPKCS11.s("RC4"), SunPKCS11.m(273L));
        SunPKCS11.d(SKF, "DES", string9, SunPKCS11.m(290L));
        SunPKCS11.d(SKF, "DESede", string9, SunPKCS11.m(307L));
        SunPKCS11.d(SKF, "AES", string9, SunPKCS11.s("2.16.840.1.101.3.4.1", "OID.2.16.840.1.101.3.4.1"), SunPKCS11.m(4226L));
        SunPKCS11.d(SKF, "Blowfish", string9, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "ARCFOUR", string10, SunPKCS11.s("RC4"), SunPKCS11.m(273L));
        SunPKCS11.d(CIP, "DES/CBC/NoPadding", string10, SunPKCS11.m(290L));
        SunPKCS11.d(CIP, "DES/CBC/PKCS5Padding", string10, SunPKCS11.m(293L, 290L));
        SunPKCS11.d(CIP, "DES/ECB/NoPadding", string10, SunPKCS11.m(289L));
        SunPKCS11.d(CIP, "DES/ECB/PKCS5Padding", string10, SunPKCS11.s("DES"), SunPKCS11.m(289L));
        SunPKCS11.d(CIP, "DESede/CBC/NoPadding", string10, SunPKCS11.m(307L));
        SunPKCS11.d(CIP, "DESede/CBC/PKCS5Padding", string10, SunPKCS11.m(310L, 307L));
        SunPKCS11.d(CIP, "DESede/ECB/NoPadding", string10, SunPKCS11.m(306L));
        SunPKCS11.d(CIP, "DESede/ECB/PKCS5Padding", string10, SunPKCS11.s("DESede"), SunPKCS11.m(306L));
        SunPKCS11.d(CIP, "AES/CBC/NoPadding", string10, SunPKCS11.m(4226L));
        SunPKCS11.d(CIP, "AES_128/CBC/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.2", "OID.2.16.840.1.101.3.4.1.2"), SunPKCS11.m(4226L));
        SunPKCS11.d(CIP, "AES_192/CBC/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.22", "OID.2.16.840.1.101.3.4.1.22"), SunPKCS11.m(4226L));
        SunPKCS11.d(CIP, "AES_256/CBC/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.42", "OID.2.16.840.1.101.3.4.1.42"), SunPKCS11.m(4226L));
        SunPKCS11.d(CIP, "AES/CBC/PKCS5Padding", string10, SunPKCS11.m(4229L, 4226L));
        SunPKCS11.d(CIP, "AES/ECB/NoPadding", string10, SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES_128/ECB/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.1", "OID.2.16.840.1.101.3.4.1.1"), SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES_192/ECB/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.21", "OID.2.16.840.1.101.3.4.1.21"), SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES_256/ECB/NoPadding", string10, SunPKCS11.s("2.16.840.1.101.3.4.1.41", "OID.2.16.840.1.101.3.4.1.41"), SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES/ECB/PKCS5Padding", string10, SunPKCS11.s("AES"), SunPKCS11.m(4225L));
        SunPKCS11.d(CIP, "AES/CTR/NoPadding", string10, SunPKCS11.m(4230L));
        SunPKCS11.d(CIP, "AES/GCM/NoPadding", string12, SunPKCS11.m(4231L));
        SunPKCS11.d(CIP, "AES_128/GCM/NoPadding", string12, SunPKCS11.s("2.16.840.1.101.3.4.1.6", "OID.2.16.840.1.101.3.4.1.6"), SunPKCS11.m(4231L));
        SunPKCS11.d(CIP, "AES_192/GCM/NoPadding", string12, SunPKCS11.s("2.16.840.1.101.3.4.1.26", "OID.2.16.840.1.101.3.4.1.26"), SunPKCS11.m(4231L));
        SunPKCS11.d(CIP, "AES_256/GCM/NoPadding", string12, SunPKCS11.s("2.16.840.1.101.3.4.1.46", "OID.2.16.840.1.101.3.4.1.46"), SunPKCS11.m(4231L));
        SunPKCS11.d(CIP, "Blowfish/CBC/NoPadding", string10, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "Blowfish/CBC/PKCS5Padding", string10, SunPKCS11.m(4241L));
        SunPKCS11.d(CIP, "RSA/ECB/PKCS1Padding", string11, SunPKCS11.s("RSA"), SunPKCS11.m(1L));
        SunPKCS11.d(CIP, "RSA/ECB/NoPadding", string11, SunPKCS11.m(3L));
        SunPKCS11.d(SIG, "RawDSA", string13, SunPKCS11.s("NONEwithDSA"), SunPKCS11.m(17L));
        SunPKCS11.d(SIG, "DSA", string13, SunPKCS11.s("SHA1withDSA", "1.3.14.3.2.13", "1.3.14.3.2.27", "1.2.840.10040.4.3", "OID.1.2.840.10040.4.3"), SunPKCS11.m(18L, 17L));
        SunPKCS11.d(SIG, "SHA224withDSA", string13, SunPKCS11.s("2.16.840.1.101.3.4.3.1", "OID.2.16.840.1.101.3.4.3.1"), SunPKCS11.m(19L));
        SunPKCS11.d(SIG, "SHA256withDSA", string13, SunPKCS11.s("2.16.840.1.101.3.4.3.2", "OID.2.16.840.1.101.3.4.3.2"), SunPKCS11.m(20L));
        SunPKCS11.d(SIG, "SHA384withDSA", string13, SunPKCS11.s("2.16.840.1.101.3.4.3.3", "OID.2.16.840.1.101.3.4.3.3"), SunPKCS11.m(21L));
        SunPKCS11.d(SIG, "SHA512withDSA", string13, SunPKCS11.s("2.16.840.1.101.3.4.3.4", "OID.2.16.840.1.101.3.4.3.4"), SunPKCS11.m(22L));
        SunPKCS11.d(SIG, "NONEwithECDSA", string13, SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA1withECDSA", string13, SunPKCS11.s("ECDSA", "1.2.840.10045.4.1", "OID.1.2.840.10045.4.1"), SunPKCS11.m(4162L, 4161L));
        SunPKCS11.d(SIG, "SHA224withECDSA", string13, SunPKCS11.s("1.2.840.10045.4.3.1", "OID.1.2.840.10045.4.3.1"), SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA256withECDSA", string13, SunPKCS11.s("1.2.840.10045.4.3.2", "OID.1.2.840.10045.4.3.2"), SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA384withECDSA", string13, SunPKCS11.s("1.2.840.10045.4.3.3", "OID.1.2.840.10045.4.3.3"), SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "SHA512withECDSA", string13, SunPKCS11.s("1.2.840.10045.4.3.4", "OID.1.2.840.10045.4.3.4"), SunPKCS11.m(4161L));
        SunPKCS11.d(SIG, "MD2withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.2", "OID.1.2.840.113549.1.1.2"), SunPKCS11.m(4L, 1L, 3L));
        SunPKCS11.d(SIG, "MD5withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.4", "OID.1.2.840.113549.1.1.4"), SunPKCS11.m(5L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA1withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.5", "OID.1.2.840.113549.1.1.5", "1.3.14.3.2.29"), SunPKCS11.m(6L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA224withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.14", "OID.1.2.840.113549.1.1.14"), SunPKCS11.m(70L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA256withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.11", "OID.1.2.840.113549.1.1.11"), SunPKCS11.m(64L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA384withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.12", "OID.1.2.840.113549.1.1.12"), SunPKCS11.m(65L, 1L, 3L));
        SunPKCS11.d(SIG, "SHA512withRSA", string13, SunPKCS11.s("1.2.840.113549.1.1.13", "OID.1.2.840.113549.1.1.13"), SunPKCS11.m(66L, 1L, 3L));
        SunPKCS11.d(SIG, "RSASSA-PSS", string14, SunPKCS11.s("1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"), SunPKCS11.m(13L));
        SunPKCS11.d(SIG, "SHA1withRSASSA-PSS", string14, SunPKCS11.m(14L));
        SunPKCS11.d(SIG, "SHA224withRSASSA-PSS", string14, SunPKCS11.m(71L));
        SunPKCS11.d(SIG, "SHA256withRSASSA-PSS", string14, SunPKCS11.m(67L));
        SunPKCS11.d(SIG, "SHA384withRSASSA-PSS", string14, SunPKCS11.m(68L));
        SunPKCS11.d(SIG, "SHA512withRSASSA-PSS", string14, SunPKCS11.m(69L));
        SunPKCS11.d(KG, "SunTlsRsaPremasterSecret", "sun.security.pkcs11.P11TlsRsaPremasterSecretGenerator", SunPKCS11.s("SunTls12RsaPremasterSecret"), SunPKCS11.m(880L, 884L));
        SunPKCS11.d(KG, "SunTlsMasterSecret", "sun.security.pkcs11.P11TlsMasterSecretGenerator", SunPKCS11.m(881L, 885L, 883L, 887L));
        SunPKCS11.d(KG, "SunTlsExtendedMasterSecret", "sun.security.pkcs11.P11TlsMasterSecretGenerator", SunPKCS11.m(3461563241L, 3461563242L));
        SunPKCS11.d(KG, "SunTls12MasterSecret", "sun.security.pkcs11.P11TlsMasterSecretGenerator", SunPKCS11.m(992L, 994L));
        SunPKCS11.d(KG, "SunTlsKeyMaterial", "sun.security.pkcs11.P11TlsKeyMaterialGenerator", SunPKCS11.m(882L, 886L));
        SunPKCS11.d(KG, "SunTls12KeyMaterial", "sun.security.pkcs11.P11TlsKeyMaterialGenerator", SunPKCS11.m(993L));
        SunPKCS11.d(KG, "SunTlsPrf", "sun.security.pkcs11.P11TlsPrfGenerator", SunPKCS11.m(888L, 2147484531L));
        SunPKCS11.d(KG, "SunTls12Prf", "sun.security.pkcs11.P11TlsPrfGenerator", SunPKCS11.m(996L));
    }

    private static class SunPKCS11Rep
    implements Serializable {
        static final long serialVersionUID = -2896606995897745419L;
        private final String providerName;
        private final String configName;

        SunPKCS11Rep(SunPKCS11 sunPKCS11) throws NotSerializableException {
            this.providerName = sunPKCS11.getName();
            this.configName = sunPKCS11.configName;
            if (Security.getProvider(this.providerName) != sunPKCS11) {
                throw new NotSerializableException("Only SunPKCS11 providers installed in java.security.Security can be serialized");
            }
        }

        private Object readResolve() throws ObjectStreamException {
            SunPKCS11 sunPKCS11 = (SunPKCS11)Security.getProvider(this.providerName);
            if (sunPKCS11 == null || !sunPKCS11.configName.equals(this.configName)) {
                throw new NotSerializableException("Could not find " + this.providerName + " in installed providers");
            }
            return sunPKCS11;
        }
    }

    private static final class P11Service
    extends Provider.Service {
        private final Token token;
        private final long mechanism;

        P11Service(Token token, String string, String string2, String string3, String[] stringArray, long l) {
            super(token.provider, string, string2, string3, P11Service.toList(stringArray), null);
            this.token = token;
            this.mechanism = l & 0xFFFFFFFFL;
        }

        private static List<String> toList(String[] stringArray) {
            return stringArray == null ? null : Arrays.asList(stringArray);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (!this.token.isValid()) {
                throw new NoSuchAlgorithmException("Token has been removed");
            }
            try {
                return this.newInstance0(object);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new NoSuchAlgorithmException(pKCS11Exception);
            }
        }

        public Object newInstance0(Object object) throws PKCS11Exception, NoSuchAlgorithmException {
            String string = this.getAlgorithm();
            String string2 = this.getType();
            if (string2 == SunPKCS11.MD) {
                return new P11Digest(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.CIP) {
                if (string.startsWith("RSA")) {
                    return new P11RSACipher(this.token, string, this.mechanism);
                }
                if (string.endsWith("GCM/NoPadding")) {
                    return new P11AEADCipher(this.token, string, this.mechanism);
                }
                return new P11Cipher(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.SIG) {
                if (string.indexOf("RSASSA-PSS") != -1) {
                    return new P11PSSSignature(this.token, string, this.mechanism);
                }
                return new P11Signature(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.MAC) {
                return new P11Mac(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KPG) {
                return new P11KeyPairGenerator(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KA) {
                if (string.equals("ECDH")) {
                    return new P11ECDHKeyAgreement(this.token, string, this.mechanism);
                }
                return new P11KeyAgreement(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.KF) {
                return this.token.getKeyFactory(string);
            }
            if (string2 == SunPKCS11.SKF) {
                return new P11SecretKeyFactory(this.token, string);
            }
            if (string2 == SunPKCS11.KG) {
                if (string == "SunTlsRsaPremasterSecret") {
                    return new P11TlsRsaPremasterSecretGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsMasterSecret" || string == "SunTls12MasterSecret" || string == "SunTlsExtendedMasterSecret") {
                    return new P11TlsMasterSecretGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsKeyMaterial" || string == "SunTls12KeyMaterial") {
                    return new P11TlsKeyMaterialGenerator(this.token, string, this.mechanism);
                }
                if (string == "SunTlsPrf" || string == "SunTls12Prf") {
                    return new P11TlsPrfGenerator(this.token, string, this.mechanism);
                }
                return new P11KeyGenerator(this.token, string, this.mechanism);
            }
            if (string2 == SunPKCS11.SR) {
                return this.token.getRandom();
            }
            if (string2 == SunPKCS11.KS) {
                return this.token.getKeyStore();
            }
            if (string2 == SunPKCS11.AGP) {
                if (string == "EC") {
                    return new ECParameters();
                }
                if (string == "GCM") {
                    return new GCMParameters();
                }
                throw new NoSuchAlgorithmException("Unsupported algorithm: " + string);
            }
            throw new NoSuchAlgorithmException("Unknown type: " + string2);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object == null || !this.token.isValid()) {
                return false;
            }
            if (!(object instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String string = this.getAlgorithm();
            String string2 = this.getType();
            Key key = (Key)object;
            String string3 = key.getAlgorithm();
            if (string2 == SunPKCS11.CIP && string.startsWith("RSA") || string2 == SunPKCS11.SIG && string.indexOf("RSA") != -1) {
                if (!string3.equals("RSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof RSAPrivateKey || key instanceof RSAPublicKey;
            }
            if (string2 == SunPKCS11.KA && string.equals("ECDH") || string2 == SunPKCS11.SIG && string.endsWith("ECDSA")) {
                if (!string3.equals("EC")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (string2 == SunPKCS11.SIG && string.endsWith("DSA")) {
                if (!string3.equals("DSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DSAPrivateKey || key instanceof DSAPublicKey;
            }
            if (string2 == SunPKCS11.CIP || string2 == SunPKCS11.MAC) {
                return this.isLocalKey(key) || "RAW".equals(key.getFormat());
            }
            if (string2 == SunPKCS11.KA) {
                if (!string3.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DHPrivateKey || key instanceof DHPublicKey;
            }
            throw new AssertionError((Object)("SunPKCS11 error: " + string2 + ", " + string));
        }

        private boolean isLocalKey(Key key) {
            return key instanceof P11Key && ((P11Key)key).token == this.token;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + Functions.getMechanismName(this.mechanism) + ")";
        }
    }

    private static class TokenPoller
    implements Runnable {
        private final SunPKCS11 provider;
        private volatile boolean enabled;

        private TokenPoller(SunPKCS11 sunPKCS11) {
            this.provider = sunPKCS11;
            this.enabled = true;
        }

        @Override
        public void run() {
            int n = this.provider.config.getInsertionCheckInterval();
            while (this.enabled) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!this.enabled) break;
                try {
                    this.provider.initToken(null);
                }
                catch (PKCS11Exception pKCS11Exception) {}
            }
        }

        void disable() {
            this.enabled = false;
        }
    }

    private static final class Descriptor {
        final String type;
        final String algorithm;
        final String className;
        final String[] aliases;
        final int[] mechanisms;

        private Descriptor(String string, String string2, String string3, String[] stringArray, int[] nArray) {
            this.type = string;
            this.algorithm = string2;
            this.className = string3;
            this.aliases = stringArray;
            this.mechanisms = nArray;
        }

        private P11Service service(Token token, int n) {
            return new P11Service(token, this.type, this.algorithm, this.className, this.aliases, n);
        }

        public String toString() {
            return this.type + "." + this.algorithm;
        }
    }
}

