/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDRLibraryAdapter
implements LibraryAdapter {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private ArrayList<String> moduleNames = null;
    private final ArrayList<String> errorMessages = new ArrayList();

    @Override
    public ArrayList<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public ArrayList<String> getLibraryList(File file) {
        if (this.moduleNames == null) {
            this.constructLibraryList(file);
        }
        return this.moduleNames;
    }

    @Override
    public boolean isLibraryCollectionRequired(File file) {
        ICore iCore = this.getReader(file.getPath());
        return iCore instanceof ILibraryDependentCore;
    }

    private ICore getReader(String string) {
        ICore iCore;
        try {
            iCore = CoreReader.readCoreFile(string);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Could not open core file", iOException);
            this.errorMessages.add(iOException.getMessage());
            return null;
        }
        return iCore;
    }

    private void constructLibraryList(File file) {
        boolean bl;
        Image image;
        this.moduleNames = new ArrayList();
        J9DDRImageFactory j9DDRImageFactory = new J9DDRImageFactory();
        try {
            image = j9DDRImageFactory.getImage(file);
            bl = image.getSystemType().toLowerCase().startsWith("aix");
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Could not open core file", iOException);
            this.errorMessages.add(iOException.getMessage());
            return;
        }
        catch (CorruptDataException corruptDataException) {
            logger.log(Level.SEVERE, "Could not determine system type", corruptDataException);
            this.errorMessages.add(corruptDataException.getMessage());
            return;
        }
        catch (DataUnavailable dataUnavailable) {
            logger.log(Level.SEVERE, "Could not determine system type", dataUnavailable);
            this.errorMessages.add(dataUnavailable.getMessage());
            return;
        }
        Iterator iterator = image.getAddressSpaces();
        while (iterator.hasNext()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)iterator.next();
            Iterator iterator2 = imageAddressSpace.getProcesses();
            while (iterator2.hasNext()) {
                ImageProcess imageProcess = (ImageProcess)iterator2.next();
                try {
                    ImageModule imageModule = imageProcess.getExecutable();
                    this.moduleNames.add(imageModule.getName());
                    Iterator iterator3 = imageProcess.getLibraries();
                    while (iterator3.hasNext()) {
                        ImageModule imageModule2 = (ImageModule)iterator3.next();
                        String string = null;
                        try {
                            if (bl) {
                                string = imageModule2.getName();
                                int n = string.indexOf(".a(");
                                if (n != -1 && string.lastIndexOf(41) == string.length() - 1) {
                                    string = string.substring(0, n + 2);
                                }
                            } else {
                                string = imageModule2.getName();
                            }
                            logger.fine("Module : " + string);
                            if (this.moduleNames.contains(string)) continue;
                            this.moduleNames.add(string);
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "Error getting module name", exception);
                        }
                    }
                }
                catch (DataUnavailable dataUnavailable) {
                    logger.log(Level.WARNING, "Error getting library list", dataUnavailable);
                    this.errorMessages.add(dataUnavailable.getMessage());
                }
                catch (CorruptDataException corruptDataException) {
                    logger.log(Level.WARNING, "Error getting library list", corruptDataException);
                    this.errorMessages.add(corruptDataException.getMessage());
                }
            }
        }
    }
}

