/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.j9ddr.libraries.DDRLibraryAdapter;
import com.ibm.j9ddr.libraries.DTFJLibraryAdapter;
import com.ibm.j9ddr.libraries.Footer;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import com.ibm.j9ddr.libraries.MonitoredFileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LibraryCollector {
    static final String LOGGER_NAME = "com.ibm.j9ddr.libraries";
    public static final String PUBLIC_LOGGER_NAME = "com.ibm.j9ddr.libraries.public";
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private static final Logger publicLogger = Logger.getLogger("com.ibm.j9ddr.libraries.public");
    private static final byte[] FOOTER_MAGIC_BYTES = new byte[]{30, -81, 16, -83};
    private Footer footer = null;
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private long start = 0L;
    private final ArrayList<File> searchPath = new ArrayList();

    public static void main(String[] stringArray) {
        LibraryCollector libraryCollector = new LibraryCollector();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        consoleHandler.setFormatter(simpleFormatter);
        Logger logger = Logger.getLogger(PUBLIC_LOGGER_NAME);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.FINEST);
        CollectorResult collectorResult = libraryCollector.collectLibrariesFor(stringArray[0], stringArray[1]);
        System.out.println("Collection completed with result : " + collectorResult.name());
    }

    public CollectorResult collectLibrariesFor(String string, String string2) {
        return this.collectLibrariesFor(string, CollectionType.valueOf(string2));
    }

    public CollectorResult collectLibrariesFor(String string, CollectionType collectionType) {
        File file = new File(string);
        if (file.exists()) {
            if (LibraryCollector.areLibrariesPresent(file)) {
                return CollectorResult.COMPLETE_ALREADY_PRESENT;
            }
            return this.collectLibrariesFor(file, collectionType);
        }
        throw new IllegalArgumentException("The core file specified at " + string + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areLibrariesPresent(File file) {
        int n;
        logger.fine("Checking to see if the libraries have already been collected");
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(randomAccessFile.length() - (long)FOOTER_MAGIC_BYTES.length);
            byte[] byArray = new byte[FOOTER_MAGIC_BYTES.length];
            randomAccessFile.read(byArray);
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == FOOTER_MAGIC_BYTES[n]) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            publicLogger.log(Level.FINE, "Could not check core file library collection status", exception);
            n = 0;
            return n != 0;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    publicLogger.log(Level.FINE, "Could not close core file", exception);
                }
            }
        }
        return true;
    }

    private void writeFooter(File file) {
        try {
            MonitoredFileOutputStream monitoredFileOutputStream = new MonitoredFileOutputStream(file, true);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(monitoredFileOutputStream);
            objectOutputStream.writeObject(this.footer);
            objectOutputStream.flush();
            logger.fine("Footer size : " + monitoredFileOutputStream.getBytesWritten());
            monitoredFileOutputStream.write(monitoredFileOutputStream.getBytesWrittenAsArray());
            monitoredFileOutputStream.write(FOOTER_MAGIC_BYTES);
            monitoredFileOutputStream.flush();
            monitoredFileOutputStream.close();
            if (logger.isLoggable(Level.FINEST)) {
                FileOutputStream fileOutputStream = new FileOutputStream("footer.ser");
                ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(fileOutputStream);
                objectOutputStream2.writeObject(this.footer);
                objectOutputStream2.close();
            }
        }
        catch (IOException iOException) {
            publicLogger.log(Level.FINE, "Could not write out collection footer", iOException);
        }
        logger.finer(this.footer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectorResult collectLibrariesFor(File file, CollectionType collectionType) {
        LibraryAdapter libraryAdapter = LibraryCollector.getAdapterForCollectionType(collectionType);
        if (libraryAdapter.isLibraryCollectionRequired(file)) {
            ArrayList<String> arrayList = libraryAdapter.getLibraryList(file);
            this.createSearchPathForLibraries(arrayList);
            this.footer = new Footer(arrayList.size());
            for (String object : libraryAdapter.getErrorMessages()) {
                this.footer.addErrorMessage(object);
            }
            Object object = null;
            try {
                object = new RandomAccessFile(file, "rw");
                this.start = ((RandomAccessFile)object).length();
                ((RandomAccessFile)object).seek(this.start);
                for (String string : arrayList) {
                    int n = this.appendLibraryToCoreFile(string, (RandomAccessFile)object);
                    if (n != 0) {
                        this.footer.addEntry(string, n, this.start);
                    }
                    this.start += (long)n;
                }
                ((RandomAccessFile)object).close();
                this.writeFooter(file);
            }
            catch (FileNotFoundException iOException) {
                publicLogger.log(Level.FINE, "Could not find core file", iOException);
            }
            catch (IOException iOException) {
                publicLogger.log(Level.FINE, "Error writing libraries", iOException);
            }
            finally {
                if (object != null) {
                    try {
                        ((RandomAccessFile)object).close();
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "Could not close core file output stream", iOException);
                    }
                }
            }
            if (this.footer.getErrorMessages().length == 0) {
                return CollectorResult.COMPLETE;
            }
            return CollectorResult.COMPLETE_ERRORS;
        }
        publicLogger.fine("This core file is not identified as requiring library collection");
        return CollectorResult.COMPLETE_NOT_REQUIRED;
    }

    private static LibraryAdapter getAdapterForCollectionType(CollectionType collectionType) {
        switch (collectionType) {
            case DTFJ: {
                logger.fine("Using DTFJ library adaptor");
                return new DTFJLibraryAdapter();
            }
            case DDR: {
                logger.fine("Using DDR library adaptor");
                return new DDRLibraryAdapter();
            }
        }
        logger.fine("Using DDR library adaptor (default)");
        return new DDRLibraryAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int appendLibraryToCoreFile(String string, RandomAccessFile randomAccessFile) {
        int n = 0;
        File file = this.locateLibrary(string);
        FileInputStream fileInputStream = null;
        if (file.exists()) {
            publicLogger.fine("Collecting library: " + string);
            try {
                fileInputStream = new FileInputStream(file);
                int n2 = fileInputStream.read(this.buffer);
                while (n2 != -1) {
                    n += n2;
                    randomAccessFile.write(this.buffer, 0, n2);
                    n2 = fileInputStream.read(this.buffer);
                }
                return n;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (LibraryCollector.isVirtualLibrary(string)) return n;
                String string2 = "Could not add library [" + string + "] as the file does not exist";
                publicLogger.fine(string2);
                this.footer.addErrorMessage(string2);
                return n;
            }
            catch (IOException iOException) {
                this.footer.addErrorMessage("Could not append library : " + iOException.getMessage());
                publicLogger.log(Level.FINE, "Could not collect library", iOException);
                return n;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "Could not close library input stream", iOException);
                    }
                }
            }
        }
        if (LibraryCollector.isVirtualLibrary(string)) return n;
        String string3 = "Could not add library [" + string + "] as the file does not exist";
        publicLogger.fine(string3);
        this.footer.addErrorMessage(string3);
        return n;
    }

    private static boolean isVirtualLibrary(String string) {
        return string.equals("lib.so") || string.startsWith("linux-gate") || string.startsWith("linux-vdso.so.1") || string.startsWith("linux-vdso32.so.1") || string.startsWith("linux-vdso64.so.1");
    }

    private File locateLibrary(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        for (File file2 : this.searchPath) {
            file = new File(file2, string);
            logger.finer("Searching " + file.getAbsolutePath());
            if (!file.exists()) continue;
            return file;
        }
        return new File(string);
    }

    private void createSearchPathForLibraries(ArrayList<String> arrayList) {
        String string = System.getProperty("java.home") + File.separator + "bin";
        File file = new File(string);
        logger.fine("Adding search path " + file.getAbsolutePath());
        this.searchPath.add(file);
        this.searchPath.add(new File("/lib"));
        this.searchPath.add(new File("/lib64"));
        this.searchPath.add(new File("/usr/lib"));
        this.searchPath.add(new File("/usr/lib64"));
        this.searchPath.add(new File("/usr/local/lib"));
        this.searchPath.add(new File("/usr/local/lib64"));
        File file2 = null;
        for (String string2 : arrayList) {
            file2 = new File(string2);
            File file3 = file2.getParentFile();
            if (file3 == null || !file3.isDirectory() || this.searchPath.contains(file3)) continue;
            logger.fine("Adding search path " + file3.getAbsolutePath());
            this.searchPath.add(file3);
        }
    }

    public static enum CollectionType {
        DTFJ,
        DDR;

    }

    public static enum CollectorResult {
        COMPLETE_NOT_REQUIRED,
        COMPLETE_ALREADY_PRESENT,
        COMPLETE_ERRORS,
        COMPLETE;

    }
}

