/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.HashTable_V1;
import com.ibm.j9ddr.vm29.j9.IHashTable;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class HashTable<StructType extends AbstractPointer>
implements IHashTable<StructType> {
    protected J9HashTablePointer _table;
    protected Class<StructType> _structType;
    protected HashEqualFunction<StructType> _equalFn;
    protected HashFunction<StructType> _hashFn;
    protected HashComparatorFunction<StructType> _comparatorFn;

    protected HashTable(J9HashTablePointer j9HashTablePointer, Class<StructType> clazz, HashEqualFunction<StructType> hashEqualFunction, HashFunction<StructType> hashFunction, HashComparatorFunction<StructType> hashComparatorFunction) throws CorruptDataException {
        this._table = j9HashTablePointer;
        this._structType = clazz;
        this._comparatorFn = hashComparatorFunction;
        this._equalFn = hashEqualFunction;
        this._hashFn = hashFunction;
    }

    public static <T extends AbstractPointer> HashTable<T> fromJ9HashTable(J9HashTablePointer j9HashTablePointer, boolean bl, Class<T> clazz, HashEqualFunction<T> hashEqualFunction, HashFunction<T> hashFunction) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new HashTable_V1<T>(j9HashTablePointer, bl, clazz, hashEqualFunction, hashFunction);
    }

    public static <T extends AbstractPointer> HashTable<T> fromJ9HashTable(J9HashTablePointer j9HashTablePointer, boolean bl, Class<T> clazz, HashFunction<T> hashFunction, HashComparatorFunction<T> hashComparatorFunction) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new HashTable_V1<T>(j9HashTablePointer, bl, clazz, hashFunction, hashComparatorFunction);
    }

    @Override
    public abstract String getTableName();

    @Override
    public abstract long getCount();

    public abstract StructType find(StructType var1) throws CorruptDataException;

    @Override
    public abstract SlotIterator<StructType> iterator();

    static interface HashComparatorFunction<StructType extends AbstractPointer> {
        public int compare(StructType var1, StructType var2) throws CorruptDataException;
    }

    public static interface HashFunction<StructType> {
        public UDATA hash(StructType var1) throws CorruptDataException;
    }

    public static interface HashEqualFunction<StructType> {
        public boolean equal(StructType var1, StructType var2) throws CorruptDataException;
    }
}

