/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.structure.CPULoadEntry;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=CPULoadEntry.class)
public class CPULoadEntryPointer
extends StructurePointer {
    public static final CPULoadEntryPointer NULL = new CPULoadEntryPointer(0L);

    protected CPULoadEntryPointer(long l) {
        super(l);
    }

    public static CPULoadEntryPointer cast(AbstractPointer abstractPointer) {
        return CPULoadEntryPointer.cast(abstractPointer.getAddress());
    }

    public static CPULoadEntryPointer cast(UDATA uDATA) {
        return CPULoadEntryPointer.cast(uDATA.longValue());
    }

    public static CPULoadEntryPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new CPULoadEntryPointer(l);
    }

    @Override
    public CPULoadEntryPointer add(long l) {
        return CPULoadEntryPointer.cast(this.address + CPULoadEntry.SIZEOF * l);
    }

    @Override
    public CPULoadEntryPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public CPULoadEntryPointer addOffset(long l) {
        return CPULoadEntryPointer.cast(this.address + l);
    }

    @Override
    public CPULoadEntryPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public CPULoadEntryPointer sub(long l) {
        return CPULoadEntryPointer.cast(this.address - CPULoadEntry.SIZEOF * l);
    }

    @Override
    public CPULoadEntryPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public CPULoadEntryPointer subOffset(long l) {
        return CPULoadEntryPointer.cast(this.address - l);
    }

    @Override
    public CPULoadEntryPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public CPULoadEntryPointer untag(long l) {
        return CPULoadEntryPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public CPULoadEntryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return CPULoadEntry.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_jvmSystemOffset_", declaredType="float")
    public float jvmSystem() throws CorruptDataException {
        return this.getFloatAtOffset(CPULoadEntry._jvmSystemOffset_);
    }

    public FloatPointer jvmSystemEA() throws CorruptDataException {
        return FloatPointer.cast(this.nonNullFieldEA(CPULoadEntry._jvmSystemOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_jvmUserOffset_", declaredType="float")
    public float jvmUser() throws CorruptDataException {
        return this.getFloatAtOffset(CPULoadEntry._jvmUserOffset_);
    }

    public FloatPointer jvmUserEA() throws CorruptDataException {
        return FloatPointer.cast(this.nonNullFieldEA(CPULoadEntry._jvmUserOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_machineTotalOffset_", declaredType="float")
    public float machineTotal() throws CorruptDataException {
        return this.getFloatAtOffset(CPULoadEntry._machineTotalOffset_);
    }

    public FloatPointer machineTotalEA() throws CorruptDataException {
        return FloatPointer.cast(this.nonNullFieldEA(CPULoadEntry._machineTotalOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
    public IDATA ticks() throws CorruptDataException {
        return new I64(this.getLongAtOffset(CPULoadEntry._ticksOffset_));
    }

    public IDATAPointer ticksEA() throws CorruptDataException {
        return IDATAPointer.cast(this.nonNullFieldEA(CPULoadEntry._ticksOffset_));
    }
}

