/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.portable.ClassRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.LongPrimitiveArrayRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.ObjectArrayRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.ObjectRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpClassCache;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpHeader;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import com.ibm.jvm.dtfjview.heapdump.portable.PrimitiveArrayRecord;
import java.io.DataOutputStream;
import java.io.IOException;

public class PortableHeapDumpFormatter
extends HeapDumpFormatter {
    public static final String MAGIC_STRING = "portable heap dump";
    public static final int PHD_VERSION_NUMBER = 6;
    public static final byte START_OF_HEADER_TAG = 1;
    public static final byte END_OF_HEADER_TAG = 2;
    public static final byte START_OF_DUMP_TAG = 2;
    public static final byte END_OF_DUMP_TAG = 3;
    public static final byte HASHCODE_RANDOM_TAG = 3;
    public static final byte FULL_VERSION_TAG = 4;
    public static final int IS_64_BIT_HEADER_FLAG = 1;
    public static final int ALL_OBJECTS_HASHED_FLAG = 2;
    public static final int IS_J9_HEADER_FLAG = 4;
    public static final byte CLASS_RECORD_TAG = 6;
    public static final byte SHORT_OBJECT_RECORD_TAG = -128;
    public static final byte MEDIUM_OBJECT_RECORD_TAG = 64;
    public static final byte LONG_OBJECT_RECORD_TAG = 4;
    public static final byte OBJECT_ARRAY_RECORD_TAG = 8;
    public static final byte PRIMITIVE_ARRAY_RECORD_TAG = 32;
    public static final byte LONG_PRIMITIVE_ARRAY_RECORD_TAG = 7;
    private final DataOutputStream _out;
    private final PortableHeapDumpClassCache _classCache = new PortableHeapDumpClassCache();
    private final boolean _is32BitHash;
    private long _lastAddress = 0L;
    private boolean _closed = false;

    public PortableHeapDumpFormatter(DataOutputStream dataOutputStream, String string, boolean bl, boolean bl2) throws IOException {
        super(string, bl);
        this._out = dataOutputStream;
        this._is32BitHash = bl2;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        PortableHeapDumpHeader portableHeapDumpHeader = new PortableHeapDumpHeader(this._version, this._is64Bit, this._is32BitHash);
        portableHeapDumpHeader.writeHeapDump(this._out);
    }

    private void checkClosed() {
        if (this._closed) {
            throw new UnsupportedOperationException("Dump is closed");
        }
    }

    @Override
    public void addClass(long l, String string, long l2, int n, long l3, int n2, ReferenceIterator referenceIterator) throws IOException {
        this.checkClosed();
        ClassRecord classRecord = new ClassRecord(l, this._lastAddress, string, l2, l3, n2, this._is64Bit, PortableHeapDumpFormatter.filterNullReferences(referenceIterator), this._is32BitHash);
        classRecord.writeHeapDump(this._out);
        this._lastAddress = l;
    }

    @Override
    public void addObject(long l, long l2, String string, int n, int n2, ReferenceIterator referenceIterator) throws IOException {
        ObjectRecord objectRecord = ObjectRecord.getObjectRecord(l, this._lastAddress, l2, n2, PortableHeapDumpFormatter.filterNullReferences(referenceIterator), this._classCache, this._is64Bit, this._is32BitHash);
        objectRecord.writeHeapDump(this._out);
        this._lastAddress = l;
    }

    @Override
    public void addObjectArray(long l, long l2, String string, long l3, String string2, long l4, int n, int n2, ReferenceIterator referenceIterator) throws IOException {
        ObjectArrayRecord objectArrayRecord = new ObjectArrayRecord(l, this._lastAddress, l3, n2, n, PortableHeapDumpFormatter.filterNullReferences(referenceIterator), this._is64Bit, l4, this._is32BitHash);
        objectArrayRecord.writeHeapDump(this._out);
        this._lastAddress = l;
    }

    @Override
    public void addPrimitiveArray(long l, long l2, int n, long l3, int n2, int n3) throws IOException, IllegalArgumentException {
        PortableHeapDumpRecord portableHeapDumpRecord;
        if (this._is32BitHash) {
            portableHeapDumpRecord = n2 == 0 ? new PrimitiveArrayRecord(l, this._lastAddress, n, n3, n2, this._is64Bit, l3, this._is32BitHash) : new LongPrimitiveArrayRecord(l, this._lastAddress, n, n3, n2, this._is64Bit, l3, this._is32BitHash);
            portableHeapDumpRecord = new PrimitiveArrayRecord(l, this._lastAddress, n, n3, n2, this._is64Bit, l3, this._is32BitHash);
        } else {
            portableHeapDumpRecord = new PrimitiveArrayRecord(l, this._lastAddress, n, n3, n2, this._is64Bit, l3, this._is32BitHash);
        }
        ((PortableHeapDumpRecord)portableHeapDumpRecord).writeHeapDump(this._out);
        this._lastAddress = l;
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        this._out.writeByte(3);
        this._out.close();
    }

    private static ReferenceIterator filterNullReferences(final ReferenceIterator referenceIterator) {
        return new ReferenceIterator(){
            private Long next;

            @Override
            public boolean hasNext() {
                while (this.next == null && referenceIterator.hasNext()) {
                    Long l = referenceIterator.next();
                    if (l == 0L) continue;
                    this.next = l;
                }
                return this.next != null;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    return null;
                }
                Long l = this.next;
                this.next = null;
                return l;
            }

            @Override
            public void reset() {
                referenceIterator.reset();
                this.next = null;
            }
        };
    }
}

