/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.FlagStructureList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.stream.FileImageInputStream;

public final class ClassGenerator {
    private boolean badOptions = false;
    private String blobFile = null;
    private boolean helpRequested = false;
    private File outDir = null;
    private boolean verbose = false;

    private static void checkAndFilterFields(StructureReader structureReader) {
        boolean bl = false;
        for (StructureReader.StructureDescriptor structureDescriptor : structureReader.getStructures()) {
            Iterator<StructureReader.FieldDescriptor> iterator = structureDescriptor.getFields().iterator();
            while (iterator.hasNext()) {
                StructureReader.FieldDescriptor fieldDescriptor = iterator.next();
                if (fieldDescriptor.isRequired()) {
                    if (fieldDescriptor.isPresent()) continue;
                    System.out.printf("Missing required field: %s.%s%n", structureDescriptor.getName(), fieldDescriptor.getName());
                    bl = true;
                    continue;
                }
                if (fieldDescriptor.isOptional()) continue;
                iterator.remove();
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    private static void duplicateOption(String string) {
        System.out.printf("Duplicate option: %s.%n", string);
    }

    public static void main(String ... stringArray) {
        ClassGenerator classGenerator = new ClassGenerator();
        classGenerator.configure(stringArray);
        classGenerator.run();
    }

    private static StructureReader readBlob(String string) throws IOException {
        File file = new File(string);
        final class BlobStream
        extends FileImageInputStream {
            BlobStream(File file) throws IOException {
                super(file);
            }
        }
        try (BlobStream blobStream = new BlobStream(file);){
            StructureReader structureReader = new StructureReader(blobStream);
            return structureReader;
        }
    }

    private ClassGenerator() {
    }

    private void configure(String[] stringArray) {
        Pattern pattern = Pattern.compile("--blob=(.+)");
        Pattern pattern2 = Pattern.compile("--out=(.+)");
        for (String string : stringArray) {
            String string2;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
                if (this.blobFile == null) {
                    this.blobFile = string2;
                    continue;
                }
                ClassGenerator.duplicateOption(string);
                this.badOptions = true;
                continue;
            }
            if ("--debug".equals(string)) {
                this.verbose = true;
                continue;
            }
            if ("--help".equals(string)) {
                this.helpRequested = true;
                continue;
            }
            matcher = pattern2.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
                if (this.outDir == null) {
                    this.outDir = new File(string2);
                    continue;
                }
                ClassGenerator.duplicateOption(string);
                this.badOptions = true;
                continue;
            }
            System.out.printf("Invalid option: %s.%n", string);
            this.badOptions = true;
        }
    }

    private void run() {
        if (this.badOptions || this.helpRequested || this.blobFile == null || this.outDir == null) {
            System.out.printf("Usage: java %s [options]%n", this.getClass().getName());
            System.out.printf("  options:%n", new Object[0]);
            System.out.printf("    --blob=<blob file>%n", new Object[0]);
            System.out.printf("    --debug%n", new Object[0]);
            System.out.printf("    --help%n", new Object[0]);
            System.out.printf("    --out=<output directory>%n", new Object[0]);
        } else {
            try {
                StructureReader structureReader = ClassGenerator.readBlob(this.blobFile);
                ClassGenerator.checkAndFilterFields(structureReader);
                this.writeTo(structureReader, this.outDir);
            }
            catch (IOException iOException) {
                System.out.printf("Can't read blob: %s%n", iOException.getLocalizedMessage());
                System.exit(1);
            }
        }
    }

    private void save(byte[] byArray, File file, String string) throws IOException {
        File file2 = new File(file, string + ".class");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.write(byArray);
            if (this.verbose) {
                System.out.printf("Wrote: %s%n", file2.getPath());
            }
        }
    }

    private void writeTo(StructureReader structureReader, File file) {
        File file2 = new File(file, structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_SLASH_NAME));
        File file3 = new File(file, structureReader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME));
        file2.mkdirs();
        file3.mkdirs();
        for (StructureReader.StructureDescriptor structureDescriptor : structureReader.getStructures()) {
            String string = structureDescriptor.getName();
            try {
                byte[] byArray;
                if (FlagStructureList.isFlagsStructure(string)) {
                    byArray = structureReader.getPointerClassBytes(string);
                    this.save(byArray, file2, string);
                    continue;
                }
                byArray = structureReader.getStructureClassBytes(string);
                this.save(byArray, file3, string);
                string = structureDescriptor.getPointerName();
                byArray = structureReader.getPointerClassBytes(string);
                this.save(byArray, file2, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.printf("Can't generate %s: %s%n", string, classNotFoundException.getLocalizedMessage());
                System.exit(2);
            }
            catch (IOException iOException) {
                System.out.printf("Can't save %s: %s%n", string, iOException.getLocalizedMessage());
                System.exit(3);
            }
        }
    }
}

