/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I32
extends IDATA {
    public static final int SIZEOF = 4;
    public static final long MASK = 0xFFFFFFFFL;
    public static final I32 MIN = new I32(0x80000000L);
    public static final I32 MAX = MIN.sub(Integer.MAX_VALUE);

    public I32(long l) {
        super(l & 0xFFFFFFFFL);
    }

    public I32(Scalar scalar) {
        super(scalar);
    }

    public I32 add(long l) {
        return new I32(this.data + l);
    }

    @Override
    public I32 add(U8 u8) {
        return this.add(new I32(u8));
    }

    @Override
    public I32 add(U16 u16) {
        return this.add(new I32(u16));
    }

    @Override
    public I32 add(U32 u32) {
        return new I32(this).add(u32);
    }

    @Override
    public boolean eq(U32 u32) {
        return new U32(this).eq(u32);
    }

    public U64 add(U64 u64) {
        return new U64(this).add(u64);
    }

    public boolean eq(U64 u64) {
        return new U64(this).eq(u64);
    }

    @Override
    public UDATA add(UDATA uDATA) {
        return new UDATA(this).add(uDATA);
    }

    @Override
    public boolean eq(UDATA uDATA) {
        return new UDATA(this).eq(uDATA);
    }

    public I32 add(I8 i8) {
        return this.add(new I32(i8));
    }

    public I32 add(I16 i16) {
        return this.add(new I32(i16));
    }

    public I32 add(I32 i32) {
        return new I32(this.data + i32.data);
    }

    @Override
    public I64 add(I64 i64) {
        return new I64(this).add(i64);
    }

    @Override
    public IDATA add(IDATA iDATA) {
        return new IDATA(this).add(iDATA);
    }

    @Override
    public I32 sub(long l) {
        return new I32(this.data - l);
    }

    @Override
    public I32 sub(U8 u8) {
        return this.sub(new I32(u8));
    }

    @Override
    public I32 sub(U16 u16) {
        return this.sub(new I32(u16));
    }

    @Override
    public I32 sub(U32 u32) {
        return new I32(this).sub(u32);
    }

    public U64 sub(U64 u64) {
        return new U64(this).sub(u64);
    }

    @Override
    public UDATA sub(UDATA uDATA) {
        return new UDATA(this).sub(uDATA);
    }

    public I32 sub(I8 i8) {
        return this.sub(new I32(i8));
    }

    public I32 sub(I16 i16) {
        return this.sub(new I32(i16));
    }

    public I32 sub(I32 i32) {
        return new I32(this.data - i32.data);
    }

    @Override
    public I64 sub(I64 i64) {
        return new I64(this).sub(i64);
    }

    @Override
    public IDATA sub(IDATA iDATA) {
        return new IDATA(this).sub(iDATA);
    }

    @Override
    public int intValue() {
        return (int)this.data;
    }

    @Override
    public long longValue() {
        return (int)this.data;
    }

    @Override
    public I32 bitOr(int n) {
        return new I32(this.data | (long)n);
    }

    public I32 bitOr(long l) {
        return new I32(this.data | l);
    }

    @Override
    public I32 bitOr(U8 u8) {
        return this.bitOr(new I32(u8));
    }

    @Override
    public I32 bitOr(U16 u16) {
        return this.bitOr(new I32(u16));
    }

    @Override
    public I32 bitOr(U32 u32) {
        return new I32(this).bitOr(u32);
    }

    public U64 bitOr(U64 u64) {
        return new U64(this).bitOr(u64);
    }

    @Override
    public UDATA bitOr(UDATA uDATA) {
        return new UDATA(this).bitOr(uDATA);
    }

    public I32 bitOr(I8 i8) {
        return this.bitOr(new I32(i8));
    }

    public I32 bitOr(I16 i16) {
        return this.bitOr(new I32(i16));
    }

    public I32 bitOr(I32 i32) {
        return new I32(this.data | i32.data);
    }

    @Override
    public I64 bitOr(I64 i64) {
        return new I64(this).bitOr(i64);
    }

    @Override
    public IDATA bitOr(IDATA iDATA) {
        return new IDATA(this).bitOr(iDATA);
    }

    @Override
    public I32 bitXor(int n) {
        return new I32(this.data ^ (long)n);
    }

    @Override
    public I32 bitXor(long l) {
        return new I32(this.data ^ l);
    }

    @Override
    public I32 bitXor(Scalar scalar) {
        return this.bitXor(new I32(scalar));
    }

    public I32 bitXor(I32 i32) {
        return new I32(this.data ^ i32.data);
    }

    public U32 bitXor(U32 u32) {
        return new U32(this).bitXor(u32);
    }

    @Override
    public UDATA bitXor(UDATA uDATA) {
        return new UDATA(this).bitXor(uDATA);
    }

    @Override
    public IDATA bitXor(IDATA iDATA) {
        return new IDATA(this).bitXor(iDATA);
    }

    @Override
    public U64 bitXor(U64 u64) {
        return new U64(this).bitXor(u64);
    }

    @Override
    public I64 bitXor(I64 i64) {
        return new I64(this).bitXor(i64);
    }

    @Override
    public I32 bitAnd(int n) {
        return new I32(this.data & (long)n);
    }

    public I32 bitAnd(long l) {
        return new I32(this.data & l);
    }

    @Override
    public I32 bitAnd(U8 u8) {
        return this.bitAnd(new I32(u8));
    }

    @Override
    public I32 bitAnd(U16 u16) {
        return this.bitAnd(new I32(u16));
    }

    @Override
    public I32 bitAnd(U32 u32) {
        return new I32(this).bitAnd(u32);
    }

    public U64 bitAnd(U64 u64) {
        return new U64(this).bitAnd(u64);
    }

    @Override
    public UDATA bitAnd(UDATA uDATA) {
        return new UDATA(this).bitAnd(uDATA);
    }

    public I32 bitAnd(I8 i8) {
        return this.bitAnd(new I32(i8));
    }

    public I32 bitAnd(I16 i16) {
        return this.bitAnd(new I32(i16));
    }

    public I32 bitAnd(I32 i32) {
        return new I32(this.data & i32.data);
    }

    @Override
    public I64 bitAnd(I64 i64) {
        return new I64(this).bitAnd(i64);
    }

    @Override
    public IDATA bitAnd(IDATA iDATA) {
        return new IDATA(this).bitAnd(iDATA);
    }

    @Override
    public I32 leftShift(int n) {
        return new I32(this.data << n);
    }

    @Override
    public I32 rightShift(int n) {
        return new I32(this.intValue() >> n);
    }

    @Override
    public I32 bitNot() {
        return new I32(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public I32 mult(int n) {
        return new I32(this.data * (long)n);
    }

    @Override
    public int sizeof() {
        return 4;
    }
}

