/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class WeakValueMap<K, V> {
    private final Map<K, ReferenceType<K, V>> map = new HashMap<K, ReferenceType<K, V>>();
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();

    public void put(K k, V v) {
        this.cleanupTax();
        this.map.put(k, new ReferenceType<K, V>(k, v, this.refQueue));
    }

    public V get(K k) {
        this.cleanupTax();
        ReferenceType<K, V> referenceType = this.map.get(k);
        if (referenceType != null) {
            return (V)referenceType.get();
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    private void cleanupTax() {
        ReferenceType referenceType = null;
        while ((referenceType = (ReferenceType)this.refQueue.poll()) != null) {
            this.map.remove(referenceType.key);
        }
    }

    private static class ReferenceType<K, V>
    extends SoftReference<V> {
        public final K key;

        public ReferenceType(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }
    }
}

