/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public class DumpReaderAddressSpace
extends CommonAddressSpace {
    private DumpReader _reader;

    public DumpReaderAddressSpace(MemoryRange[] memoryRangeArray, DumpReader dumpReader, boolean bl, boolean bl2) {
        super(memoryRangeArray, bl, bl2);
        this._reader = dumpReader;
    }

    @Override
    public boolean isExecutable(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        return memoryRange.isExecutable();
    }

    @Override
    public boolean isReadOnly(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        return memoryRange.isReadOnly();
    }

    @Override
    public boolean isShared(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        return memoryRange.isShared();
    }

    @Override
    public int getBytesAt(int n, long l, byte[] byArray) throws MemoryAccessException {
        int n2;
        int n3;
        for (n2 = 0; n2 < byArray.length; n2 += n3) {
            long l2 = l + ((long)n2 & 0xFFFFFFFFFFFFFFFFL);
            MemoryRange memoryRange = this._residentRange(n, l2);
            long l3 = l2 - memoryRange.getVirtualAddress();
            long l4 = memoryRange.getSize() - l3;
            n3 = l4 > Integer.MAX_VALUE ? byArray.length - n2 : Math.min((int)l4, byArray.length - n2);
            try {
                Object object;
                if (memoryRange.isInCoreFile()) {
                    this._reader.seek(memoryRange.getFileOffset() + l3);
                    object = this._reader.readBytes(n3);
                    System.arraycopy(object, 0, byArray, n2, ((Object)object).length);
                    continue;
                }
                object = memoryRange.getLibraryReader();
                if (object != null) {
                    ((DumpReader)object).seek(l3);
                    byte[] byArray2 = ((DumpReader)object).readBytes(n3);
                    System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                    continue;
                }
                throw new MemoryAccessException(n, l2, "Cannot read memory external to core file");
            }
            catch (IOException iOException) {
                throw new MemoryAccessException(n, l2, "IOException reading core file: " + iOException.getMessage());
            }
        }
        return n2;
    }

    @Override
    public long getLongAt(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        if (null != memoryRange) {
            if (memoryRange.isInCoreFile()) {
                long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                try {
                    this._reader.seek(l2);
                    return this._reader.readLong();
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            return super.getLongAt(n, l);
        }
        throw new MemoryAccessException(n, l);
    }

    @Override
    public int getIntAt(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        if (null != memoryRange) {
            if (memoryRange.isInCoreFile()) {
                long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                try {
                    this._reader.seek(l2);
                    return this._reader.readInt();
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            return super.getIntAt(n, l);
        }
        throw new MemoryAccessException(n, l);
    }

    @Override
    public short getShortAt(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        if (null != memoryRange) {
            if (memoryRange.isInCoreFile()) {
                long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                try {
                    this._reader.seek(l2);
                    return this._reader.readShort();
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            return super.getShortAt(n, l);
        }
        throw new MemoryAccessException(n, l);
    }

    @Override
    public byte getByteAt(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = this._residentRange(n, l);
        if (null != memoryRange) {
            if (memoryRange.isInCoreFile()) {
                long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                try {
                    this._reader.seek(l2);
                    return this._reader.readByte();
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            return super.getByteAt(n, l);
        }
        throw new MemoryAccessException(n, l);
    }
}

