/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.util.Msg;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class SharedClassURLHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLHelper {
    private boolean minimizeUpdateChecks;
    private Set<String> jarFileNameCache = null;
    public static final boolean MINIMIZE_ENABLED = true;

    SharedClassURLHelperImpl(ClassLoader classLoader, int n, boolean bl, boolean bl2) {
        this.initialize(classLoader, n, bl, bl2);
        this.initializeShareableClassloader(classLoader);
    }

    private static native void init();

    private boolean newJarFileCheck(URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getFile();
        boolean bl = false;
        if (string.equalsIgnoreCase("jar")) {
            bl = true;
        } else if (string.equalsIgnoreCase("file") && (string2.endsWith(".jar") || string2.endsWith(".zip") || string2.contains("!/") || string2.contains("!\\"))) {
            bl = true;
        }
        if (null == this.jarFileNameCache) {
            this.jarFileNameCache = ConcurrentHashMap.newKeySet();
        }
        if (bl) {
            return this.jarFileNameCache.add(string2);
        }
        return false;
    }

    private native boolean findSharedClassImpl3(int var1, String var2, String var3, ClassLoader var4, URL var5, boolean var6, boolean var7, byte[] var8, boolean var9, boolean var10);

    private native boolean storeSharedClassImpl3(int var1, String var2, ClassLoader var3, URL var4, Class<?> var5, boolean var6, boolean var7, byte[] var8);

    @Override
    public boolean setMinimizeUpdateChecks() {
        this.minimizeUpdateChecks = true;
        return true;
    }

    @Override
    public byte[] findSharedClass(URL uRL, String string) {
        return this.findSharedClass(null, uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findSharedClass(String string, URL uRL, String string2) {
        boolean bl;
        boolean bl2;
        Object object;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (uRL == null) {
            this.printVerboseError(Msg.getString("K05b3"));
            return null;
        }
        if (string2 == null) {
            this.printVerboseError(Msg.getString("K05a1"));
            return null;
        }
        SharedClassFilter sharedClassFilter = this.getSharingFilter();
        if (sharedClassFilter != null) {
            object = this;
            synchronized (object) {
                bl2 = sharedClassFilter.acceptFind(string2);
                bl = nativeFlags[0] == 0 ? sharedClassFilter.acceptStore(string2) : true;
            }
        } else {
            bl2 = true;
            bl = true;
        }
        if (!this.validateURL((URL)(object = this.convertJarURL(uRL)), false)) {
            return null;
        }
        byte[] byArray = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean bl3 = this.minimizeUpdateChecks ? false : this.newJarFileCheck((URL)object);
        boolean bl4 = this.findSharedClassImpl3(this.id, string, string2, classLoader, (URL)object, bl2, bl, byArray, bl3, this.minimizeUpdateChecks);
        if (!bl4) {
            return null;
        }
        return byArray;
    }

    @Override
    public boolean storeSharedClass(URL uRL, Class<?> clazz) {
        return this.storeSharedClass(null, uRL, clazz);
    }

    @Override
    public boolean storeSharedClass(String string, URL uRL, Class<?> clazz) {
        if (!this.canStore) {
            return false;
        }
        if (uRL == null) {
            this.printVerboseError(Msg.getString("K05b4"));
            return false;
        }
        if (clazz == null) {
            this.printVerboseError(Msg.getString("K05a3"));
            return false;
        }
        URL uRL2 = this.convertJarURL(uRL);
        if (!this.validateURL(uRL2, false)) {
            return false;
        }
        ClassLoader classLoader = this.getClassLoader();
        if (!this.validateClassLoader(classLoader, clazz)) {
            return false;
        }
        boolean bl = this.minimizeUpdateChecks ? false : this.newJarFileCheck(uRL2);
        return this.storeSharedClassImpl3(this.id, string, classLoader, uRL2, clazz, bl, this.minimizeUpdateChecks, nativeFlags);
    }

    @Override
    String getHelperType() {
        return "SharedClassURLHelper";
    }

    static {
        SharedClassURLHelperImpl.init();
    }
}

