/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.J9UnmodifiableClass;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.reflect.misc.ReflectUtil;

@J9UnmodifiableClass
final class J9VMInternals {
    static final JITHelpers jitHelpers = JITHelpers.getHelpers();
    private static Map exceptions;
    static boolean initialized;
    private static Unsafe unsafe;

    private J9VMInternals() {
    }

    static void threadCompleteInitialization() {
        Thread.currentThread().internalSetContextClassLoader(ClassLoader.getSystemClassLoader());
        VM.booted();
        System.startSNMPAgent();
    }

    private static void completeInitialization() {
        initialized = true;
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        J9VMInternals.threadCompleteInitialization();
    }

    static void initialize(Class<?> clazz) {
        if (null != clazz.initializationLock) {
            Unsafe unsafe = J9VMInternals.unsafe;
            if (null == unsafe) {
                unsafe = J9VMInternals.unsafe = Unsafe.getUnsafe();
            }
            unsafe.ensureClassInitialized(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializationAlreadyFailed(Class clazz) {
        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
        if (exceptions != null) {
            Map map = exceptions;
            synchronized (map) {
                Throwable throwable;
                SoftReference softReference = (SoftReference)exceptions.get(clazz);
                if (softReference != null && (throwable = (Throwable)softReference.get()) != null) {
                    throwable = J9VMInternals.copyThrowable(throwable);
                    noClassDefFoundError.initCause(throwable);
                }
            }
        }
        throw noClassDefFoundError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordInitializationFailure(Class clazz, Throwable throwable) {
        if (initialized) {
            if (exceptions == null) {
                exceptions = new WeakHashMap();
            }
            Map map = exceptions;
            synchronized (map) {
                Throwable throwable2 = throwable;
                if (throwable instanceof ExceptionInInitializerError && (throwable2 = ((ExceptionInInitializerError)throwable).getException()) == null) {
                    throwable2 = throwable;
                }
                exceptions.put(clazz, new SoftReference<Throwable>(J9VMInternals.copyThrowable(throwable2)));
            }
        }
        J9VMInternals.ensureError(throwable);
    }

    private static void ensureError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new ExceptionInInitializerError(throwable);
    }

    private static native Throwable newInstance(Class var0, Class var1);

    private static Throwable cloneThrowable(final Throwable throwable, final HashMap hashMap) {
        return (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Throwable throwable3;
                try {
                    Class clazz = throwable.getClass();
                    throwable3 = J9VMInternals.newInstance(clazz, Object.class);
                    while (clazz != null) {
                        Field[] fieldArray = clazz.getDeclaredFields();
                        for (int i = 0; i < fieldArray.length; ++i) {
                            Object object;
                            if (Modifier.isStatic(fieldArray[i].getModifiers()) || clazz == Throwable.class && fieldArray[i].getName().equals("walkback")) continue;
                            fieldArray[i].setAccessible(true);
                            if (clazz == Throwable.class && fieldArray[i].getName().equals("cause")) {
                                object = throwable3;
                            } else {
                                object = fieldArray[i].get(throwable);
                                if (object instanceof Throwable) {
                                    object = J9VMInternals.copyThrowable((Throwable)object, hashMap);
                                }
                            }
                            fieldArray[i].set(throwable3, object);
                        }
                        clazz = J9VMInternals.getSuperclass(clazz);
                    }
                }
                catch (Throwable throwable2) {
                    throwable3 = new Throwable(Msg.getString("K05c3", throwable2, throwable.toString()));
                }
                return throwable3;
            }
        });
    }

    private static Throwable copyThrowable(Throwable throwable) {
        HashMap hashMap = new HashMap();
        return J9VMInternals.copyThrowable(throwable, hashMap);
    }

    private static Throwable copyThrowable(Throwable throwable, HashMap hashMap) {
        if (hashMap.get(throwable) != null) {
            return throwable;
        }
        hashMap.put(throwable, throwable);
        Throwable throwable2 = J9VMInternals.cloneThrowable(throwable, hashMap);
        throwable2.setStackTrace(throwable.getStackTrace());
        Throwable throwable3 = throwable2;
        for (Throwable throwable4 = throwable.getCause(); throwable4 != null && hashMap.get(throwable4) == null; throwable4 = throwable4.getCause()) {
            hashMap.put(throwable4, throwable4);
            Throwable throwable5 = J9VMInternals.cloneThrowable(throwable4, hashMap);
            throwable5.setStackTrace(throwable4.getStackTrace());
            throwable3.setCause(throwable5);
            throwable3 = throwable5;
        }
        return throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.group.remove(thread);
        }
        finally {
            thread.exit();
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(final Class<?> clazz, ProtectionDomain protectionDomain) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ProtectionDomain[] protectionDomainArray;
            if (protectionDomain == null) {
                protectionDomainArray = new ProtectionDomain[]{};
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
                protectionDomainArray = protectionDomainArray2;
                protectionDomainArray2[0] = protectionDomain;
            }
            ProtectionDomain[] protectionDomainArray3 = protectionDomainArray;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String string = clazz.getPackageName();
                    if (string != null) {
                        securityManager.checkPackageAccess(string);
                    }
                    if (Proxy.isProxyClass(clazz)) {
                        ClassLoader classLoader = clazz.getClassLoaderImpl();
                        ReflectUtil.checkProxyPackageAccess(classLoader, clazz.getInterfaces());
                    }
                    return null;
                }
            }, new AccessControlContext(protectionDomainArray3));
        }
    }

    private static void runFinalize(Object object) {
        try {
            object.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static native StackTraceElement[] getStackTrace(Throwable var0, boolean var1);

    private static native void prepareClassImpl(Class var0);

    static void prepare(Class clazz) {
        if (clazz.initializationLock == null) {
            return;
        }
        J9VMInternals.prepareClassImpl(clazz);
    }

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native Object newInstanceImpl(Class var0) throws IllegalAccessException, InstantiationException;

    static int fastIdentityHashCode(Object object) {
        JITHelpers jITHelpers = jitHelpers;
        if (null == jITHelpers) {
            return J9VMInternals.identityHashCode(object);
        }
        if (jITHelpers.isArray(object)) {
            return J9VMInternals.identityHashCode(object);
        }
        if (jITHelpers.is32Bit()) {
            int n = jITHelpers.getIntFromObject(object, 0L);
            if ((n & com.ibm.oti.vm.VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0) {
                int n2 = n & com.ibm.oti.vm.VM.J9_JAVA_CLASS_MASK;
                return jITHelpers.getIntFromObject(object, jITHelpers.getBackfillOffsetFromJ9Class32(n2));
            }
        } else {
            long l;
            long l2 = l = com.ibm.oti.vm.VM.FJ9OBJECT_SIZE == 4 ? Integer.toUnsignedLong(jITHelpers.getIntFromObject(object, 0L)) : jITHelpers.getLongFromObject(object, 0L);
            if ((l & (long)com.ibm.oti.vm.VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0L) {
                long l3 = l & (long)com.ibm.oti.vm.VM.J9_JAVA_CLASS_MASK;
                return jITHelpers.getIntFromObject(object, jITHelpers.getBackfillOffsetFromJ9Class64(l3));
            }
        }
        return J9VMInternals.identityHashCode(object);
    }

    static native int identityHashCode(Object var0);

    static native Object primitiveClone(Object var0) throws CloneNotSupportedException;

    public static native void dumpString(String var0);

    private static String[] getClassInfoStrings(final Class<?> clazz, String string) {
        String[] stringArray;
        String string2 = "<Bootstrap Loader>";
        String string3 = "<Unknown>";
        if (string == null && (stringArray = clazz.getClassLoader()) != null) {
            string2 = stringArray.toString();
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = null;
                    try {
                        URL uRL;
                        CodeSource codeSource;
                        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                        if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                            string = uRL.toString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return string;
                }
            });
        }
        if (string != null) {
            string3 = string;
        }
        stringArray = new String[]{string3, string2};
        return stringArray;
    }

    public static String formatNoSuchMethod(String string, Class<?> clazz, String string2, Class<?> clazz2, String string3) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            stringArray = J9VMInternals.getClassInfoStrings(clazz, string2);
            stringArray2 = J9VMInternals.getClassInfoStrings(clazz2, string3);
            Object[] objectArray = new String[]{string, stringArray[0], stringArray[1], clazz2.toString(), stringArray2[0], stringArray2[1]};
            return Msg.getString("K0613", "{0} (loaded from {1} by {2}) called from {3} (loaded from {4} by {5}).", objectArray);
        }
        catch (Exception | VirtualMachineError throwable) {
            if (null == stringArray || null == stringArray2) {
                return string;
            }
            try {
                return string + "(loaded from " + stringArray[0] + " by " + stringArray[1] + ") called from " + clazz2.toString() + " (loaded from " + stringArray2[0] + " by " + stringArray2[1] + ")";
            }
            catch (Exception | VirtualMachineError throwable2) {
                return string;
            }
        }
    }

    static final class ClassInitializationLock {
        Class theClass;

        ClassInitializationLock() {
        }
    }
}

