/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.SignalName;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRBaseImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageModule;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J9DDRImageProcess
implements ImageProcess {
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "OPENJ9_JAVA_COMMAND_LINE";
    private static final String LEGACY_JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private final IProcess process;
    private boolean processDataSet;
    private J9RASImageDataFactory.ProcessData j9rasProcessData;
    private String version;
    private WeakReference<Map<Long, Object>> cachedThreads;

    public J9DDRImageProcess(IProcess iProcess) {
        this.process = iProcess;
    }

    public IProcess getIProcess() {
        return this.process;
    }

    public String getCommandLine() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Properties properties = this.getEnvironment();
            String string = properties.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (string != null) {
                return string;
            }
            string = properties.getProperty(LEGACY_JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (string != null) {
                return string;
            }
            return this.process.getCommandLine();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DataUnavailable(dataUnavailableException.getMessage());
        }
    }

    private void checkFailureInfo() {
        if (!this.processDataSet) {
            this.j9rasProcessData = J9RASImageDataFactory.getProcessData(this.process);
            this.processDataSet = true;
        }
    }

    public ImageThread getCurrentThread() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                long l;
                try {
                    l = this.j9rasProcessData.tid();
                }
                catch (DataUnavailable dataUnavailable) {
                    Iterator<? extends IOSThread> iterator = this.process.getThreads().iterator();
                    if (iterator.hasNext()) {
                        IOSThread iOSThread = iterator.next();
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                    return null;
                }
                for (IOSThread iOSThread : this.process.getThreads()) {
                    if (iOSThread.getThreadId() != l) continue;
                    return new J9DDRImageThread(this.process, iOSThread);
                }
                if (l == 0L && this.process.getPlatform() == Platform.ZOS) {
                    for (IOSThread iOSThread : this.process.getThreads()) {
                        Properties properties = iOSThread.getProperties();
                        String string = properties.getProperty("Task Completion Code");
                        if (string == null || string.equals("0x0")) continue;
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                }
                return new J9DDRStubImageThread(this.process, l);
            }
            return null;
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
    }

    public Properties getEnvironment() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    Properties properties;
                    long l = this.j9rasProcessData.getEnvironment();
                    if (this.process.getPlatform() == Platform.WINDOWS && this.j9rasProcessData.version() > 4) {
                        properties = EnvironmentUtils.readEnvironmentStrings(this.process, l);
                    } else {
                        long l2 = this.process.getPointerAt(l);
                        properties = EnvironmentUtils.readEnvironment(this.process, l2);
                    }
                    if (null == properties || 0 == properties.size()) {
                        throw new CorruptDataException("");
                    }
                    return properties;
                }
                catch (CorruptDataException corruptDataException) {
                    return this.process.getEnvironmentVariables();
                }
            }
            return this.process.getEnvironmentVariables();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DataUnavailable(dataUnavailableException.getMessage());
        }
    }

    public ImageModule getExecutable() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        IModule iModule;
        try {
            iModule = this.process.getExecutable();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, corruptDataException));
        }
        if (iModule == null) {
            throw new DataUnavailable("executable not found");
        }
        if (this.process.getPlatform() == Platform.LINUX) {
            String string = this.getExecutablePath();
            if (null == string) {
                return new J9DDRImageModule(this.process, iModule);
            }
            return new J9DDRImageModule(this.process, iModule, string);
        }
        return new J9DDRImageModule(this.process, iModule);
    }

    String getExecutablePath() {
        String string;
        try {
            string = this.getCommandLine();
        }
        catch (Exception exception) {
            return this.getExecutablePathFromSystemProperties();
        }
        int n = string.indexOf(" ");
        String string2 = n != -1 ? string.substring(0, n) : string;
        return string2;
    }

    private String getExecutablePathFromSystemProperties() {
        Iterator<?> iterator = this.getRuntimes();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof JavaRuntime)) continue;
            JavaRuntime javaRuntime = (JavaRuntime)obj;
            try {
                JavaVMInitArgs javaVMInitArgs = javaRuntime.getJavaVMInitArgs();
                Iterator iterator2 = javaVMInitArgs.getOptions();
                Pattern pattern = Pattern.compile("-Djava.home=(.*)");
                while (iterator2.hasNext()) {
                    JavaVMOption javaVMOption;
                    Matcher matcher;
                    Object e = iterator2.next();
                    if (!(e instanceof JavaVMOption) || !(matcher = pattern.matcher((javaVMOption = (JavaVMOption)e).getOptionString())).find()) continue;
                    String string = matcher.group(1);
                    return string + "/bin/java";
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String getID() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    return Long.toString(this.j9rasProcessData.pid());
                }
                catch (DataUnavailable dataUnavailable) {
                    return Long.toString(this.process.getProcessId());
                }
            }
            return Long.toString(this.process.getProcessId());
        }
        catch (CorruptDataException corruptDataException) {
            return "<Unknown>";
        }
    }

    public String toString() {
        try {
            return "ImageProcess: " + this.getID();
        }
        catch (Exception exception) {
            return "ImageProcess";
        }
    }

    public Iterator<?> getLibraries() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Collection<? extends IModule> collection = this.process.getModules();
            ArrayList<J9DDRImageModule> arrayList = new ArrayList<J9DDRImageModule>();
            for (IModule iModule : collection) {
                arrayList.add(new J9DDRImageModule(this.process, iModule));
            }
            return arrayList.iterator();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, corruptDataException));
        }
    }

    public int getPointerSize() {
        return this.process.bytesPerPointer() * 8;
    }

    public Iterator<?> getRuntimes() {
        LinkedList<Object> linkedList;
        block9: {
            linkedList = new LinkedList<Object>();
            try {
                IVMData iVMData = VMDataFactory.getVMData(this.process);
                if (iVMData == null) break block9;
                this.version = iVMData.getVersion();
                Object[] objectArray = new Object[1];
                try {
                    iVMData.bootstrapRelative("view.dtfj.DTFJBootstrapShim", objectArray, this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        iVMData.bootstrap("com.ibm.j9ddr.view.nativert.Bootstrap", objectArray, this);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new Error(classNotFoundException2);
                    }
                }
                if (objectArray[0] != null) {
                    linkedList.add(objectArray[0]);
                }
            }
            catch (IOException iOException) {
                linkedList.add(new J9DDRCorruptData(this.process, "Unsupported JVM level: " + iOException.getMessage()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                linkedList.add(new J9DDRCorruptData(this.process, "Unsupported JVM level"));
            }
            catch (Exception exception) {
                linkedList.add(new J9DDRCorruptData(this.process, exception.getMessage()));
            }
        }
        return linkedList.iterator();
    }

    public String getSignalName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        String string = null;
        int n = this.getSignalNumber();
        if (n != 0) {
            switch (this.process.getPlatform()) {
                case AIX: {
                    string = SignalName.forAIX((int)n);
                    break;
                }
                case LINUX: {
                    string = SignalName.forLinux((int)n);
                    break;
                }
                case OSX: {
                    string = SignalName.forOSX((int)n);
                    break;
                }
                case WINDOWS: {
                    string = SignalName.forWindows((int)n);
                    break;
                }
                case ZOS: {
                    string = SignalName.forZOS((int)n);
                    break;
                }
            }
            if (string == null) {
                string = "Unknown signal number " + n;
            }
        }
        return string;
    }

    public int getSignalNumber() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkFailureInfo();
        try {
            String string = this.j9rasProcessData.gpInfo();
            if (string != null) {
                String[] stringArray;
                switch (this.process.getPlatform()) {
                    case AIX: 
                    case LINUX: 
                    case OSX: {
                        stringArray = new String[]{"Signal_Number"};
                        break;
                    }
                    case WINDOWS: {
                        stringArray = new String[]{"Windows_ExceptionCode", "ExceptionCode"};
                        break;
                    }
                    case ZOS: {
                        stringArray = new String[]{"Signal_Number", "Condition_Message_Number"};
                        break;
                    }
                    default: {
                        stringArray = new String[]{};
                    }
                }
                for (String string2 : stringArray) {
                    int n = (int)J9DDRImageProcess.longByResolvingRawKey(string, string2);
                    if (n == 0) continue;
                    return n;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        try {
            return this.process.getSignalNumber();
        }
        catch (DataUnavailableException dataUnavailableException) {
            return 0;
        }
    }

    private Map<Long, Object> getThreadMap() {
        HashMap<Long, Object> hashMap = null;
        if (this.cachedThreads != null) {
            hashMap = (HashMap<Long, Object>)this.cachedThreads.get();
        }
        if (hashMap == null) {
            Collection<? extends IOSThread> collection;
            long l = -1L;
            try {
                collection = this.process.getThreads();
            }
            catch (CorruptDataException corruptDataException) {
                return Collections.singletonMap(l, new J9DDRCorruptData(this.process, corruptDataException));
            }
            boolean bl = this.process.getPlatform() == Platform.LINUX && collection.size() == 1;
            hashMap = new HashMap<Long, Object>();
            if (bl) {
                try {
                    J9DDRBaseImageThread j9DDRBaseImageThread = (J9DDRBaseImageThread)this.getCurrentThread();
                    if (j9DDRBaseImageThread != null) {
                        hashMap.put(j9DDRBaseImageThread.getThreadId(), j9DDRBaseImageThread);
                    }
                }
                catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRCorruptData(this.process, corruptDataException.getMessage()));
                }
                catch (CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRCorruptData(this.process, corruptDataException.getMessage()));
                }
            }
            for (IOSThread iOSThread : collection) {
                try {
                    hashMap.put(iOSThread.getThreadId(), new J9DDRImageThread(this.process, iOSThread));
                }
                catch (CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRImageThread(this.process, iOSThread));
                }
            }
            this.cachedThreads = new WeakReference(hashMap);
        }
        return hashMap;
    }

    public Iterator<?> getThreads() {
        Map<Long, Object> map = this.getThreadMap();
        return map.values().iterator();
    }

    public J9DDRBaseImageThread getThread(long l) {
        Map<Long, Object> map = this.getThreadMap();
        return (J9DDRBaseImageThread)map.get(l);
    }

    private static long longByResolvingRawKey(String string, String string2) {
        Pattern pattern = Pattern.compile("\\b" + Pattern.quote(string2) + "=(\\p{XDigit}+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return Long.parseUnsignedLong(matcher.group(1), 16);
        }
        return 0L;
    }

    public String getVersion() {
        return this.version;
    }

    boolean isFailingProcess() throws DataUnavailableException {
        return this.process.isFailingProcess();
    }

    public Properties getProperties() {
        return new Properties();
    }
}

