/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.Pool_29_V0;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import java.util.logging.Logger;

public abstract class Pool<StructType extends DataType> {
    protected J9PoolPointer pool;
    protected Class<StructType> structType;
    protected long elementSize;
    protected static final Logger logger = Logger.getLogger("j9ddr.walkers.pool");

    protected <T extends DataType> Pool(J9PoolPointer j9PoolPointer, Class<T> clazz) throws CorruptDataException {
        this.pool = j9PoolPointer;
        this.structType = clazz;
        if (this.pool.notNull()) {
            this.elementSize = j9PoolPointer.elementSize().longValue();
        }
    }

    public static <T extends DataType> Pool<T> fromJ9Pool(J9PoolPointer j9PoolPointer, Class<T> clazz) throws CorruptDataException {
        return Pool.fromJ9Pool(j9PoolPointer, clazz, true);
    }

    public static <T extends DataType> Pool<T> fromJ9Pool(J9PoolPointer j9PoolPointer, Class<T> clazz, boolean bl) throws CorruptDataException {
        switch (AlgorithmVersion.getVMMinorVersion()) {
            default: 
        }
        logger.fine("Creating version 2.6.0 pool walker");
        return new Pool_29_V0(j9PoolPointer, clazz, bl);
    }

    public abstract long numElements();

    public abstract long capacity();

    public abstract boolean includesElement(StructType var1);

    public abstract SlotIterator<StructType> iterator();
}

