/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.Field;

public class EnumPointer
extends Pointer {
    public static final EnumPointer NULL = new EnumPointer(0L, VoidPointer.class);
    private Class<?> enumClazz;
    private long enumSize = -1L;

    protected EnumPointer(long l, Class<?> clazz) {
        super(l);
        this.enumClazz = clazz;
    }

    public static EnumPointer cast(AbstractPointer abstractPointer, Class<?> clazz) {
        return EnumPointer.cast(abstractPointer.getAddress(), clazz);
    }

    public static EnumPointer cast(UDATA uDATA, Class<?> clazz) {
        return EnumPointer.cast(uDATA.longValue(), clazz);
    }

    public static EnumPointer cast(long l, Class<?> clazz) {
        if (l == 0L) {
            return NULL;
        }
        return new EnumPointer(l, clazz);
    }

    @Override
    public EnumPointer at(long l) throws CorruptDataException {
        throw new UnsupportedOperationException("Use longAt(long index)");
    }

    @Override
    public EnumPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    public long longAt(long l) throws CorruptDataException {
        if (this.sizeOfBaseType() == 1L) {
            return this.getByteAtOffset(l * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 2L) {
            return this.getShortAtOffset(l * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 4L) {
            return this.getIntAtOffset(l * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 8L) {
            return this.getLongAtOffset(l * this.sizeOfBaseType());
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    @Override
    protected long sizeOfBaseType() {
        if (this.enumSize == -1L) {
            try {
                Field field = this.enumClazz.getField("SIZEOF");
                this.enumSize = field.getLong(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException(noSuchFieldException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException.getMessage());
            }
        }
        return this.enumSize;
    }

    public double doubleAt(long l) throws CorruptDataException {
        return this.longAt(l);
    }

    public float floatAt(long l) throws CorruptDataException {
        return this.longAt(l);
    }

    @Override
    public EnumPointer add(long l) {
        return new EnumPointer(this.address + this.sizeOfBaseType() * l, this.enumClazz);
    }

    @Override
    public EnumPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public EnumPointer addOffset(long l) {
        return new EnumPointer(this.address + l, this.enumClazz);
    }

    @Override
    public EnumPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public EnumPointer sub(long l) {
        return new EnumPointer(this.address - this.sizeOfBaseType() * l, this.enumClazz);
    }

    @Override
    public EnumPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public EnumPointer subOffset(long l) {
        return new EnumPointer(this.address - l, this.enumClazz);
    }

    @Override
    public EnumPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public EnumPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public EnumPointer untag(long l) {
        return new EnumPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL), this.enumClazz);
    }
}

