/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9JavaVM;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SetVMCommand
extends Command {
    public SetVMCommand() {
        this.addCommand("setvm", "<address>", "set the JavaVM address");
    }

    private void printHelp(PrintStream printStream) {
        printStream.append("Usage: \n");
        printStream.append("  !setvm <address>\n");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (1 != stringArray.length) {
            this.printHelp(printStream);
            return;
        }
        long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
        J9JavaVMPointer j9JavaVMPointer = J9JavaVMPointer.cast(l);
        if (this.testJavaVMPtr(j9JavaVMPointer)) {
            J9RASHelper.setCachedVM(j9JavaVMPointer);
            printStream.println("VM set to " + j9JavaVMPointer.getHexAddress());
            return;
        }
        J9VMThreadPointer j9VMThreadPointer = J9VMThreadPointer.cast(l);
        try {
            j9JavaVMPointer = j9VMThreadPointer.javaVM();
            if (this.testJavaVMPtr(j9JavaVMPointer)) {
                J9RASHelper.setCachedVM(j9JavaVMPointer);
                printStream.println("VM set to " + j9JavaVMPointer.getHexAddress());
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        printStream.println("Error: Specified value (=" + l + ") is not a javaVM or vmThread pointer, VM not set");
    }

    private boolean testJavaVMPtr(J9JavaVMPointer j9JavaVMPointer) {
        try {
            if (j9JavaVMPointer.reserved1_identifier().longValue() == J9JavaVM.J9VM_IDENTIFIER) {
                return true;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            try {
                Method method = j9JavaVMPointer.getClass().getMethod("reserved1", new Class[0]);
                VoidPointer voidPointer = (VoidPointer)method.invoke((Object)j9JavaVMPointer, new Object[0]);
                Long l = voidPointer.longValue();
                if (l == J9JavaVM.J9VM_IDENTIFIER) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            return false;
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
        return false;
    }
}

