/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.stack;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.stack.IStackTypes;

public class StackSectionParser
extends SectionParser
implements IStackTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public StackSectionParser() {
        super("Stack");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        this.parseStackLine();
    }

    private void parseStackLine() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        while ((iAttributeValueMap = this.processTagLineOptional("BTTHREADID")) != null) {
            long l = iAttributeValueMap.getLongValue("stack_thread");
            while ((iAttributeValueMap = this.processTagLineOptional("1BTSTACKENT")) != null) {
                String string = iAttributeValueMap.getTokenValue("stack_module");
                String string2 = iAttributeValueMap.getTokenValue("stack_routine");
                long l2 = iAttributeValueMap.getLongValue("stack_proc_address");
                long l3 = iAttributeValueMap.getLongValue("stack_routine_address");
                long l4 = iAttributeValueMap.getLongValue("stack_offset");
                String string3 = iAttributeValueMap.getTokenValue("stack_file");
                int n = iAttributeValueMap.getIntValue("stack_line");
                if (l3 == -1L && l2 != -1L && l4 != -1L) {
                    l3 = l2 - l4;
                } else if (l4 == -1L && l2 != -1L && l3 != -1L) {
                    l4 = l2 - l3;
                } else if (l2 == -1L && l4 != -1L && l3 != -1L) {
                    l2 = l3 + l4;
                }
                String string4 = string != null ? string : "";
                if (string3 != null) {
                    string4 = string4 + "(" + string3;
                    if (n != -1) {
                        string4 = string4 + ":" + n;
                    }
                    string4 = string4 + ")";
                }
                if (string != null) {
                    ImageModule imageModule = this.fImageProcessBuilder.addLibrary(string);
                    if (string2 != null && l2 != -1L && l4 != -1L && l3 != -1L) {
                        this.fImageProcessBuilder.addRoutine(imageModule, string2, l3);
                        string4 = string4 + "::" + string2 + (l4 >= 0L ? "+" : "-") + l4;
                    } else if (l4 != -1L) {
                        string4 = string4 + (l4 >= 0L ? "+" : "-") + l4;
                    } else if (l2 != -1L) {
                        string4 = string4 + "::0x" + Long.toHexString(l2);
                    }
                } else {
                    string4 = string2 != null ? (l4 != -1L ? "::" + string2 + (l4 >= 0L ? "+" : "-") + l4 : "::" + string2) : (l2 != -1L ? "::0x" + Long.toHexString(l2) : null);
                }
                this.fImageProcessBuilder.addImageStackFrame(l, string4, 0L, l2);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

